/*!******************************************************************************

  @file         hkb51.h

  ------------------------------------------------------------------------------

  @author       UweH

  @brief        KB_locklist

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HKB51_H
#define HKB51_H


/*===========================================================================*
 *     RefType: C++                                                          *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\x83\x1d\xf2\x7f\x37\x5d\x43\x9d\xb1\xa3\x87\xb0\x99\x84\xef\x0c'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal tsp00_8ByteCounter k51_kb_func_calls;

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51all_req_remove (
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51clear_locklist (
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51close_locklist (
    tsp00_TaskId             TaskId,
    pasbool                  WaitForCheckpt);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb51DelConsistTrans (
    tsp00_TaskId             TaskId,
    tgg91_TransNo         &  ConsistViewNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb51CancelConsistTrans (
    tsp00_TaskId             TaskId,
    tgg91_TransNo         &  ConsistViewNo,
    tsp00_Int4            &  StartDate,
    tsp00_Int4            &  StartTime,
    pasbool                  bUseMinRetentionTime);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51del_transentry_from_locklist (
    tsp00_TaskId             TaskId,
    tgg00_TransIndex      &  TransIndex);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51enter_all_trans_regions (
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51examine_trans (
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb51GetFirstOpenRedoTrans (
    tsp00_TaskId             TaskId,
    tgg00_TransIndex      &  TransIndex);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb51GetNextOpenRedoTrans (
    tsp00_TaskId             TaskId,
    tgg00_TransIndex      &  TransIndex);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb51GetFirstWriteTrans (
    tgg00_TransIndex      &  WriteTransIndex);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb51GetNextWriteTrans (
    tgg00_TransIndex      &  WriteTransIndex);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb51GetRedoTransIndex (
    tsp00_TaskId             TaskId,
    tgg91_TransNo            WriteTransId,
    tgg00_TransIndex      &  TransIndex,
    tgg00_BasisError      &  err);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51get_transindex (
    tsp00_TaskId             TaskId,
    tgg91_SessionNo          WantedSessionId,
    tgg91_TransNo            WantedWriteTransId,
    pasbool                  InTransRegion,
    tgg00_TransIndex      &  TransIndex);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51handle_request_timeout (
    tgg00_TransContext    &  Trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool k51is_closed_locklist (
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool k51is_locklist_generated (
    tsp00_TaskId             taskid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb51IsConsistUsedTransId (
    tsp00_TaskId             TaskId,
    tgg91_TransNo         &  WriteTransId,
    tgg91_TransNo         &  MinConsistUsedTransId,
    pasbool               &  IsTransUsed);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool kb51IsObjTransUsed (
    tsp00_TaskId             TaskId,
    tgg92_KernelOid&         Oid,
    tgg00_ObjTransInfo    &  ObjTransInfo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51leave_all_trans_regions (
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 k51max_locks_per_table ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51new_select_trans (
    tsp00_TaskId             TaskId,
    tgg91_TransNo         &  SelectTransNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51new_session (
    tgg00_TransContext    &  Trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int2 k51number_of_trans_entries ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool k51oms_is_closed_locklist ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb51UpdateMinTrans (
    tsp00_TaskId             TaskId,
    pasbool                  triggerGC);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51ReleaseShutdownWaitTask (
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51remove_locks (
    tsp00_TaskId             TaskId,
    tgg00_TransIndex         TransIndex,
    tgg00_TransState      &  TransState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51remove_locks_2 (
    tgg00_TransContext    &  Trans,
    tgg00_TransIndex         TransIndex,
    tgg00_TransState      &  TransState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51reset_statistics (
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51restart_locklist (
    tgg00_TransContext    &  t);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51row_excl_check (
    tgg00_TransContext    &  t,
    tgg00_Surrogate       &  TabId,
    tgg00_Lkey            &  k);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51set_not_generated ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51set_shutdown_wanted (
    tsp00_TaskId             TaskId,
    tgg00_MessType2_Param     MessType2);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51set_userid (
    tgg00_TransContext    &  t,
    tgg00_UserId          &  UserId,
    tsp00_TermId          &  TermId,
    pasbool                  IsExclusive,
    pasbool                  IsNologSession);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool k51shutdown_wanted (
    tsp00_TaskId             TaskId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void kb51StartConsistTrans (
    tgg00_TransContext    &  Trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51sys_share_remove (
    tsp00_TaskId             TaskId,
    tgg00_TransIndex         TransIndex,
    tgg00_TransState      &  TransState);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51tab_eot_excl_check (
    tgg00_TransContext    &  t,
    tgg00_Surrogate       &  TabId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51temp_tab_share_unlock (
    tgg00_TransContext    &  t,
    tgg00_Surrogate       &  WantedTabid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51unlock_table (
    tsp00_TaskId             TaskId,
    tgg00_TransIndex         TransIndex,
    tgg00_TransState      &  TransState,
    tgg00_Lock            &  Lock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51WaitForLastOpenTransaction (
    tgg00_TransContext    &  Trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void k51WaitForAllOlderActiveTransToStop (
    tgg00_TransContext    &  Trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

