/*!
    @file    DBMSrvFrmCmd_Arguments.hpp
    @author  BerndV
    @ingroup DBMServer commands
    @brief   object to analyze the command arguments 

    ========== licence begin  GPL
    Copyright (c) 2002-2006 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
*/

#include "gcn00_1.h"
#include "DBM/Srv/Framework/Command/DBMSrvFrmCmd_Arguments.hpp"

/*! @brief constructor
 */
DBMSrvFrmCmd_Arguments::DBMSrvFrmCmd_Arguments
        ( const char * Arguments,
          const char * Syntax,
          const char * Command )
          : m_Arguments(Arguments),
            m_Syntax(Syntax),
            m_Command(Command),
            m_pParser(0)
{

    // nothing to do here

} // end DBMSrvFrmCmd_Arguments::DBMSrvFrmCmd_Arguments

/*! @brief destructor
 */
DBMSrvFrmCmd_Arguments::~DBMSrvFrmCmd_Arguments
        ( )
{
    if (0 != m_pParser) {
        delete m_pParser;
    } // end if
} // end DBMSrvFrmCmd_Arguments::~DBMSrvFrmCmd_Arguments

/*! @brief public member
 */
const ToolsParsers_ParseResult & DBMSrvFrmCmd_Arguments::parse
        ( DBMSrvMsg_Error & Error )
{
    // put the arguments into the converter
    m_oConverter.setTo(m_Arguments);

    m_pParser = new ToolsParsers_ProgramParameterParser((int) m_oConverter.getNumberOfArguments(), m_oConverter.getArgumentArray(), m_Syntax, false);

    if (0 == m_pParser) {
        // generate memory error
        SAPDBErr_MessageList oMsg("DBM", __FILE__, __LINE__, SAPDBErr_MessageList::Error, cn00_1_ErrId( ERR_MEM_CN00_1 ), cn00_1_ErrTxt( ERR_MEM_CN00_1 ), 0);
        Error.AppendNewMessage(oMsg);

        // return a dummy reference
        return m_oDummyParseResult;
    } // end if

    const ToolsParsers_ParseResult & oResult = m_pParser->parse();
    ToolsParsers_ParseResult::ResultCode nResult = oResult.getResultCode();

    if (nResult != ToolsParsers_ParseResult::NoError) {
        switch (nResult) {
            case ToolsParsers_ParseResult::ErrorOutOfMemory:
            {
                SAPDBErr_MessageList oMsg("DBM", __FILE__, __LINE__, SAPDBErr_MessageList::Error, cn00_1_ErrId( ERR_MEM_CN00_1 ), cn00_1_ErrTxt( ERR_MEM_CN00_1 ), 0);
                Error.AppendNewMessage(oMsg);
                break;
            }
            case ToolsParsers_ParseResult::ErrorSyntax:
            {
                SAPDBErr_MessageList oMsg("DBM", __FILE__, __LINE__, SAPDBErr_MessageList::Error, cn00_1_ErrId( ERR_PARAM_CN00_1 ), cn00_1_ErrTxt( ERR_PARAM_CN00_1 ), 0);
                Error.AppendNewMessage(oMsg);
                break;
            }
            case ToolsParsers_ParseResult::ErrorUnsupportedSyntaxDescription:
            default:
            {
                SAPDBErr_MessageList oMsg("DBM", __FILE__, __LINE__, SAPDBErr_MessageList::Error, cn00_1_ErrId( ERR_CN00_1 ), cn00_1_ErrTxt( ERR_CN00_1 ), 0);
                Error.AppendNewMessage(oMsg);
                break;
            }
        } // end switch

        return m_oDummyParseResult;
    } // end if

    return oResult;
} // end DBMSrvFrmCmd_Arguments::parse
