/*!
  \file    DBMSrvCmdAuto_AutologOn.hpp
  \author  TiloH
  \ingroup DBMServer commands
  \brief   declaration of a class handling DBM Server command autolog_on

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2007 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif
*/

#if !defined(DBMSrvCmdAuto_AutologOn_hpp)
#define DBMSrvCmdAuto_AutologOn_hpp

#include "SAPDB/DBM/Srv/DBMSrv_Command.hpp"

/*! \brief A class for handling the DBMServer command autolog_on
    
    The autolog_on command starts the automatic log backup */
class DBMSrvCmdAuto_AutologOn: public DBMSrv_Command
{
  public:
    DBMSrvCmdAuto_AutologOn();

    /*! the function implementing the autolog_on command for 7.5.00
        \param vcontrol    [INOUT] DBMServer session data
        \param command     [IN]    DBMServer command
        \param replyData   [OUT]   reply buffer
        \param replyLen    [OUT]   lenght of reply
        \param replyLenMax [IN]    max. length of reply buffer
        \return error code specified in gcn00.h */
    static tcn00_Error runCommand(VControlDataT * vcontrol,
                                  CommandT      * command,
                                  char          * replyData,
                                  int           * replyLen,
                                  int             replyLenMax);

    static const char * const m_LongHelp;
};

#endif
