/*!
 * \file    LVCMem_CheckedUserAllocator.hpp
 * \author  IvanS
 * \brief   LiveCache user allocator checked wrapper (for session-specific memory).
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*/

#ifndef __LVCMEM_CHECKEDUSERALLOCATOR_HPP
#define __LVCMEM_CHECKEDUSERALLOCATOR_HPP

#include "liveCache/MemoryManagement/LVCMem_UserAllocator.hpp"

class LVCMem_CheckedUserAllocator : public OmsAllocatorInterface, public SAPDBMem_RawAllocator
{
public:
  LVCMem_CheckedUserAllocator(const SAPDB_UTF8* pName, SAPDBMem_IRawAllocator *parent, int code);

  ~LVCMem_CheckedUserAllocator();

  virtual void *omsAllocate(size_t size);

  virtual void omsDeallocate(void *p);

  virtual void* Allocate(SAPDB_ULong ByteCount);

  virtual void* Allocate(SAPDB_ULong ByteCount, const void*);

  virtual void Deallocate(void* p);

  virtual bool omsCheckAllocatorEmpty();

  virtual void omsRegisterCallback(OmsCallbackInterface *cb);

  virtual OmsCallbackInterface *omsGetCallback() const;

  virtual int omsGetAllocatorType() const;

private:
  LVCMem_UserAllocator    *m_alloc;
  int                     m_code;
  unsigned long           m_allocSize;
};

#endif  // __LVCMEM_CHECKEDUSERALLOCATOR_HPP