/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.util;

/**
 *
 */
public class FullswapMem
    extends StructuredBytes
{
    /**
     * FullswapMem constructor comment.
     * @param data byte[]
     */
    public FullswapMem(byte[] data) {
        super(data);
    }
    /**
     * FullswapMem constructor comment.
     * @param data byte[]
     * @param offset int
     */
    public FullswapMem(byte[] data, int offset) {
        super(data, offset);
    }
    /**
     * FullswapMem constructor comment.
     * @param size int
     */
    public FullswapMem(int size) {
        super(size);
    }
    /**
     * Read a signed two byte integer from <i>offset</i>
     * @return int
     * @param offset int
     */
    public int
    getInt2 (
        int offset)
    {
        int result;
        int lowerByte;

        lowerByte = this.data [offset + this.ptrOffs];
        if (lowerByte < 0) {
            lowerByte += 256;
        }
        result = (this.data [offset + this.ptrOffs + 1] * 256) + lowerByte;
        return result;
    }
    /**
     * Read a signed four byte integer from <i>offset</i>
     * @return int
     * @param offset int
     */
    public int
    getInt4 (
        int offset)
    {
        byte[] d=this.data;
        int result = 0;
        int oneByte;
        int ofs=offset + this.ptrOffs;
        
        for (int i = 3; i >= 0; --i) {
            oneByte = d [ofs + i];
            if (oneByte < 0) {
                oneByte += 256;
            }
            result = (result * 256) + oneByte;
        }
        return result;
        
                
    }
    
    /**
     * Write a signed two byte inter at <i>offset</i>
     * @param value int
     * @param offset int
     */
    public void
    putInt2 (
        int value,
        int offset)
    {
        this.data [offset + this.ptrOffs + 1] = (byte) (value / 256);
        this.data [offset + this.ptrOffs] = (byte)(value % 256);
        return;
    }
    /**
     * Write a signed four byte integer at <i>offset</i>
     * @param value int
     * @param offset int
     */
    public void
    putInt4 (
        int value,
        int offset)
    {
        offset += this.ptrOffs;
        for (int i = 0; i <3; ++i) {
            this.data [offset + i] = (byte) (value % 256);
            value = value / 256;
        }
        this.data [offset + 3] = (byte) value;
        return;
    }
}
