/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.util.MemIndirection;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public abstract class DataPart
extends MemIndirection {
    private static final int maxArgCount = Short.MAX_VALUE;
    protected int argCount = 0;
    protected int extent = 0;
    protected int massExtent = 0;
    private boolean isFull = false;
    StructuredMem originalMem;
    RequestPacket requestPacket;

    DataPart(StructuredMem structuredMem, RequestPacket requestPacket) {
        super(structuredMem);
        this.originalMem = structuredMem.getPointer(0);
        this.requestPacket = requestPacket;
    }

    public abstract void addArg(int var1, int var2);

    public void close() {
        int n = -14;
        this.originalMem.putInt2(this.argCount, n);
        this.requestPacket.closePart(this.massExtent + this.extent, this.argCount);
    }

    public void closeArrayPart(int n) {
        int n2 = -14;
        this.originalMem.putInt2(n, n2);
        this.requestPacket.closePart(this.massExtent + this.extent * n, n);
    }

    protected int getMaxDataSize() {
        return this.size() - this.extent - 8;
    }

    public boolean hasRoomFor(int n, int n2) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > n + n2;
    }

    public boolean hasRoomFor(int n) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > n;
    }

    public int getExtent() {
        return this.extent;
    }

    public void setFirstPart() {
        this.requestPacket.addPartAttribute(4);
    }

    public void setLastPart() {
        this.requestPacket.addPartAttribute(1);
    }

    public void moveRecordBase() {
        this.moveBase(this.extent);
        this.massExtent += this.extent;
        this.extent = 0;
    }

    public abstract void putDefineByte(int var1, int var2);

    public void markEmptyStream(StructuredMem structuredMem) {
        structuredMem.putInt1(2, 27);
        structuredMem.putInt4(this.massExtent + this.extent + 1, 32);
        structuredMem.putInt4(0, 36);
    }

    public abstract boolean fillWithOMSReader(Reader var1, int var2) throws SQLException;

    public abstract boolean fillWithProcedureReader(Reader var1, short var2) throws SQLException;

    public abstract void addRow(int var1);

    public abstract void putNull(int var1, int var2);

    public abstract void putDefault(int var1, int var2);

    public abstract StructuredMem putDescriptor(int var1, byte[] var2);

    public abstract void fillWithOMSReturnCode(int var1) throws SQLExceptionSapDB;

    public abstract boolean fillWithOMSStream(InputStream var1, boolean var2) throws SQLException;

    public abstract boolean fillWithProcedureStream(InputStream var1, short var2) throws SQLException;

    public boolean fillWithStream(InputStream inputStream, StructuredMem structuredMem, Putval putval) throws SQLException {
        int n = this.getMaxDataSize();
        if (n <= 1) {
            structuredMem.putInt1(3, 27);
            return false;
        }
        int n2 = this.extent;
        byte[] byArray = new byte[4096];
        boolean bl = false;
        try {
            while (!bl && n > 0) {
                int n3 = inputStream.read(byArray, 0, Math.min(n, 4096));
                if (n3 == -1) {
                    bl = true;
                    continue;
                }
                this.mem.putBytes(byArray, this.extent, n3);
                this.extent += n3;
                n -= n3;
            }
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
        }
        if (bl) {
            structuredMem.putInt1(2, 27);
        } else {
            structuredMem.putInt1(0, 27);
        }
        structuredMem.putInt4(this.massExtent + n2 + 1, 32);
        structuredMem.putInt4(this.extent - n2, 36);
        putval.markRequestedChunk(this.getPointer(n2), this.extent - n2);
        return bl;
    }

    public boolean fillWithReader(Reader reader, StructuredMem structuredMem, Putval putval) throws SQLException {
        int n = (this.size() - this.extent - 8) / 2;
        if (n <= 1) {
            structuredMem.putInt1(3, 27);
            return false;
        }
        int n2 = this.extent;
        char[] cArray = new char[4096];
        boolean bl = false;
        try {
            while (!bl && n > 0) {
                int n3 = reader.read(cArray, 0, Math.min(n, 4096));
                if (n3 == -1) {
                    bl = true;
                    continue;
                }
                this.mem.putBigUnicode(cArray, this.extent, n3 * 2);
                this.extent += n3 * 2;
                n -= n3;
            }
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
        }
        if (bl) {
            structuredMem.putInt1(2, 27);
        } else {
            structuredMem.putInt1(0, 27);
        }
        structuredMem.putInt4(this.massExtent + n2 + 1, 32);
        structuredMem.putInt4(this.extent - n2, 36);
        putval.markRequestedChunk(this.getPointer(n2), this.extent - n2);
        return bl;
    }
}

