#!/usr/bin/env python
"""
This provides examples of uses of interactive functions, such as ginput,
waitforbuttonpress and manual clabel placement.

This script must be run interactively using a backend that has a
graphical user interface (for example, using GTKAgg backend, but not
PS backend).

See also ginput_demo.py
"""
import time
import matplotlib
import numpy as np
import matplotlib.cm as cm
import matplotlib.mlab as mlab
import matplotlib.pyplot as plt

def tellme(s):
    print s
    plt.title(s,fontsize=16)
    plt.draw()

##################################################
# Define a triangle by clicking three points
##################################################
plt.clf()
plt.axis([-1.,1.,-1.,1.])
plt.setp(plt.gca(),autoscale_on=False)

tellme('You will define a triangle, click to begin')

plt.waitforbuttonpress()

happy = False
while not happy:
    pts = []
    while len(pts) < 3:
        tellme('Select 3 corners with mouse')
        pts = np.asarray( plt.ginput(3,timeout=-1) )
        if len(pts) < 3:
            tellme('Too few points, starting over')
            time.sleep(1) # Wait a second

    ph = plt.fill( pts[:,0], pts[:,1], 'r', lw=2 )

    tellme('Happy? Key click for yes, mouse click for no')

    happy = plt.waitforbuttonpress()

    # Get rid of fill
    if not happy:
        for p in ph: p.remove()

##################################################
# Now contour according to distance from triangle
# corners - just an example
##################################################

# Define a nice function of distance from individual pts
def f(x,y,pts):
    z = np.zeros_like(x)
    for p in pts:
        z = z + 1/(np.sqrt((x-p[0])**2+(y-p[1])**2))
    return 1/z

X,Y = np.meshgrid( np.linspace(-1,1,51), np.linspace(-1,1,51) )
Z = f(X,Y,pts)

CS = plt.contour( X, Y, Z, 20 )

tellme( 'Use mouse to select contour label locations, middle button to finish' )
CL = plt.clabel( CS, manual=True )

##################################################
# Now do a zoom
##################################################
tellme( 'Now do a nested zoom, click to begin' )
plt.waitforbuttonpress()

happy = False
while not happy:
    tellme( 'Select two corners of zoom, middle mouse button to finish' )
    pts = np.asarray( plt.ginput(2,timeout=-1) )

    happy = len(pts) < 2
    if happy: break

    pts = np.sort(pts,axis=0)
    plt.axis( pts.T.ravel() )

tellme('All Done!')
plt.show()
