# $Id: shapefiletest.py 4384 2005-02-06 21:09:04Z sean $
#
# Project:  MapServer
# Purpose:  xUnit style Python mapscript tests of shapefileObj
# Author:   Sean Gillies, sgillies@frii.com
#
# ===========================================================================
# Copyright (c) 2004, Sean Gillies
# 
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
# ===========================================================================
#
# Execute this module as a script from mapserver/mapscript/python
#
#     python tests/cases/shapefiletest.py -v
#
# ===========================================================================

import unittest

# the testing module helps us import the pre-installed mapscript
from testing import mapscript

class AddShapeTestCase(unittest.TestCase):

    def testAddEmpty(self):
        """expect an error rather than segfault when adding an empty shape"""
        # See bug 1201
        sf = mapscript.shapefileObj('testAddDud.shp', 1)
        so = mapscript.shapeObj(mapscript.MS_SHAPE_POINT)
        self.assertRaises(mapscript.MapServerError, sf.add, so)
        
if __name__ == '__main__':
    unittest.main()
