# -*- Shell-script -*-
%define rel    1
%define prefix /usr

Summary: GNU Mailutils
Name: mailutils
Version: 0.4.1
Release: %rel
Copyright: GPL
Source: ftp://ftp.gnu.org/gnu/%{name}/%{name}-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
URL: http://www.gnu.org/software/%{name}/%{name}.html
Group: Console/Mail
Requires: libmailutils, guile >= 1.6, readline
BuildRequires: guile >= 1.6, readline-devel, emacs

%description
GNU Mailutils contains a series of useful mail clients, servers, and
libraries. These are the primary mail utilities of the GNU system.
This package provides a replacement for /bin/mail(x) conforming to
the UNIX98 specification for mailx. Provides also mail.local,
mail.remote, and other tools including guimb, dotlock, movemail,
frm.

%package -n libmailutils
Summary: GNU Mailutils: mailbox access library.
Copyright: LGPL
Group: System Environment/Libraries

%description -n libmailutils
The runtime library libmailbox contains various mailbox access
routines and support for a number of mailbox types, such as mbox,
maildir, mh, POP3, and IMAP4. It also supports MIME message
handling, and sending mail via SMTP and /sbin/sendmail.

%package -n libmailutils-dev
Summary: GNU Mailutils: mailbox access library development.
Copyright: LGPL
Requires: libmailutils
Group: Development/Libraries

%description -n libmailutils-dev
The static libraries and header files for GNU Mailutils.

%package doc
Summary: GNU Mailutils: documentation.
Copyright: FDL
Prereq: /sbin/install-info
Group: Development/Libraries

%description doc
API reference for libmailbox and user documentation for the rest of
the GNU Mailutils.

%package -n mailutils-pop3d
Summary: GNU Mailutils: POP3 daemon.
Copyright: GPL
Requires: libmailutils
Group: Networking/Daemons

%description -n mailutils-pop3d
The GNU POP3 daemon. Uses libmailbox to support different styles of
mailboxes.

%package -n mailutils-imap4d
Summary: GNU Mailutils: IMAP4 daemon.
Copyright: GPL
Requires: libmailutils
Group: Networking/Daemons

%description -n mailutils-imap4d
The GNU IMAP4 daemon. Uses libmailbox to support different styles of
mailboxes.

%package -n mailutils-sieve
Summary: GNU Mailutils: mail filtering language Sieve.
Copyright: LGPL
Requires: libmailutils
Group: System Environment/Libraries

%description -n mailutils-sieve
Libsieve is the GNU implementation of the mail filtering language Sieve,
described in RFC 3028 and RFC 3431. This packages contains also the
Sieve interpreter and Sieve to Scheme translator and filter.

%package -n mailutils-comsatd
Summary: GNU Mailutils: Comsat daemon.
Copyright: GPL
Requires: libmailutils
Group: Networking/Daemons

%description -n mailutils-comsatd
The GNU Comsat daemon.

%package -n mailutils-mh
Summary: GNU Mailutils: The Message Handling System.
Copyright: GPL
Requires: libmailutils
Group: Console/Mail

%description -n mailutils-mh
The GNU MH (Message Handling System).

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix --enable-mh-utils
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT
make distclean

%post -n libmailutils -p /sbin/ldconfig
%postun -n libmailutils -p /sbin/ldconfig
%post -n mailutils-sieve -p /sbin/ldconfig
%postun -n mailutils-sieve -p /sbin/ldconfig

%post doc
/sbin/install-info %{prefix}/info/mailutils.info.gz %{prefix}/info/dir

%preun doc
/sbin/install-info --delete %{prefix}/info/mailutils.info.gz %{prefix}/info/dir

%files -n mailutils
%defattr(-, root, root)
%{prefix}/bin/dotlock
%{prefix}/bin/frm
%{prefix}/bin/from
%{prefix}/bin/guimb
%{prefix}/bin/mail
%{prefix}/bin/messages
%{prefix}/bin/movemail
%{prefix}/bin/readmsg
%{prefix}/libexec/*
%{prefix}/share/mailutils/*.scm

%files -n libmailutils
%defattr(-, root, root)
%{prefix}/lib/libmailbox.so.*
%{prefix}/lib/libmu*.so.*
%{prefix}/share/mailutils/mailutils.scm
%{prefix}/share/mailutils/*.txt
%{prefix}/share/locale/*/LC_MESSAGES/mailutils.mo

%files -n libmailutils-dev
%defattr(-, root, root)
%{prefix}/bin/mailutils-config
%{prefix}/lib/libmailbox.*a
%{prefix}/lib/libsieve.*a
%{prefix}/lib/libmu*.*a
%{prefix}/include

%files doc
%defattr(-, root, root)
%doc AUTHORS COPYING* ChangeLog NEWS README THANKS TODO
%{prefix}/info/*

%files -n mailutils-pop3d
%defattr(-, root, root)
%{prefix}/sbin/pop3d
%{prefix}/man/*/pop*

%files -n mailutils-imap4d
%defattr(-, root, root)
%{prefix}/sbin/imap4d
%{prefix}/man/*/imap4d*

%files -n mailutils-comsatd
%defattr(-, root, root)
%{prefix}/sbin/comsatd

%files -n mailutils-sieve
%defattr(-, root, root)
%{prefix}/bin/sieve*
%{prefix}/lib/libsieve.so.*
%{prefix}/lib/mailutils/list*
%{prefix}/lib/mailutils/numaddr*
%{prefix}/lib/mailutils/spamd*
%{prefix}/lib/mailutils/timestamp*

%files -n mailutils-mh
%defattr(-, root, root)
%{prefix}/bin/mu-mh/anno
%{prefix}/bin/mu-mh/comp
%{prefix}/bin/mu-mh/fmtcheck
%{prefix}/bin/mu-mh/folder
%{prefix}/bin/mu-mh/forw
%{prefix}/bin/mu-mh/inc
%{prefix}/bin/mu-mh/install-mh
%{prefix}/bin/mu-mh/mark
%{prefix}/bin/mu-mh/mhl
%{prefix}/bin/mu-mh/mhn
%{prefix}/bin/mu-mh/mhpath
%{prefix}/bin/mu-mh/pick
%{prefix}/bin/mu-mh/refile
%{prefix}/bin/mu-mh/repl
%{prefix}/bin/mu-mh/rmf
%{prefix}/bin/mu-mh/rmm
%{prefix}/bin/mu-mh/scan
%{prefix}/bin/mu-mh/send
%{prefix}/bin/mu-mh/sortm
%{prefix}/bin/mu-mh/whatnow
%{prefix}/bin/mu-mh/whom
%{prefix}/share/mailutils/mh/*
%{prefix}/share/emacs/site-lisp/*
