/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "mn-gmail-mailbox.h"

#include "mn-gmail-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 30 "mn-gmail-mailbox.gob"

#include "config.h"
#include <string.h>
#ifdef HAVE_TIMEGM
#include <stdlib.h>
#include <time.h>
#ifdef TM_IN_SYS_TIME
#include <sys/time.h>
#endif /* TM_IN_SYS_TIME */
#endif /* HAVE_TIMEGM */
#include <glib/gi18n.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include "mn-mailbox-private.h"
#include "mn-authenticated-mailbox-private.h"
#include "mn-vfs.h"
#include "mn-stock.h"
#include "mn-message.h"
#include "mn-util.h"

#line 45 "mn-gmail-mailbox.c"
/* self casting macros */
#define SELF(x) MN_GMAIL_MAILBOX(x)
#define SELF_CONST(x) MN_GMAIL_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_GMAIL_MAILBOX(x)
#define TYPE_SELF MN_TYPE_GMAIL_MAILBOX
#define SELF_CLASS(x) MN_GMAIL_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_GMAIL_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNGmailMailbox Self;
typedef MNGmailMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_gmail_mailbox_class_init (MNGmailMailboxClass * class) G_GNUC_UNUSED;
static void mn_gmail_mailbox_init (MNGmailMailbox * self) G_GNUC_UNUSED;
static void ___3_mn_gmail_mailbox_seal (MNMailbox * mailbox) G_GNUC_UNUSED;
static void ___4_mn_gmail_mailbox_authenticated_check (MNAuthenticatedMailbox * mailbox) G_GNUC_UNUSED;
static void mn_gmail_mailbox_parse_entry (xmlNode * node, time_t * sent_time, char ** id, char ** from, char ** subject, char ** url) G_GNUC_UNUSED;
static char * mn_gmail_mailbox_parse_author (xmlNode * node) G_GNUC_UNUSED;
static time_t mn_gmail_mailbox_parse_date (const char * w3c_datetime) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_LOCATION
};

/* pointer to the class of our parent */
static MNAuthenticatedMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_parse_entry mn_gmail_mailbox_parse_entry
#define self_parse_author mn_gmail_mailbox_parse_author
#define self_parse_date mn_gmail_mailbox_parse_date
#define self_build_name mn_gmail_mailbox_build_name
GType
mn_gmail_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNGmailMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_gmail_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNGmailMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_gmail_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_AUTHENTICATED_MAILBOX, "MNGmailMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNGmailMailbox *)g_object_new(mn_gmail_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNGmailMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNGmailMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNGmailMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNGmailMailbox *)g_object_new_valist (mn_gmail_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dispose"
	MNGmailMailbox *self G_GNUC_UNUSED = MN_GMAIL_MAILBOX (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 59 "mn-gmail-mailbox.gob"
	if(self->_priv->uri) { gnome_vfs_uri_unref ((gpointer) self->_priv->uri); self->_priv->uri = NULL; }
#line 135 "mn-gmail-mailbox.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::finalize"
	MNGmailMailbox *self G_GNUC_UNUSED = MN_GMAIL_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 53 "mn-gmail-mailbox.gob"
	if(self->location) { g_free ((gpointer) self->location); self->location = NULL; }
#line 150 "mn-gmail-mailbox.c"
}
#undef __GOB_FUNCTION__

#line 61 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_class_init (MNGmailMailboxClass * class G_GNUC_UNUSED)
#line 157 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;
	MNAuthenticatedMailboxClass *mn_authenticated_mailbox_class = (MNAuthenticatedMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNGmailMailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_AUTHENTICATED_MAILBOX);

#line 78 "mn-gmail-mailbox.gob"
	mn_mailbox_class->seal = ___3_mn_gmail_mailbox_seal;
#line 87 "mn-gmail-mailbox.gob"
	mn_authenticated_mailbox_class->authenticated_check = ___4_mn_gmail_mailbox_authenticated_check;
#line 172 "mn-gmail-mailbox.c"
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("location" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 "https://mail.google.com/mail/feed/atom" /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_REQUIRED | MN_MAILBOX_PARAM_PERMANENT | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_LOCATION,
		param_spec);
    }
 {
#line 62 "mn-gmail-mailbox.gob"

    MN_MAILBOX_CLASS(class)->type = "gmail";

    /*
     * 5 minutes is a good default check delay for remote Gmail
     * mailboxes.
     */
    MN_MAILBOX_CLASS(class)->default_check_delay = 60 * 5;
  
#line 201 "mn-gmail-mailbox.c"
 }
}
#undef __GOB_FUNCTION__
#line 72 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_init (MNGmailMailbox * self G_GNUC_UNUSED)
#line 208 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_GMAIL_MAILBOX,MNGmailMailboxPrivate);
 {
#line 73 "mn-gmail-mailbox.gob"

    mn_mailbox_set_format(MN_MAILBOX(self), "Gmail");
    mn_mailbox_set_stock_id(MN_MAILBOX(self), MN_STOCK_GMAIL);
  
#line 218 "mn-gmail-mailbox.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::set_property"
{
	MNGmailMailbox *self G_GNUC_UNUSED;

	self = MN_GMAIL_MAILBOX (object);

	switch (property_id) {
	case PROP_LOCATION:
		{
#line 54 "mn-gmail-mailbox.gob"
{ char *old = self->location; self->location = g_value_dup_string (VAL); g_free (old); }
#line 239 "mn-gmail-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::get_property"
{
	MNGmailMailbox *self G_GNUC_UNUSED;

	self = MN_GMAIL_MAILBOX (object);

	switch (property_id) {
	case PROP_LOCATION:
		{
#line 54 "mn-gmail-mailbox.gob"
g_value_set_string (VAL, self->location);
#line 270 "mn-gmail-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 78 "mn-gmail-mailbox.gob"
static void 
___3_mn_gmail_mailbox_seal (MNMailbox * mailbox G_GNUC_UNUSED)
#line 290 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->seal) \
		(* MN_MAILBOX_CLASS(parent_class)->seal)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::seal"
{
#line 80 "mn-gmail-mailbox.gob"
	
    PARENT_HANDLER(mailbox);

    if (! mailbox->runtime_name)
      mailbox->runtime_name = self_build_name(MN_AUTHENTICATED_MAILBOX(mailbox)->username);
  }}
#line 304 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 87 "mn-gmail-mailbox.gob"
static void 
___4_mn_gmail_mailbox_authenticated_check (MNAuthenticatedMailbox * mailbox G_GNUC_UNUSED)
#line 311 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->authenticated_check) \
		(* MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->authenticated_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::authenticated_check"
{
#line 89 "mn-gmail-mailbox.gob"
	
    Self *self = SELF(mailbox);
    GnomeVFSResult result;
    char *atom;
    int atom_size;
    xmlDoc *doc;
    xmlNode *node;

    if (! selfp->uri)
      {
	selfp->uri = gnome_vfs_uri_new(self->location);
	if (! selfp->uri)
	  {
	    GDK_THREADS_ENTER();

	    mn_mailbox_set_error(MN_MAILBOX(self), _("invalid feed location"));
	    /* error is not recoverable, disable the mailbox */
	    mn_mailbox_set_poll(MN_MAILBOX(self), FALSE);

	    gdk_flush();
	    GDK_THREADS_LEAVE();

	    return;
	  }

	gnome_vfs_uri_set_user_name(selfp->uri, mailbox->username);
	gnome_vfs_uri_set_password(selfp->uri, mailbox->password);
      }

    mn_mailbox_notice(MN_MAILBOX(self), _("retrieving feed from %s"), self->location);

    result = mn_vfs_read_entire_file_uri(selfp->uri, &atom_size, &atom);
    if (result != GNOME_VFS_OK)
      {
	GDK_THREADS_ENTER();

	mn_mailbox_set_error(MN_MAILBOX(self), _("unable to retrieve feed: %s"), gnome_vfs_result_to_string(result));

	gdk_flush();
	GDK_THREADS_LEAVE();

	return;
      }

    doc = xmlParseMemory(atom, atom_size);
    g_free(atom);

    if (! doc)
      {
	GDK_THREADS_ENTER();

	mn_mailbox_set_error(MN_MAILBOX(self), _("unable to parse feed"));

	gdk_flush();
	GDK_THREADS_LEAVE();

	return;
      }

    node = xmlDocGetRootElement(doc);
    if (node && ! strcmp(node->name, "feed"))
      {
	GSList *messages = NULL;

	for (node = node->children; node != NULL; node = node->next)
	  if (node->type == XML_ELEMENT_NODE && ! strcmp(node->name, "entry"))
	    {
	      time_t sent_time;
	      char *id;
	      char *from;
	      char *subject;
	      char *url;

	      self_parse_entry(node, &sent_time, &id, &from, &subject, &url);

	      messages = g_slist_prepend(messages, mn_message_new(MN_MAILBOX(self),
								  NULL,
								  sent_time,
								  id,
								  from,
								  subject,
								  url,
								  MN_MESSAGE_NEW));

	      g_free(id);
	      g_free(from);
	      g_free(subject);
	      g_free(url);
	    }

	GDK_THREADS_ENTER();

	mn_mailbox_set_messages(MN_MAILBOX(self), messages);
	mn_g_object_slist_free(messages);

	gdk_flush();
	GDK_THREADS_LEAVE();
      }
    else
      {
	GDK_THREADS_ENTER();

	mn_mailbox_set_error(MN_MAILBOX(self), _("unable to parse feed"));

	gdk_flush();
	GDK_THREADS_LEAVE();
      }

    xmlFreeDoc(doc);
  }}
#line 429 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 200 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_parse_entry (xmlNode * node, time_t * sent_time, char ** id, char ** from, char ** subject, char ** url)
#line 436 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::parse_entry"
#line 200 "mn-gmail-mailbox.gob"
	g_return_if_fail (node != NULL);
#line 200 "mn-gmail-mailbox.gob"
	g_return_if_fail (sent_time != NULL);
#line 200 "mn-gmail-mailbox.gob"
	g_return_if_fail (id != NULL);
#line 200 "mn-gmail-mailbox.gob"
	g_return_if_fail (from != NULL);
#line 200 "mn-gmail-mailbox.gob"
	g_return_if_fail (subject != NULL);
#line 200 "mn-gmail-mailbox.gob"
	g_return_if_fail (url != NULL);
#line 451 "mn-gmail-mailbox.c"
{
#line 207 "mn-gmail-mailbox.gob"
	
    *sent_time = 0;
    *id = NULL;
    *from = NULL;
    *subject = NULL;
    *url = NULL;

    for (node = node->children; node != NULL; node = node->next)
      if (node->type == XML_ELEMENT_NODE)
	{
	  if (! strcmp(node->name, "title"))
	    {
	      g_free(*subject);
	      *subject = xmlNodeGetContent(node);
	    }
	  else if (! strcmp(node->name, "id"))
	    {
	      g_free(*id);
	      *id = xmlNodeGetContent(node);
	    }
	  else if (! strcmp(node->name, "author"))
	    {
	      g_free(*from);
	      *from = self_parse_author(node);
	    }
	  else if (! strcmp(node->name, "link"))
	    {
	      g_free(*url);
	      *url = xmlGetProp(node, "href");
	    }
#ifdef HAVE_TIMEGM
	  else if (! strcmp(node->name, "issued"))
	    {
	      char *w3c_datetime;

	      w3c_datetime = xmlNodeGetContent(node);
	      if (w3c_datetime)
		{
		  *sent_time = self_parse_date(w3c_datetime);
		  g_free(w3c_datetime);
		}
	    }
#endif
	}
  }}
#line 499 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 253 "mn-gmail-mailbox.gob"
static char * 
mn_gmail_mailbox_parse_author (xmlNode * node)
#line 505 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::parse_author"
#line 253 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (node != NULL, (char * )0);
#line 510 "mn-gmail-mailbox.c"
{
#line 255 "mn-gmail-mailbox.gob"
	
    char *from;
    char *name = NULL;
    char *email = NULL;

    for (node = node->children; node != NULL; node = node->next)
      if (node->type == XML_ELEMENT_NODE)
	{
	  if (! strcmp(node->name, "name"))
	    {
	      g_free(name);
	      name = xmlNodeGetContent(node);
	    }
	  else if (! strcmp(node->name, "email"))
	    {
	      g_free(email);
	      email = xmlNodeGetContent(node);
	    }
	}

    from = name && email
      ? g_strdup_printf("%s <%s>", name, email)
      : g_strdup(name ? name : email);

    g_free(name);
    g_free(email);

    return from;
  }}
#line 542 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 285 "mn-gmail-mailbox.gob"
static time_t 
mn_gmail_mailbox_parse_date (const char * w3c_datetime)
#line 548 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::parse_date"
#line 285 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (w3c_datetime != NULL, (time_t )0);
#line 553 "mn-gmail-mailbox.c"
{
#line 287 "mn-gmail-mailbox.gob"
	
#ifdef HAVE_TIMEGM
    time_t t = 0;
    char year[5];
    char month[3];
    char day[3];
    char hour[3];
    char minute[3];
    char second[3];

    if (sscanf(w3c_datetime, "%4s-%2s-%2sT%2s:%2s:%2sZ", year, month, day, hour, minute, second) == 6
	&& mn_str_isnumeric(year)
	&& mn_str_isnumeric(month)
	&& mn_str_isnumeric(day)
	&& mn_str_isnumeric(hour)
	&& mn_str_isnumeric(minute)
	&& mn_str_isnumeric(second))
      {
	struct tm tm = { 0 };

	tm.tm_sec = atoi(second);
	tm.tm_min = atoi(minute);
	tm.tm_hour = atoi(hour);
	tm.tm_mday = atoi(day);
	tm.tm_mon = atoi(month) - 1;
	tm.tm_year = atoi(year) - 1900;

	t = timegm(&tm);
	if (t == -1)
	  t = 0;
      }

    return t;
#else
    g_assert_not_reached();
    return 0;
#endif
  }}
#line 594 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 326 "mn-gmail-mailbox.gob"
char * 
mn_gmail_mailbox_build_name (const char * username)
#line 600 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::build_name"
{
#line 328 "mn-gmail-mailbox.gob"
	
    if (username)
      return g_str_has_suffix(username, "@gmail.com")
	? g_strdup(username)
	: g_strdup_printf("%s@gmail.com", username);
    else
      return g_strdup("gmail.com");
  }}
#line 613 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
