/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "mn-sylpheed-mailbox-backend.h"

#include "mn-sylpheed-mailbox-backend-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 30 "mn-sylpheed-mailbox-backend.gob"

#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <glib/gi18n.h>
#include <eel/eel.h>
#include "mn-mailbox-private.h"
#include "mn-reentrant-mailbox-private.h"
#include "mn-vfs-mailbox-backend-private.h"
#include "mn-vfs.h"
#include "mn-util.h"
#include "mn-message-mime.h"

/* taken from procmsg.h in the Sylpheed sources */
#define SYLPHEED_MSG_NEW		(1U << 0)
#define SYLPHEED_MSG_UNREAD		(1U << 1)

/* taken from defs.h in the Sylpheed sources */
#define SYLPHEED_MARK_FILE		".sylpheed_mark"
#define SYLPHEED_MARK_VERSION		2

typedef struct
{
  int		num;
  guint32	flags;
} MarkEntry;

typedef struct
{
  char		*data;
  gsize		data_size;
  GHashTable	*table;
} Marks;

static GStaticMutex timeouts_mutex = G_STATIC_MUTEX_INIT;

#line 64 "mn-sylpheed-mailbox-backend.c"
/* self casting macros */
#define SELF(x) MN_SYLPHEED_MAILBOX_BACKEND(x)
#define SELF_CONST(x) MN_SYLPHEED_MAILBOX_BACKEND_CONST(x)
#define IS_SELF(x) MN_IS_SYLPHEED_MAILBOX_BACKEND(x)
#define TYPE_SELF MN_TYPE_SYLPHEED_MAILBOX_BACKEND
#define SELF_CLASS(x) MN_SYLPHEED_MAILBOX_BACKEND_CLASS(x)

#define SELF_GET_CLASS(x) MN_SYLPHEED_MAILBOX_BACKEND_GET_CLASS(x)

/* self typedefs */
typedef MNSylpheedMailboxBackend Self;
typedef MNSylpheedMailboxBackendClass SelfClass;

/* here are local prototypes */
static void mn_sylpheed_mailbox_backend_init (MNSylpheedMailboxBackend * o) G_GNUC_UNUSED;
static void mn_sylpheed_mailbox_backend_class_init (MNSylpheedMailboxBackendClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_sylpheed_mailbox_backend_constructor (GType type, unsigned int n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void ___3_mn_sylpheed_mailbox_backend_finalize (GObject * object) G_GNUC_UNUSED;
static void ___4_mn_sylpheed_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend, const char * info_uri, GnomeVFSMonitorEventType event_type) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_monitor_timeout_cb (gpointer data) G_GNUC_UNUSED;
static gboolean ___6_mn_sylpheed_mailbox_backend_is (MNVFSMailboxBackend * dummy, MNVFSMailboxBackendClass * class, MNVFSMailbox * mailbox) G_GNUC_UNUSED;
static void ___7_mn_sylpheed_mailbox_backend_check (MNVFSMailboxBackend * backend, unsigned long check_id) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_read_local_mark_file (const char * filename, gsize * size, char ** contents, GError ** err) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_read_remote_mark_file (GnomeVFSURI * uri, gsize * size, char ** contents, GError ** err) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_read_mark_file (GnomeVFSURI * mailbox_uri, gsize * size, char ** contents, GError ** err) G_GNUC_UNUSED;
static Marks * mn_sylpheed_mailbox_backend_marks_new (GnomeVFSURI * mailbox_uri, GError ** err) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_marks_write (GnomeVFSURI * mailbox_uri, Marks * marks, GError ** err) G_GNUC_UNUSED;
static void mn_sylpheed_mailbox_backend_marks_free (Marks * marks) G_GNUC_UNUSED;
static gboolean ___e_mn_sylpheed_mailbox_backend_mark_as_read (MNVFSMailboxBackend * dummy, MNVFSMessage * message, GError ** err) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNVFSMailboxBackendClass *parent_class = NULL;

/* Short form macros */
#define self_monitor_timeout_cb mn_sylpheed_mailbox_backend_monitor_timeout_cb
#define self_read_local_mark_file mn_sylpheed_mailbox_backend_read_local_mark_file
#define self_read_remote_mark_file mn_sylpheed_mailbox_backend_read_remote_mark_file
#define self_read_mark_file mn_sylpheed_mailbox_backend_read_mark_file
#define self_marks_new mn_sylpheed_mailbox_backend_marks_new
#define self_marks_write mn_sylpheed_mailbox_backend_marks_write
#define self_marks_free mn_sylpheed_mailbox_backend_marks_free
GType
mn_sylpheed_mailbox_backend_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNSylpheedMailboxBackendClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_sylpheed_mailbox_backend_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNSylpheedMailboxBackend),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_sylpheed_mailbox_backend_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_VFS_MAILBOX_BACKEND, "MNSylpheedMailboxBackend", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNSylpheedMailboxBackend *)g_object_new(mn_sylpheed_mailbox_backend_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNSylpheedMailboxBackend * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNSylpheedMailboxBackend *
GET_NEW_VARG (const char *first, ...)
{
	MNSylpheedMailboxBackend *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNSylpheedMailboxBackend *)g_object_new_valist (mn_sylpheed_mailbox_backend_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::finalize"
	MNSylpheedMailboxBackend *self G_GNUC_UNUSED = MN_SYLPHEED_MAILBOX_BACKEND (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 97 "mn-sylpheed-mailbox-backend.gob"
	___3_mn_sylpheed_mailbox_backend_finalize(obj_self);
#line 157 "mn-sylpheed-mailbox-backend.c"
}
#undef __GOB_FUNCTION__

static void 
mn_sylpheed_mailbox_backend_init (MNSylpheedMailboxBackend * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_SYLPHEED_MAILBOX_BACKEND,MNSylpheedMailboxBackendPrivate);
}
#undef __GOB_FUNCTION__
#line 75 "mn-sylpheed-mailbox-backend.gob"
static void 
mn_sylpheed_mailbox_backend_class_init (MNSylpheedMailboxBackendClass * class G_GNUC_UNUSED)
#line 171 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNVFSMailboxBackendClass *mn_vfs_mailbox_backend_class = (MNVFSMailboxBackendClass *)class;

	g_type_class_add_private(class,sizeof(MNSylpheedMailboxBackendPrivate));

	parent_class = g_type_class_ref (MN_TYPE_VFS_MAILBOX_BACKEND);

#line 80 "mn-sylpheed-mailbox-backend.gob"
	g_object_class->constructor = ___2_mn_sylpheed_mailbox_backend_constructor;
#line 97 "mn-sylpheed-mailbox-backend.gob"
	g_object_class->finalize = ___finalize;
#line 112 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->monitor_cb = ___4_mn_sylpheed_mailbox_backend_monitor_cb;
#line 175 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->is = ___6_mn_sylpheed_mailbox_backend_is;
#line 190 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->check = ___7_mn_sylpheed_mailbox_backend_check;
#line 478 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->mark_as_read = ___e_mn_sylpheed_mailbox_backend_mark_as_read;
#line 193 "mn-sylpheed-mailbox-backend.c"
 {
#line 76 "mn-sylpheed-mailbox-backend.gob"

    MN_VFS_MAILBOX_BACKEND_CLASS(class)->format = "Sylpheed";
  
#line 199 "mn-sylpheed-mailbox-backend.c"
 }
}
#undef __GOB_FUNCTION__



#line 80 "mn-sylpheed-mailbox-backend.gob"
static GObject * 
___2_mn_sylpheed_mailbox_backend_constructor (GType type G_GNUC_UNUSED, unsigned int n_construct_properties, GObjectConstructParam * construct_params)
#line 209 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::constructor"
{
#line 82 "mn-sylpheed-mailbox-backend.gob"
	
    GObject *object;
    Self *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

#if WITH_SYLPHEED_LOCKING
    if (gnome_vfs_uri_is_local(MN_VFS_MAILBOX_BACKEND(self)->mailbox->vfs_uri))
      selfp->can_lock_mark_file = TRUE;
#endif

    return object;
  }}
#line 232 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 97 "mn-sylpheed-mailbox-backend.gob"
static void 
___3_mn_sylpheed_mailbox_backend_finalize (GObject * object G_GNUC_UNUSED)
#line 239 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::finalize"
{
#line 99 "mn-sylpheed-mailbox-backend.gob"
	
    Self *self = SELF(object);

    g_static_mutex_lock(&timeouts_mutex);

    if (selfp->monitor_timeout_source)
      mn_locked_g_source_remove(selfp->monitor_timeout_source);

    g_static_mutex_unlock(&timeouts_mutex);

    PARENT_HANDLER(object);
  }}
#line 259 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 112 "mn-sylpheed-mailbox-backend.gob"
static void 
___4_mn_sylpheed_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend G_GNUC_UNUSED, const char * info_uri, GnomeVFSMonitorEventType event_type)
#line 266 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___info_uri,___event_type) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb)(___backend,___info_uri,___event_type); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::monitor_cb"
{
#line 116 "mn-sylpheed-mailbox-backend.gob"
	
    if (event_type == GNOME_VFS_MONITOR_EVENT_CHANGED
	|| event_type == GNOME_VFS_MONITOR_EVENT_DELETED
	|| event_type == GNOME_VFS_MONITOR_EVENT_CREATED)
      {
	char *filename;

	filename = eel_uri_get_basename(info_uri);
	if (filename)
	  {
	    if (! strcmp(filename, SYLPHEED_MARK_FILE))
	      {
		Self *self = SELF(backend);

		if (selfp->can_lock_mark_file)
		  mn_reentrant_mailbox_queue_check(MN_REENTRANT_MAILBOX(backend->mailbox));
		else
		  {
		    /*
		     * We cannot lock the mark file. To avoid races,
		     * delay the check.
		     */

		    /*
		     * We do not need to lock timeouts_mutex, because
		     * this function and monitor_timeout_cb() are
		     * always run in the same thread (from the GLib
		     * main loop).
		     */
		    if (selfp->monitor_timeout_source)
		      mn_locked_g_source_remove(selfp->monitor_timeout_source);

		    selfp->monitor_timeout_source = mn_g_timeout_add_locked(3000,
									    self_monitor_timeout_cb,
									    self,
									    (MNLockFunc) mn_g_static_mutex_lock,
									    (MNUnlockFunc) mn_g_static_mutex_unlock,
									    &timeouts_mutex);
		  }
	      }
	    else if (mn_str_isnumeric(filename))
	      mn_reentrant_mailbox_queue_check(MN_REENTRANT_MAILBOX(backend->mailbox));

	    g_free(filename);
	  }
      }
  }}
#line 321 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 164 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_monitor_timeout_cb (gpointer data)
#line 328 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::monitor_timeout_cb"
{
#line 166 "mn-sylpheed-mailbox-backend.gob"
	
    Self *self = data;

    mn_reentrant_mailbox_queue_check(MN_REENTRANT_MAILBOX(MN_VFS_MAILBOX_BACKEND(self)->mailbox));

    selfp->monitor_timeout_source = NULL;
    return FALSE;		/* remove source */
  }}
#line 341 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 175 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
___6_mn_sylpheed_mailbox_backend_is (MNVFSMailboxBackend * dummy G_GNUC_UNUSED, MNVFSMailboxBackendClass * class, MNVFSMailbox * mailbox)
#line 347 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___dummy,___class,___mailbox) \
	((MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)? \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)(___dummy,___class,___mailbox): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::is"
{
#line 179 "mn-sylpheed-mailbox-backend.gob"
	
    gboolean is = FALSE;
    GnomeVFSURI *markfile_uri;

    markfile_uri = gnome_vfs_uri_append_file_name(mailbox->vfs_uri, SYLPHEED_MARK_FILE);
    is = mn_vfs_test(markfile_uri, G_FILE_TEST_IS_REGULAR);
    gnome_vfs_uri_unref(markfile_uri);

    return is;
  }}
#line 366 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 190 "mn-sylpheed-mailbox-backend.gob"
static void 
___7_mn_sylpheed_mailbox_backend_check (MNVFSMailboxBackend * backend G_GNUC_UNUSED, unsigned long check_id)
#line 373 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___check_id) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check)(___backend,___check_id); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::check"
{
#line 192 "mn-sylpheed-mailbox-backend.gob"
	
    GError *err = NULL;
    GnomeVFSResult result;
    GnomeVFSResult close_result;
    GnomeVFSDirectoryHandle *handle;
    GnomeVFSFileInfo *file_info;
    Marks *marks;
    GSList *messages = NULL;

    mn_vfs_mailbox_backend_monitor(backend, check_id, backend->mailbox->uri, GNOME_VFS_MONITOR_DIRECTORY);

    marks = self_marks_new(backend->mailbox->vfs_uri, &err);
    if (! marks)
      {
	GDK_THREADS_ENTER();

	if (! mn_reentrant_mailbox_check_aborted_unlocked(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to read %s: %s"), SYLPHEED_MARK_FILE, err->message);
	g_error_free(err);

	gdk_flush();
	GDK_THREADS_LEAVE();

	return;
      }

    if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      goto finish;

    result = gnome_vfs_directory_open_from_uri(&handle, backend->mailbox->vfs_uri, GNOME_VFS_FILE_INFO_FOLLOW_LINKS);
    if (result != GNOME_VFS_OK)
      {
	GDK_THREADS_ENTER();

	if (! mn_reentrant_mailbox_check_aborted_unlocked(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to open folder: %s"), gnome_vfs_result_to_string(result));

	gdk_flush();
	GDK_THREADS_LEAVE();

	goto end;
      }

    file_info = gnome_vfs_file_info_new();
    while ((result = gnome_vfs_directory_read_next(handle, file_info)) == GNOME_VFS_OK)
      if (mn_str_isnumeric(file_info->name))
	{
	  int num = atoi(file_info->name);
	  MarkEntry *entry = g_hash_table_lookup(marks->table, GINT_TO_POINTER(num));

	  if (! entry || (entry->flags & (SYLPHEED_MSG_NEW | SYLPHEED_MSG_UNREAD)) != 0)
	    {
	      MNMessageFlags flags = 0;

	      if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
		break;

	      if (! entry || (entry->flags & SYLPHEED_MSG_NEW) != 0)
		flags |= MN_MESSAGE_NEW;

	      /*
	       * We set handle_status to FALSE, since Sylpheed has its
	       * own way (mark file) of differencing seen/unseen
	       * messages.
	       */
	      messages = g_slist_prepend(messages, mn_vfs_message_new(backend,
								      backend->mailbox->vfs_uri,
								      file_info->name,
								      flags,
								      FALSE));
	    }
	}
    gnome_vfs_file_info_unref(file_info);
    close_result = gnome_vfs_directory_close(handle);

  finish:
    GDK_THREADS_ENTER();

    if (! mn_reentrant_mailbox_check_aborted_unlocked(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      {
	if (result == GNOME_VFS_ERROR_EOF || result == GNOME_VFS_OK)
	  {
	    if (close_result == GNOME_VFS_OK)
	      mn_mailbox_set_messages(MN_MAILBOX(backend->mailbox), messages);
	    else
	      mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to close folder: %s"), gnome_vfs_result_to_string(close_result));
	  }
	else
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("error while reading folder: %s"), gnome_vfs_result_to_string(result));
      }

    mn_g_object_slist_free(messages);

    gdk_flush();
    GDK_THREADS_LEAVE();

  end:
    self_marks_free(marks);
  }}
#line 480 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 292 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_read_local_mark_file (const char * filename, gsize * size, char ** contents, GError ** err)
#line 487 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_local_mark_file"
#line 292 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (filename != NULL, (gboolean )0);
#line 292 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (size != NULL, (gboolean )0);
#line 292 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (contents != NULL, (gboolean )0);
#line 496 "mn-sylpheed-mailbox-backend.c"
{
#line 297 "mn-sylpheed-mailbox-backend.gob"
	
    int fd;
    struct flock lock;
    GIOChannel *channel;
    GError *tmp_err = NULL;
    gboolean status = FALSE;

    fd = open(filename, O_RDONLY);
    if (fd < 0)
      {
	g_set_error(err, 0, 0, "%s", g_strerror(errno));
	return FALSE;
      }

    /*
     * Even if --enable-sylpheed-locking was not used and we are here
     * after the 3 seconds delay, it does not hurt to obtain a lock,
     * in case the user has a patched Sylpheed but did not use
     * --enable-sylpheed-locking.
     */

    memset(&lock, 0, sizeof(lock));
    lock.l_start = 0;		/* from l_whence */
    lock.l_len = 0;		/* to end of file */
    lock.l_type = F_RDLCK;	/* read lock */
    lock.l_whence = SEEK_SET;	/* from start of file */

    /* ignore lock failures */
    fcntl(fd, F_SETLKW, &lock);

    channel = g_io_channel_unix_new(fd);
    if (g_io_channel_set_encoding(channel, NULL, &tmp_err) == G_IO_STATUS_NORMAL)
      {
	if (g_io_channel_read_to_end(channel, contents, size, err) == G_IO_STATUS_NORMAL)
	  status = TRUE;
      }
    else
      {
	g_set_error(err, 0, 0, "unable to set encoding: %s", tmp_err->message);
	g_error_free(tmp_err);
      }

    g_io_channel_shutdown(channel, FALSE, NULL);
    g_io_channel_unref(channel);

    return status;
  }}
#line 546 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 345 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_read_remote_mark_file (GnomeVFSURI * uri, gsize * size, char ** contents, GError ** err)
#line 552 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_remote_mark_file"
#line 345 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 345 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (size != NULL, (gboolean )0);
#line 345 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (contents != NULL, (gboolean )0);
#line 561 "mn-sylpheed-mailbox-backend.c"
{
#line 350 "mn-sylpheed-mailbox-backend.gob"
	
    GnomeVFSResult result;
    int _size;

    result = mn_vfs_read_entire_file_uri(uri, &_size, contents);
    if (result == GNOME_VFS_OK)
      {
	*size = _size;
	return TRUE;
      }
    else
      {
	g_set_error(err, 0, 0, "%s", gnome_vfs_result_to_string(result));
	return FALSE;
      }
  }}
#line 580 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 367 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_read_mark_file (GnomeVFSURI * mailbox_uri, gsize * size, char ** contents, GError ** err)
#line 586 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_mark_file"
#line 367 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (mailbox_uri != NULL, (gboolean )0);
#line 367 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (size != NULL, (gboolean )0);
#line 367 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (contents != NULL, (gboolean )0);
#line 595 "mn-sylpheed-mailbox-backend.c"
{
#line 372 "mn-sylpheed-mailbox-backend.gob"
	
    GnomeVFSURI *markfile_uri;
    char *filename;
    gboolean status;

    markfile_uri = gnome_vfs_uri_append_file_name(mailbox_uri, SYLPHEED_MARK_FILE);

    filename = mn_vfs_get_local_path(markfile_uri);
    if (filename)
      {
	status = self_read_local_mark_file(filename, size, contents, err);
	g_free(filename);
      }
    else
      status = self_read_remote_mark_file(markfile_uri, size, contents, err);

    gnome_vfs_uri_unref(markfile_uri);

    return status;
  }}
#line 618 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 393 "mn-sylpheed-mailbox-backend.gob"
static Marks * 
mn_sylpheed_mailbox_backend_marks_new (GnomeVFSURI * mailbox_uri, GError ** err)
#line 624 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::marks_new"
#line 393 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (mailbox_uri != NULL, (Marks * )0);
#line 629 "mn-sylpheed-mailbox-backend.c"
{
#line 395 "mn-sylpheed-mailbox-backend.gob"
	
    Marks *marks = NULL;
    gsize bytes_left;
    char *buf;

    if (self_read_mark_file(mailbox_uri, &bytes_left, &buf, err))
      {
	if (bytes_left >= sizeof(int))
	  {
	    int version = *((int *) buf);

	    if (version == SYLPHEED_MARK_VERSION)
	      {
		MarkEntry *entry;

		marks = g_new0(Marks, 1);
		marks->data = buf;
		marks->data_size = bytes_left;
		marks->table = g_hash_table_new(g_direct_hash, g_direct_equal);

		entry = (MarkEntry *) (buf + sizeof(int));
		bytes_left -= sizeof(int);

		buf = NULL;	/* now owned by marks */

		while (bytes_left > 0)
		  {
		    if (bytes_left < sizeof(MarkEntry))
		      {
			g_set_error(err, 0, 0, _("unexpected end of file"));
			self_marks_free(marks);
			marks = NULL;
			break;
		      }

		    g_hash_table_insert(marks->table, GINT_TO_POINTER(entry->num), entry);

		    entry++;
		    bytes_left -= sizeof(MarkEntry);
		  }
	      }
	    else
	      g_set_error(err, 0, 0, _("incompatible file version \"%i\""), version);
	  }
	else
	  g_set_error(err, 0, 0, _("file version missing"));

	g_free(buf);
      }

    return marks;
  }}
#line 684 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 448 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_marks_write (GnomeVFSURI * mailbox_uri, Marks * marks, GError ** err)
#line 690 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::marks_write"
#line 448 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (mailbox_uri != NULL, (gboolean )0);
#line 448 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (marks != NULL, (gboolean )0);
#line 697 "mn-sylpheed-mailbox-backend.c"
{
#line 452 "mn-sylpheed-mailbox-backend.gob"
	
    GnomeVFSURI *markfile_uri;
    gboolean status;

    /*
     * We do not lock the mark file, since the user is normally unable
     * to at the same time click on the "Mark as Read" button and use
     * Sylpheed.
     */

    markfile_uri = gnome_vfs_uri_append_file_name(mailbox_uri, SYLPHEED_MARK_FILE);
    /* Sylpheed uses S_IRUSR | S_IWUSR for data files */
    status = mn_vfs_write_entire_file_uri_safe(markfile_uri, marks->data_size, marks->data, S_IRUSR | S_IWUSR, err);
    gnome_vfs_uri_unref(markfile_uri);

    return status;
  }}
#line 717 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 470 "mn-sylpheed-mailbox-backend.gob"
static void 
mn_sylpheed_mailbox_backend_marks_free (Marks * marks)
#line 723 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::marks_free"
#line 470 "mn-sylpheed-mailbox-backend.gob"
	g_return_if_fail (marks != NULL);
#line 728 "mn-sylpheed-mailbox-backend.c"
{
#line 472 "mn-sylpheed-mailbox-backend.gob"
	
    g_free(marks->data);
    g_hash_table_destroy(marks->table);
    g_free(marks);
  }}
#line 736 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 478 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
___e_mn_sylpheed_mailbox_backend_mark_as_read (MNVFSMailboxBackend * dummy G_GNUC_UNUSED, MNVFSMessage * message, GError ** err)
#line 742 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___dummy,___message,___err) \
	((MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->mark_as_read)? \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->mark_as_read)(___dummy,___message,___err): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::mark_as_read"
{
#line 482 "mn-sylpheed-mailbox-backend.gob"
	
    char *filename;
    int num;
    GError *tmp_err = NULL;
    Marks *marks;
    MarkEntry *entry;
    gboolean status;

    filename = gnome_vfs_uri_extract_short_name(message->vfs_uri);
    g_assert(mn_str_isnumeric(filename));
    num = atoi(filename);
    g_free(filename);

    marks = self_marks_new(MN_VFS_MAILBOX(MN_MESSAGE(message)->mailbox)->vfs_uri, &tmp_err);
    if (! marks)
      {
	g_set_error(err, 0, 0, _("Unable to read %s: %s."), SYLPHEED_MARK_FILE, tmp_err->message);
	g_error_free(tmp_err);
	return FALSE;
      }

    entry = g_hash_table_lookup(marks->table, GINT_TO_POINTER(num));
    if (entry)
      entry->flags &= ~(SYLPHEED_MSG_NEW | SYLPHEED_MSG_UNREAD);
    else
      {
	marks->data_size += sizeof(MarkEntry);
	marks->data = g_realloc(marks->data, marks->data_size);
	entry = (MarkEntry *) (marks->data + marks->data_size - sizeof(MarkEntry));
	entry->num = num;
	entry->flags = 0;
      }

    status = self_marks_write(MN_VFS_MAILBOX(MN_MESSAGE(message)->mailbox)->vfs_uri, marks, err);
    self_marks_free(marks);

    return status;
  }}
#line 789 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER
