/* Generated by GOB (v2.0.12) on Tue Aug  9 22:01:56 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 12

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-sylpheed-mailbox-backend.h"

#include "mn-sylpheed-mailbox-backend-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 25 "mn-sylpheed-mailbox-backend.gob"

#include "config.h"
#include <stdlib.h>
#include <glib/gi18n.h>
#include <eel/eel.h>
#include "mn-mailbox-private.h"
#include "mn-reentrant-mailbox-private.h"
#include "mn-vfs-mailbox-backend-private.h"
#include "mn-vfs.h"
#include "mn-util.h"
#include "mn-message-mime.h"

/* taken from procmsg.h in the Sylpheed sources */
#define SYLPHEED_MSG_NEW		(1U << 0)
#define SYLPHEED_MSG_UNREAD		(1U << 1)

/* taken from defs.h in the Sylpheed sources */
#define SYLPHEED_MARK_FILE		".sylpheed_mark"
#define SYLPHEED_MARK_VERSION		2

typedef struct
{
  int		num;
  guint32	flags;
} MarkEntry;

#line 54 "mn-sylpheed-mailbox-backend.c"
/* self casting macros */
#define SELF(x) MN_SYLPHEED_MAILBOX_BACKEND(x)
#define SELF_CONST(x) MN_SYLPHEED_MAILBOX_BACKEND_CONST(x)
#define IS_SELF(x) MN_IS_SYLPHEED_MAILBOX_BACKEND(x)
#define TYPE_SELF MN_TYPE_SYLPHEED_MAILBOX_BACKEND
#define SELF_CLASS(x) MN_SYLPHEED_MAILBOX_BACKEND_CLASS(x)

#define SELF_GET_CLASS(x) MN_SYLPHEED_MAILBOX_BACKEND_GET_CLASS(x)

/* self typedefs */
typedef MNSylpheedMailboxBackend Self;
typedef MNSylpheedMailboxBackendClass SelfClass;

/* here are local prototypes */
static void mn_sylpheed_mailbox_backend_init (MNSylpheedMailboxBackend * o) G_GNUC_UNUSED;
static void mn_sylpheed_mailbox_backend_class_init (MNSylpheedMailboxBackendClass * class) G_GNUC_UNUSED;
static void ___2_mn_sylpheed_mailbox_backend_finalize (GObject * object) G_GNUC_UNUSED;
static void ___3_mn_sylpheed_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend, const char * info_uri, GnomeVFSMonitorEventType event_type) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_monitor_timeout_cb (gpointer data) G_GNUC_UNUSED;
static gboolean ___5_mn_sylpheed_mailbox_backend_is (MNVFSMailboxBackend * dummy, MNVFSMailbox * mailbox) G_GNUC_UNUSED;
static void ___6_mn_sylpheed_mailbox_backend_check (MNVFSMailboxBackend * backend, unsigned long check_id) G_GNUC_UNUSED;
static GHashTable * mn_sylpheed_mailbox_backend_get_seen_numbers (MNSylpheedMailboxBackend * self, GError ** err) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNVFSMailboxBackendClass *parent_class = NULL;

/* Short form macros */
#define self_monitor_timeout_cb mn_sylpheed_mailbox_backend_monitor_timeout_cb
#define self_get_seen_numbers mn_sylpheed_mailbox_backend_get_seen_numbers
GType
mn_sylpheed_mailbox_backend_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNSylpheedMailboxBackendClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_sylpheed_mailbox_backend_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNSylpheedMailboxBackend),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_sylpheed_mailbox_backend_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_VFS_MAILBOX_BACKEND, "MNSylpheedMailboxBackend", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNSylpheedMailboxBackend *)g_object_new(mn_sylpheed_mailbox_backend_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNSylpheedMailboxBackend * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNSylpheedMailboxBackend *
GET_NEW_VARG (const char *first, ...)
{
	MNSylpheedMailboxBackend *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNSylpheedMailboxBackend *)g_object_new_valist (mn_sylpheed_mailbox_backend_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::finalize"
	MNSylpheedMailboxBackend *self G_GNUC_UNUSED = MN_SYLPHEED_MAILBOX_BACKEND (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 61 "mn-sylpheed-mailbox-backend.gob"
	___2_mn_sylpheed_mailbox_backend_finalize(obj_self);
#line 135 "mn-sylpheed-mailbox-backend.c"
}
#undef __GOB_FUNCTION__

static void 
mn_sylpheed_mailbox_backend_init (MNSylpheedMailboxBackend * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_SYLPHEED_MAILBOX_BACKEND,MNSylpheedMailboxBackendPrivate);
}
#undef __GOB_FUNCTION__
#line 56 "mn-sylpheed-mailbox-backend.gob"
static void 
mn_sylpheed_mailbox_backend_class_init (MNSylpheedMailboxBackendClass * class G_GNUC_UNUSED)
#line 149 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNVFSMailboxBackendClass *mn_vfs_mailbox_backend_class = (MNVFSMailboxBackendClass *)class;

	g_type_class_add_private(class,sizeof(MNSylpheedMailboxBackendPrivate));

	parent_class = g_type_class_ref (MN_TYPE_VFS_MAILBOX_BACKEND);

#line 61 "mn-sylpheed-mailbox-backend.gob"
	g_object_class->finalize = ___finalize;
#line 72 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->monitor_cb = ___3_mn_sylpheed_mailbox_backend_monitor_cb;
#line 120 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->is = ___5_mn_sylpheed_mailbox_backend_is;
#line 133 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->check = ___6_mn_sylpheed_mailbox_backend_check;
#line 167 "mn-sylpheed-mailbox-backend.c"
 {
#line 57 "mn-sylpheed-mailbox-backend.gob"

    MN_VFS_MAILBOX_BACKEND_CLASS(class)->format = "Sylpheed";
  
#line 173 "mn-sylpheed-mailbox-backend.c"
 }
}
#undef __GOB_FUNCTION__



#line 61 "mn-sylpheed-mailbox-backend.gob"
static void 
___2_mn_sylpheed_mailbox_backend_finalize (GObject * object G_GNUC_UNUSED)
#line 183 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::finalize"
{
#line 63 "mn-sylpheed-mailbox-backend.gob"
	
    Self *self = SELF(object);

    if (selfp->monitor_timeout_id)
      g_source_remove(selfp->monitor_timeout_id);

    PARENT_HANDLER(object);
  }}
#line 199 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 72 "mn-sylpheed-mailbox-backend.gob"
static void 
___3_mn_sylpheed_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend G_GNUC_UNUSED, const char * info_uri, GnomeVFSMonitorEventType event_type)
#line 206 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___info_uri,___event_type) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb)(___backend,___info_uri,___event_type); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::monitor_cb"
{
#line 76 "mn-sylpheed-mailbox-backend.gob"
	
    if (event_type == GNOME_VFS_MONITOR_EVENT_CHANGED
	|| event_type == GNOME_VFS_MONITOR_EVENT_DELETED
	|| event_type == GNOME_VFS_MONITOR_EVENT_CREATED)
      {
	char *filename;
	    
	filename = eel_uri_get_basename(info_uri);
	if (filename)
	  {
	    if (! strcmp(filename, SYLPHEED_MARK_FILE))
	      {
		Self *self = SELF(backend);
		
		/*
		 * The mark file has been changed, deleted or created,
		 * probably by a Sylpheed instance. To avoid races, we
		 * will delay the check.
		 */
		    
		if (selfp->monitor_timeout_id)
		  g_source_remove(selfp->monitor_timeout_id);
		    
		selfp->monitor_timeout_id = g_timeout_add(2000, self_monitor_timeout_cb, self);
	      }
	    else if (mn_str_isnumeric(filename))
	      mn_reentrant_mailbox_queue_check(MN_REENTRANT_MAILBOX(backend->mailbox));
		
	    g_free(filename);
	  }
      }
  }}
#line 246 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 109 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_monitor_timeout_cb (gpointer data)
#line 253 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::monitor_timeout_cb"
{
#line 111 "mn-sylpheed-mailbox-backend.gob"
	
    Self *self = data;

    mn_reentrant_mailbox_queue_check(MN_REENTRANT_MAILBOX(MN_VFS_MAILBOX_BACKEND(self)->mailbox));
    selfp->monitor_timeout_id = 0;

    return FALSE;		/* remove source */
  }}
#line 266 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 120 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
___5_mn_sylpheed_mailbox_backend_is (MNVFSMailboxBackend * dummy G_GNUC_UNUSED, MNVFSMailbox * mailbox)
#line 272 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___dummy,___mailbox) \
	((MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)? \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)(___dummy,___mailbox): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::is"
{
#line 122 "mn-sylpheed-mailbox-backend.gob"
	
    gboolean is = FALSE;
    GnomeVFSURI *markfile_uri;

    markfile_uri = gnome_vfs_uri_append_file_name(mailbox->vfs_uri, SYLPHEED_MARK_FILE);
    is = mn_vfs_test(markfile_uri, G_FILE_TEST_IS_REGULAR);
    gnome_vfs_uri_unref(markfile_uri);

    return is;
  }}
#line 291 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 133 "mn-sylpheed-mailbox-backend.gob"
static void 
___6_mn_sylpheed_mailbox_backend_check (MNVFSMailboxBackend * backend G_GNUC_UNUSED, unsigned long check_id)
#line 298 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___check_id) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check)(___backend,___check_id); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::check"
{
#line 135 "mn-sylpheed-mailbox-backend.gob"
	
    GError *err = NULL;
    GnomeVFSResult result;
    GnomeVFSResult close_result;
    GnomeVFSDirectoryHandle *handle;
    GnomeVFSFileInfo *file_info;
    GHashTable *seen_numbers;
    GSList *messages = NULL;

    mn_vfs_mailbox_backend_monitor(backend, check_id, backend->mailbox->uri, GNOME_VFS_MONITOR_DIRECTORY);

    seen_numbers = self_get_seen_numbers(SELF(backend), &err);
    if (! seen_numbers)
      {
	GDK_THREADS_ENTER();
	
	if (! mn_reentrant_mailbox_check_aborted_unlocked(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to read %s: %s"), SYLPHEED_MARK_FILE, err->message);
	g_error_free(err);

	gdk_flush();
	GDK_THREADS_LEAVE();

	return;
      }
    
    if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      goto finish;

    result = gnome_vfs_directory_open_from_uri(&handle, backend->mailbox->vfs_uri, GNOME_VFS_FILE_INFO_FOLLOW_LINKS);
    if (result != GNOME_VFS_OK)
      {
	GDK_THREADS_ENTER();
	
	if (! mn_reentrant_mailbox_check_aborted_unlocked(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to open folder: %s"), gnome_vfs_result_to_string(result));

	gdk_flush();
	GDK_THREADS_LEAVE();

	goto end;
      }

    file_info = gnome_vfs_file_info_new();
    while ((result = gnome_vfs_directory_read_next(handle, file_info)) == GNOME_VFS_OK)
      if (mn_str_isnumeric(file_info->name))
	{
	  int num = atoi(file_info->name);
		
	  if (! g_hash_table_lookup(seen_numbers, GINT_TO_POINTER(num)))
	    {
	      GnomeVFSURI *message_uri;

	      if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
		break;
	      
	      message_uri = gnome_vfs_uri_append_file_name(backend->mailbox->vfs_uri, file_info->name);
	      messages = g_slist_append(messages, mn_message_new_from_uri(MN_MAILBOX(backend->mailbox), message_uri));
	      gnome_vfs_uri_unref(message_uri);
	    }
	}
    gnome_vfs_file_info_unref(file_info);
    close_result = gnome_vfs_directory_close(handle);

  finish:
    GDK_THREADS_ENTER();
    
    if (! mn_reentrant_mailbox_check_aborted_unlocked(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      {
	if (result == GNOME_VFS_ERROR_EOF || result == GNOME_VFS_OK)
	  {
	    if (close_result == GNOME_VFS_OK)
	      mn_mailbox_set_messages(MN_MAILBOX(backend->mailbox), messages);
	    else
	      mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to close folder: %s"), gnome_vfs_result_to_string(close_result));
	  }
	else
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("error while reading folder: %s"), gnome_vfs_result_to_string(result));
      }
    
    mn_g_object_slist_free(messages);

    gdk_flush();
    GDK_THREADS_LEAVE();

  end:
    g_hash_table_destroy(seen_numbers);
  }}
#line 394 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 224 "mn-sylpheed-mailbox-backend.gob"
static GHashTable * 
mn_sylpheed_mailbox_backend_get_seen_numbers (MNSylpheedMailboxBackend * self, GError ** err)
#line 401 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::get_seen_numbers"
#line 224 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (self != NULL, (GHashTable * )0);
#line 224 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (MN_IS_SYLPHEED_MAILBOX_BACKEND (self), (GHashTable * )0);
#line 408 "mn-sylpheed-mailbox-backend.c"
{
#line 226 "mn-sylpheed-mailbox-backend.gob"
	
    GnomeVFSURI *markfile_uri;
    GHashTable *seen_numbers = NULL;
    GnomeVFSResult result;
    int bytes_left;
    char *buf;
    
    markfile_uri = gnome_vfs_uri_append_file_name(MN_VFS_MAILBOX_BACKEND(self)->mailbox->vfs_uri, SYLPHEED_MARK_FILE);
    result = mn_vfs_read_entire_file_uri(markfile_uri, &bytes_left, &buf);
    gnome_vfs_uri_unref(markfile_uri);

    if (result == GNOME_VFS_OK)
      {
	if (bytes_left >= sizeof(int))
	  {
	    int version = *((int *) buf);

	    if (version == SYLPHEED_MARK_VERSION)
	      {
		MarkEntry *entry;

		entry = (MarkEntry *) (buf + sizeof(int));
		bytes_left -= sizeof(int);

		seen_numbers = g_hash_table_new(g_direct_hash, g_direct_equal);
		
		while (bytes_left > 0)
		  {
		    if (bytes_left < sizeof(MarkEntry))
		      {
			g_set_error(err, 0, 0, _("unexpected end of file"));
			g_hash_table_destroy(seen_numbers);
			seen_numbers = NULL;
			break;
		      }

		    if ((entry->flags & SYLPHEED_MSG_NEW) == 0 && (entry->flags & SYLPHEED_MSG_UNREAD) == 0)
		      g_hash_table_insert(seen_numbers, GINT_TO_POINTER(entry->num), GINT_TO_POINTER(TRUE));
		    
		    entry++;
		    bytes_left -= sizeof(MarkEntry);
		  }
	      }
	    else
	      g_set_error(err, 0, 0, _("incompatible file version \"%i\""), version);
	  }
	else
	  g_set_error(err, 0, 0, _("file version missing"));

	g_free(buf);
      }
    else
      g_set_error(err, 0, 0, "%s", gnome_vfs_result_to_string(result));
      
    return seen_numbers;
  }}
#line 467 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
