/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: socket.h,v 1.6.2.1 2003/04/11 19:15:54 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_SOCKET_H_INCLUDED
#define ZORP_SOCKET_H_INCLUDED


#include <zorp/zorplib.h>
#include <zorp/sockaddr.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _ZSocketFuncs
{
  gint (*bind)(int fd, struct sockaddr *sa, socklen_t salen);
  gint (*accept)(int fd, struct sockaddr *sa, socklen_t *salen);
  gint (*connect)(int fd, struct sockaddr *sa, socklen_t salen);
  gint (*listen)(int fd, gint backlog, gboolean accept_one);
  gint (*getsockname)(int fd, struct sockaddr *sa, socklen_t *salen);
  gint (*getpeername)(int fd, struct sockaddr *sa, socklen_t *salen);
  gint (*getdestname)(int fd, struct sockaddr *sa, socklen_t *salen);
} ZSocketFuncs;

gint z_do_ll_bind(int fd, struct sockaddr *sa, socklen_t salen);
gint z_do_ll_accept(int fd, struct sockaddr *sa, socklen_t *salen);
gint z_do_ll_connect(int fd, struct sockaddr *sa, socklen_t salen);
gint z_do_ll_listen(int fd, gint backlog, gboolean accept_one);
gint z_do_ll_getsockname(int fd, struct sockaddr *sa, socklen_t *salen);
gint z_do_ll_getpeername(int fd, struct sockaddr *sa, socklen_t *salen);

extern ZSocketFuncs *socket_funcs;

static inline gint
z_ll_bind(gint fd, struct sockaddr *sa, socklen_t salen)
{
  return socket_funcs->bind(fd, sa, salen);
}

static inline gint 
z_ll_accept(gint fd, struct sockaddr *sa, socklen_t *salen)
{
  return socket_funcs->accept(fd, sa, salen);
}

static inline gint 
z_ll_connect(gint fd, struct sockaddr *sa, socklen_t salen)
{
  return socket_funcs->connect(fd, sa, salen);
}

static inline gint
z_ll_listen(gint fd, gint backlog, gboolean accept_one)
{
  return socket_funcs->listen(fd, backlog, accept_one);
}

static inline gint
z_ll_getsockname(gint fd, struct sockaddr *sa, socklen_t *salen)
{
  return socket_funcs->getsockname(fd, sa, salen);
}

static inline gint
z_ll_getpeername(gint fd, struct sockaddr *sa, socklen_t *salen)
{
  return socket_funcs->getpeername(fd, sa, salen);
}

static inline gint
z_ll_getdestname(gint fd, struct sockaddr *sa, socklen_t *salen)
{
  return socket_funcs->getdestname(fd, sa, salen);
}

GIOStatus z_bind(gint fd, ZSockAddr *addr);
GIOStatus z_accept(gint fd, gint *newfd, ZSockAddr **addr);
GIOStatus z_connect(gint fd, ZSockAddr *remote);
GIOStatus z_disconnect(int fd);

GIOStatus z_listen(gint fd, gint backlog, gboolean accept_one);
GIOStatus z_getsockname(gint fd, ZSockAddr **local_addr);
GIOStatus z_getpeername(gint fd, ZSockAddr **peer_addr);
GIOStatus z_getdestname(gint fd, ZSockAddr **dest_addr);

gboolean z_socket_init(void);
void z_socket_done(void);

#ifdef __cplusplus
}
#endif

#endif
