/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.HTMLOutputHandler;
import com.jclark.xsl.sax.NXMLOutputHandler;
import com.jclark.xsl.sax.OutputDocumentHandler;
import com.jclark.xsl.sax.OutputMethodHandler;
import com.jclark.xsl.sax.TextOutputHandler;
import com.jclark.xsl.sax.XMLOutputHandler;
import com.jclark.xsl.sax.XSLProcessor;
import java.io.IOException;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class OutputMethodHandlerImpl
implements OutputMethodHandler {
    private XSLProcessor processor;
    private Destination dest;
    private static final String JAVA_OUTPUT_METHOD = "http://www.jclark.com/xt/java";

    public OutputMethodHandlerImpl(XSLProcessor processor) {
        this.processor = processor;
    }

    public OutputMethodHandler createOutputMethodHandler(String uri) {
        Destination d = this.dest.resolve(uri);
        if (d == null) {
            return null;
        }
        OutputMethodHandlerImpl om = new OutputMethodHandlerImpl(this.processor);
        om.setDestination(d);
        return om;
    }

    public void setDestination(Destination dest) {
        this.dest = dest;
    }

    public DocumentHandler createDocumentHandler(String name, AttributeList atts) throws SAXException, IOException {
        DocumentHandler handler = null;
        if (name != null) {
            if (name.startsWith(JAVA_OUTPUT_METHOD) && name.lastIndexOf(94) == JAVA_OUTPUT_METHOD.length()) {
                try {
                    Class<?> cls = Class.forName(name.substring(JAVA_OUTPUT_METHOD.length() + 1));
                    handler = (DocumentHandler)cls.newInstance();
                }
                catch (ClassNotFoundException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (ClassCastException e) {}
            } else if (name.equals("http://www.jclark.com/xt^nxml")) {
                handler = new NXMLOutputHandler();
            } else if (name.equals("html")) {
                handler = new HTMLOutputHandler();
            } else if (name.equals("text")) {
                handler = new TextOutputHandler();
            }
        }
        if (handler == null) {
            handler = new XMLOutputHandler();
        }
        if (handler instanceof OutputDocumentHandler) {
            handler = ((OutputDocumentHandler)handler).init(this.dest, atts);
        }
        return handler;
    }
}

