/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ConvertibleNodeSetExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.MergeNodeIterator;
import com.jclark.xsl.expr.NullNodeIterator;
import com.jclark.xsl.expr.UnionNodeIterator;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

class ComposeExpr
extends ConvertibleNodeSetExpr {
    private final ConvertibleNodeSetExpr expr1;
    private final ConvertibleNodeSetExpr expr2;

    ComposeExpr(ConvertibleNodeSetExpr expr1, ConvertibleNodeSetExpr expr2) {
        this.expr1 = expr1;
        this.expr2 = expr2;
    }

    public NodeIterator eval(Node node, ExprContext context) throws XSLException {
        Node tem;
        NodeIterator iter = this.expr1.eval(node, context);
        NodeIterator[] iters = new NodeIterator[10];
        int length = 0;
        while ((tem = iter.next()) != null) {
            if (length == iters.length) {
                NodeIterator[] oldIters = iters;
                iters = new NodeIterator[oldIters.length * 2];
                System.arraycopy(oldIters, 0, iters, 0, oldIters.length);
            }
            iters[length++] = this.expr2.eval(tem, context);
        }
        switch (length) {
            case 0: {
                return new NullNodeIterator();
            }
            case 1: {
                return iters[0];
            }
            case 2: {
                return new UnionNodeIterator(iters[0], iters[1]);
            }
        }
        return new MergeNodeIterator(iters, length);
    }

    int getOptimizeFlags() {
        return this.expr1.getOptimizeFlags() & this.expr2.getOptimizeFlags();
    }
}

