/*
 * 
 * copywrite 2003-4 under GNU/GPL which means what it means.
 * Edscott Wilson Garcia 
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <limits.h>

#include <dirent.h>
#include <fcntl.h>
#include <signal.h>
#include <time.h>
#include <utime.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "gui.h"
#include "actions_lib.h"


/* signal handling */
#ifndef HAVE_SIGNAL
#ifndef HAVE_SIGACTION
#error "This program needs signals to work!"
#endif
#endif

/* XXX: should be determined in a dynamic way... */
#define PIPE_BLOCK 250000

#define MAX_LINE_SIZE (_POSIX_PATH_MAX*3)
#define CHILD_FILE_LENGTH 64

#ifndef GLOB_TILDE
#define GLOB_TILDE 0x0
#endif

#ifndef GLOB_PERIOD
#define GLOB_PERIOD 0
#endif

#include "countfiles.i"
G_MODULE_EXPORT
void xffm_count_window(widgets_t *widgets_p, const gchar *c_file)
{
    GtkWidget *cancel;
    GtkWidget *parent=widgets_p->window;
   
    
    strncpy(child_file,c_file,_POSIX_PATH_MAX);
    count_cancelled = FALSE;
    countW = gtk_dialog_new();

    count_widgets_p=widgets_p;

    place_dialog(parent, countW);
    gtk_window_set_modal(GTK_WINDOW(countW), TRUE);
    count_label = gtk_label_new(_("Counting files"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(countW)->vbox), count_label, TRUE, TRUE, 3);

    count_label = gtk_label_new(".........................................");
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(countW)->vbox), count_label, TRUE, TRUE, 3);

    cancel = gtk_button_new_with_label(_("Cancel"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(countW)->action_area), cancel, FALSE, FALSE, 3);
    g_signal_connect(G_OBJECT(cancel), "clicked", (GCallback)cb_count_cancel, NULL);

    gtk_widget_realize(countW);

    /*if (preferences&SMALL_DIALOGS) 
       gdk_window_set_decorations (countW->window,GDK_DECOR_BORDER); */

    if (widgets_p->window) gtk_window_set_transient_for(GTK_WINDOW(countW), GTK_WINDOW(widgets_p->window));
    g_signal_connect(GTK_OBJECT(countW), "destroy", (GCallback)cb_count_destroy, NULL);
    gtk_widget_show_all(countW);
    gdk_flush();
    /* add timeout */
    counttimer = g_timeout_add_full(0, 260, (GtkFunction) ParentCount,NULL, NULL);


    gtk_main();
    if(countW)
    {
	gtk_widget_destroy(countW);
	count_cancelled = FALSE;
    }
    return;
}


