/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"

ExitInfo *first_exit=NULL;
ExitInfo  *last_exit=NULL;

void xphonya_free_exit (ExitInfo *exitinfo)
{
    if (exitinfo==first_exit) first_exit=exitinfo->Next;
    if (exitinfo==last_exit)  last_exit=exitinfo->Prev;

    if (exitinfo->Prev) (exitinfo->Prev)->Next=exitinfo->Next;
    if (exitinfo->Next) (exitinfo->Next)->Prev=exitinfo->Prev;

    free (exitinfo);

}

void xphonya_free_all_exit ()
{
    struct ExitInfo *tmp,*Next;

    tmp=first_exit;
    while (tmp)
    {
        Next=tmp->Next;
        xphonya_free_exit (tmp);
        tmp=Next;
    }
}

ExitInfo * ExitInfo_search4cmd (CmdInfo *cmd)
{
    struct ExitInfo *tmp;

    tmp=first_exit;
    while (tmp)
    {
        if (tmp->Cmd == cmd)
            return (tmp);
        tmp=tmp->Next;
    }
    return (NULL);
}

ExitInfo * ExitInfo_search4win (Window win)
{
    struct ExitInfo *tmp;

    tmp=first_exit;
    while (tmp)
    {
        if (tmp->Cmd->win == win)
            return (tmp);
        tmp=tmp->Next;
    }
    return (NULL);
}


ExitInfo * xphonya_new_exit (CmdInfo * Cmd,int (*CallBack)(),void *data)
{
    //
    // Add new 
    //
    struct ExitInfo *new;

    new = (ExitInfo *) malloc (sizeof(ExitInfo));
    if (!new)
        perror("xphonya_new_exit Out of Memory");

    if (!first_exit)  first_exit=new;
    if (last_exit) (last_exit)->Next=new;
    new->Prev=last_exit;
    new->Next=NULL;
    last_exit=new;

    new->Cmd=Cmd;
    new->CallBack=CallBack;
    new->data=data;
    return (new);
}

