/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"
int WX11_SPACE_BETWEEN_BORDERS;

void WX11_UpDateScrollMax (CmdInfo *comando);

CmdInfo * PrimoComando(int Mode, CmdInfo *cmd)
{
	// Set / Get 
	static CmdInfo *primo=NULL;
	if (Mode)
		primo=cmd;
	return (primo);
}

CmdInfo *UltimoComando (int Mode, CmdInfo *cmd)
{
	// Set / Get 
	static CmdInfo *ultimo=NULL;
	if (Mode)
		ultimo=cmd;
	return (ultimo);
}

CmdInfo *AddCom (	
			int Tipo, 
			Window parent, 
			Window win, 
			int x, int y,
			int Width, int Height,
		       	unsigned int colorbg, unsigned int colorfg,
			int Bordo,	
			char *Label
			)
{
	CmdInfo *Ultimo;
	CmdInfo *Corrente;
		
	Corrente=(CmdInfo *) malloc (sizeof(CmdInfo));
	if (!Corrente)	WX11_FatalError ("Errore. Non posso allocare ADDCom");

	Ultimo=UltimoComando(0,NULL);
	if (!Ultimo)
		PrimoComando(1,Corrente);
	else
		Ultimo->Next=Corrente;

	Corrente->Name=NULL;
	Corrente->Tipo=Tipo;
	Corrente->parent=parent;
	Corrente->win=win;
	Corrente->x=x;
	Corrente->y=y;
	Corrente->Width=Width;
	Corrente->Height=Height;

	Corrente->Gradiant=0;
	Corrente->Bg=colorbg;
	Corrente->Fg=colorfg;
	
	Corrente->Bordo=Bordo;	
	Corrente->BUpDn=0;
	Corrente->MouseOver=0;
	Corrente->Focus=0;	
	Corrente->Stato=0;
	Corrente->Attivo=1;
	Corrente->Hidden=0;
	Corrente->Lock=0;
	Corrente->IsButton=0;

	Corrente->scroll_tipo=0;
	Corrente->scrollv=NULL;
	Corrente->scrollh=NULL;
        
        Corrente->say_x=0;
        Corrente->say_y=0;
	Corrente->scroll_x=0;
	Corrente->scroll_y=0;
	Corrente->scroll_max_x=0;
	Corrente->scroll_max_y=0;
	Corrente->input_x=0;

	Corrente->Font=WX11_FontCurrent ();

        //
	//Corrente->Label=Label;
        Corrente->Label=NULL;
        int lenlab=Label ? strlen(Label) : 0;
        if (Label && lenlab)
        {
            Corrente->Label=(char *) malloc (lenlab + 1);
            memcpy (Corrente->Label,Label,lenlab + 1);
        }

        Corrente->gc=NULL;

	Corrente->pix=0;
	Corrente->pix_width=0;
	Corrente->pix_height=0;
	Corrente->pix_depth=0;
	Corrente->pix_x=0;
	Corrente->pix_y=0;

	//Corrente->ximage=NULL;
	//Corrente->ximage_width=0;
	//Corrente->ximage_height=0;

	Corrente->signal=NULL;
	
	Corrente->Prev=Ultimo;
	Corrente->Next=NULL;
	//
	//
	WX11_UpDateScrollMax (Corrente); // max
	//
	//
	UltimoComando(1,Corrente);

	return (Corrente);
}

void FreeCom (CmdInfo *cmd)
{
	// Dealloca la struttura dei comandi
	CmdInfo *Corrente=cmd;
	
	if (!Corrente)
		Corrente=UltimoComando(0,NULL);
	
	if (Corrente->Prev)	(Corrente->Prev)->Next=Corrente->Next;  else	PrimoComando (1,Corrente->Next);
	if (Corrente->Next)	(Corrente->Next)->Prev=Corrente->Prev;	else	UltimoComando(1,Corrente->Prev);
	
        if (Corrente->Label)
            free (Corrente->Label);

	WX11_SignalFree (Corrente);	//$$max

        if (Corrente->pix)
            XFreePixmap(WX11_GetDisplay(), Corrente->pix);

	//if (Corrente->ximage)
	//    XDestroyImage(Corrente->ximage);


        WX11_GCFree (Corrente->gc);

	free (Corrente);

}


void FreeSubCom (Window win)
{
	//
	// Nuova versione della FreeCom
	// Chiude tutte le finestre figlie
	// Nb: RICURSIVA - Usare solo questa!!!
	//
	int g;
	CmdInfo *tmp;

	uint count = 0;
	Window root = 0;
	Window parent = 0;
	Window* children = 0;
	
	XQueryTree(WX11_GetDisplay(),win, &root, &parent, &children, &count);	
	for (g=0;g<count;g++)
	{
		tmp=CercaComando(children[g]);
		//printf ("Figlio ptr=%p win=%lu\n",tmp,children[g]);
		FreeCom (tmp);

		FreeSubCom (children[g]);
	}
	XFree (children);
}

void xFreeCmd (CmdInfo *cmd)
{
	Window win;
	//printf ("xFreeCmd %p %lu\n",cmd,cmd->win);

	if (!cmd) return;
	if (cmd->Bordo) cmd=cmd->Prev;
		
	win=cmd->win;

	FreeSubCom (win);
	FreeCom (cmd);
	XDestroyWindow(WX11_GetDisplay(), win);
	
}

void xFreeSubCmd (CmdInfo *cmd)
{
	Window win;
	if (!cmd) return;
	//if (cmd->Bordo) cmd=cmd->Prev;
		
	win=cmd->win;

	FreeSubCom (win);
	//FreeCom (cmd);
	//XDestroyWindow(WX11_GetDisplay(), win);
	XDestroySubwindows(WX11_GetDisplay(), win);

}

void ChiudeComando (CmdInfo *cmd)
{
	//
	// ChiudeComando e' auutualmente usato
	// dal menu.
	// Deve essere rivisto in una situazione globale 
	// dei figli
	static int depth=0;
	Window win;
	int x,y,Width,Height;
	if (cmd)
	{
		win=cmd->win;
		x=cmd->x;
		y=cmd->y;
		Width=cmd->Width;
		Height=cmd->Height;
		if (cmd->Bordo)
		{
			win=cmd->parent;
			depth=cmd->Bordo;
			x=x-depth; y=y-depth;
			Width=Width+(depth*2); Height=Height+(depth*2);
			FreeCom(CercaComando(cmd->parent));
		}
		XClearArea(
			WX11_GetDisplay(), 
			cmd->parent,
			x, 
			y, 
			Width, 
			Height, 
			1
			);

		XDestroyWindow(WX11_GetDisplay(), win);
		FreeCom (cmd);
	}

}

CmdInfo * WX11_CmdOpen (
			int Tipo,
			CmdInfo * cmd_parent, 
			int x, int y, 
			int Width , int Height,
		        unsigned int colorbg , unsigned int colorfg,
			int Bordo,
			char *Descr)
{
	Display *display=WX11_GetDisplay();
	CmdInfo *comando;
	Window win,win_parent;
	//Cursor   cursor;
	//unsigned int cursor_shape=XC_left_ptr;
	Atom wm_delete_window;
	XSizeHints hints;
	//Button1MotionMask |
	long mask= 	EnterWindowMask | LeaveWindowMask |
			ButtonPressMask | ButtonReleaseMask |
			//Button1MotionMask |
		
			//StructureNotifyMask |
			ExposureMask |

			KeyPressMask ;

	

	///////////////////////////////
	// Se la Finestra e' un MAIN 
	// ridefinisce il parent e
	// abilita eventi move/resize

	if (Tipo==MAIN)
	{
		win_parent=DefaultRootWindow(WX11_GetDisplay());
		// abilita evento di 
		//move/resize/iconify...
		mask=mask | StructureNotifyMask ;
		//XGrabKeyboard(WX11_GetDisplay(), win_parent, True,GrabModeAsync, GrabModeAsync, CurrentTime);
	}
	else
			
		win_parent=cmd_parent->win;

	// Abilita evento movimento
	if (Tipo==SCROLL_VCUR || Tipo==SCROLL_HCUR)
		mask=mask | Button1MotionMask;


	///////////////////////////////
	// Se il Comando ha un Bordo 
	// Crea una Finestra parent definita 'BORDO' 
	if (Bordo)
	{
		win=XCreateSimpleWindow (
				WX11_GetDisplay(),
				win_parent,
				x-Bordo,y-Bordo,
				Width+(Bordo*2), Height+(Bordo*2),
				0,
				WX11_RGB(NERO),
				WX11_RGB(cmd_parent->Bg) /* ex colorbg */
				);
		comando=AddCom (
				BORDO,
				win_parent,
				win,
				x-Bordo,y-Bordo,
				Width+(Bordo*2), Height+(Bordo*2),
				colorbg,colorfg,
				0,
				"");
	
		XMapWindow (WX11_GetDisplay(),win);	

		XSelectInput(
			WX11_GetDisplay(), win,
			mask
		);	
		
		win_parent=win;
		x=Bordo; y=Bordo;
		
	}
	///////////////////////////////
	// Crea la Finestra per il Comando
	win=XCreateSimpleWindow(
			WX11_GetDisplay(), 
			win_parent,
			x,y,
			Width,Height,
			0,
			WX11_RGB(NERO), 
			WX11_RGB(colorbg)	
			);

	comando=AddCom (Tipo,win_parent,win,x,y,Width,Height,colorbg,colorfg,Bordo,Descr);

	//if (Tipo==MAIN)
	//	XGrabKeyboard(WX11_GetDisplay(), win, True,GrabModeAsync, GrabModeAsync, CurrentTime);


	hints.flags = PPosition | PSize | PMinSize | PMaxSize | PWinGravity;
	//hints.flags = PPosition | PSize | PWinGravity;	
	hints.x=x;
	hints.y=y;
	hints.width=Width;
	hints.height=Height;
	hints.min_width = hints.max_width = Width;
	hints.min_height= hints.max_height = Height;
	hints.win_gravity = CenterGravity;

	XSetWMNormalHints(WX11_GetDisplay(), win, &hints);


// POPUP
/*
	XSetWindowAttributes attributes;
	attributes.override_redirect=1;
	XChangeWindowAttributes(WX11_GetDisplay(), win, CWOverrideRedirect, &attributes);
*/

	///////////////////////////////
	// Intercetta il close con 'x'
	wm_delete_window = XInternAtom(display, "WM_DELETE_WINDOW", 0);
	XSetWMProtocols(display, win, &wm_delete_window, 1);
	//
	XSelectInput(
			WX11_GetDisplay(), win,
			mask
			);	
	
/*	
	///////////////////////////////
	// Definisce il Tipo di Cursore
	if (	Tipo==BUTTON ||
		Tipo==MENU || Tipo==MENU_ITEM ||
		Tipo==LIST_BOX || Tipo==COMBO_BOX ||
		Tipo==SCROLL_UP || Tipo==SCROLL_DN ||
		Tipo==SCROLL_SX || Tipo==SCROLL_DX
		)
		cursor_shape=XC_hand2;
	else if (Tipo==INPUT)
		cursor_shape=XC_xterm;
	else
		cursor_shape=XC_left_ptr;

	cursor = XCreateFontCursor( WX11_GetDisplay(), cursor_shape );
	XDefineCursor( WX11_GetDisplay(), win, cursor );
*/
	if (Tipo!=MAIN)
	{
		///////////////////////////////
		// Mappa la finestra
		XMapWindow (WX11_GetDisplay(),win);
	
		//XFlush (WX11_GetDisplay()); // Solo per Tipo MAIN ?!
	}
	
	return (comando);
}


int ComandoAccesoSpento (int Focus,Window win)
{
	static CmdInfo *Pb;
	int f=0;
	int Ecode=0,NComando=0;
	if (win==0)
	{
		if (Pb)
		{
			Pb->Focus=0;
			WX11_BorderRelief(Pb);
		}
		return 0;
	}
	Pb=PrimoComando(0,NULL);
	while (Pb && !f)
	{
		if (Pb->win==win)
		{
			if (Pb->Focus==1 && Focus==0)
				Ecode=1;

			Pb->Focus=Focus;
			f=1;
			WX11_BorderRelief(Pb);	
		}
		else
		{
			Pb=Pb->Next;	
			NComando++;	
		}
	}
	if (Ecode)
		NComando++;
	else
		NComando=0;
	
	return (NComando);
}

int IsComando (CmdInfo *cmd)
{
	CmdInfo * comando=PrimoComando(0,NULL);

	while (comando)
	{
		if (comando==cmd) 
                    return (1);
		else
                    comando=comando->Next;
	}
	return (0);
}

CmdInfo *CercaComando (Window win)
{
	CmdInfo * comando=PrimoComando(0,NULL);
	int f=0;
	while (comando && !f)
	{
		if (comando->win==win)
		{
			f=1;
		}
		else
			comando=comando->Next;
	}
	return (comando);
}

CmdInfo *CercaNomeComando (char *Name)
{
	CmdInfo * comando=PrimoComando(0,NULL);
	int f=0;
	while (comando && !f)
	{
		if (comando->Name && !strcmp(comando->Name,Name))
		{
			f=1;
		}
		else
			comando=comando->Next;
	}
	return (comando);
}


void AddNomeComando (CmdInfo *cmd,char *Name)
{
	cmd->Name=Name;
}

void WX11_CmdLabelChange (CmdInfo *cmd,char *NewLabel)
{
    //
    // Cambia Label al comando
    //
    int x=0;

    if (!cmd) return;
		
    XUnmapWindow(WX11_GetDisplay(), cmd->win);
    //
    if (cmd->Tipo==INPUT)
    {
        for (x=0;x<strlen(cmd->Label);x++)
        {
            if (x < strlen(NewLabel)) 
                cmd->Label[x]=NewLabel[x];
            else
                cmd->Label[x]=' ';
        }
    }
    else if (cmd->Tipo==LABEL)
    {
        cmd->Width=XTextWidth(cmd->Font,NewLabel,strlen(NewLabel))+WX11_SPACE_BETWEEN_BORDERS;
        XResizeWindow(WX11_GetDisplay(), cmd->win, cmd->Width, cmd->Height);
        //
        cmd->Label=(char *) realloc (cmd->Label,strlen(NewLabel)+1);
        strcpy(cmd->Label,NewLabel);
        if (cmd->Bordo)
        {
            CmdInfo *cmdbrd=cmd->Prev;

            XUnmapWindow(WX11_GetDisplay(), cmdbrd->win);
            cmdbrd->Width=(cmd->Width)+(cmd->Bordo*2);
            XResizeWindow(WX11_GetDisplay(), cmdbrd->win, 
            cmdbrd->Width, cmdbrd->Height);
            XMapWindow(WX11_GetDisplay(), cmdbrd->win);
        }
    }
    else 
    {
	cmd->Label=(char *) realloc (cmd->Label,strlen(NewLabel)+1);
	strcpy(cmd->Label,NewLabel);
    }
    //
    XMapWindow(WX11_GetDisplay(), cmd->win);
    WX11_PrintFlush(cmd);
}


void CambiaLabel (char *Name,char *NewLabel)
{
	//
	// Cambia Label al comando
	//
	CmdInfo * cmd=NULL;

	cmd=CercaNomeComando (Name);
        WX11_CmdLabelChange (cmd,NewLabel);
}


CmdInfo * GetPrevTopLevelWindow ()
{
	// 
	// Prende la precedente window main 
	// se non presente restituisce NULL
	//
	// Viene usata dalla WM_TRANSIENT_FOR
	//
	CmdInfo *cmd=UltimoComando (0,NULL);//mio;

	while (cmd && cmd->Tipo!=MAIN) cmd=cmd->Prev;

	return (cmd);
}

void WX11_DisableTopLevelWindow (CmdInfo *cmd)
{
	//
	// Disabilita tutti i comandi 
	// della window main
	// 
	// Viene usata dalla WM_TRANSIENT_FOR
	//
	CmdInfo *tmp=cmd;
	tmp->Lock=1;
	tmp=tmp->Next;
	while (tmp && tmp->Tipo!=MAIN)
	{
		tmp->Lock=1;
		tmp=tmp->Next;
	}
}

void WX11_EnableTopLevelWindow (CmdInfo *cmd)
{
	//
	// Abilita tutti i comandi 
	// della window main
	// 
	// Viene usata dalla WM_TRANSIENT_FOR
	//
	CmdInfo *tmp=cmd;
	tmp->Lock=0;
	tmp=tmp->Next;
	while (tmp && tmp->Tipo!=MAIN)
	{
		tmp->Lock=0;
		tmp=tmp->Next;
	}
}


