/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking.ui;

import com.vlsolutions.swing.docking.AutoHideButton;
import com.vlsolutions.swing.docking.DockingConstants;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

/** The UI delegate for AutoHideButtons.
 *<p>
 * This UI uses the following properties :
 * <ul>
 * <li> UIManager.getBorder("AutoHideButton.expandBorderTop")
 * <li> UIManager.getBorder("AutoHideButton.expandBorderLeft")
 * <li> UIManager.getBorder("AutoHideButton.expandBorderBottom")
 * <li> UIManager.getBorder("AutoHideButton.expandBorderRight")
 * </ul>
 * <p>
 * Feel free to provide different borders they will be used accordingly to the 
 * positionning of the button (TOP, LEFT..)
 *
 * @see DockingUISettings
 * @author Lilian Chamontin, VLSolutions
 */
public class AutoHideButtonUI extends BasicLabelUI implements PropertyChangeListener {
  
  protected static AutoHideButtonUI instance = new AutoHideButtonUI();
  

  public AutoHideButtonUI() {
  }
  
  /**
   * Creates a new DockingSplitPaneUI instance
   */
  public static ComponentUI createUI(JComponent x) {
    return instance;
  }

  public void installUI(JComponent comp){
    super.installUI(comp);
    
    AutoHideButton btn = (AutoHideButton) comp;
    
    installBorder(btn);
    
    btn.addPropertyChangeListener(AutoHideButton.PROPERTY_ZONE, this);
    
    //Font f = UIManager.getFont("MenuItem.font");
    Font f = UIManager.getFont("AutoHideButton.font");
    if (f != null) {
      btn.setFont(f);
    } else {
      btn.setFont(new Font("Dialog", Font.PLAIN, 10));
    }
  }
  
  public void uninstallUI(JComponent comp){
    super.uninstallUI(comp);    
    comp.setBorder(null);
    comp.removePropertyChangeListener(AutoHideButton.PROPERTY_ZONE, this);    
  }
  
  public void propertyChange(PropertyChangeEvent e){
    if (e.getPropertyName().equals(AutoHideButton.PROPERTY_ZONE)){
      installBorder((AutoHideButton)e.getSource());
    } else {
      super.propertyChange(e);
    }
  }
  
  protected void installBorder(AutoHideButton btn){
    switch (btn.getZone()){
      case DockingConstants.INT_HIDE_TOP:
        btn.setBorder(UIManager.getBorder("AutoHideButton.expandBorderTop"));
        break;
      case DockingConstants.INT_HIDE_LEFT:
        btn.setBorder(UIManager.getBorder("AutoHideButton.expandBorderLeft"));
        break;
      case DockingConstants.INT_HIDE_BOTTOM:
        btn.setBorder(UIManager.getBorder("AutoHideButton.expandBorderBottom"));
        break;
      case DockingConstants.INT_HIDE_RIGHT:
        btn.setBorder(UIManager.getBorder("AutoHideButton.expandBorderRight"));
        break;
    }
  }



  
  /** Overriden to paint properly the button on vertical sides.
   */
  public void paint(Graphics g, JComponent comp){
    AutoHideButton btn = (AutoHideButton) comp;
    int zone = btn.getZone();
    if (zone == DockingConstants.INT_HIDE_TOP || zone == DockingConstants.INT_SPLIT_BOTTOM){
      super.paint(g, comp);
    } else {
      // vertical button : we have to rely on a custom paint
      if (btn.isOpaque()) {
        g.setColor(btn.getBackground());
        g.fillRect(0, 0, btn.getWidth(), btn.getHeight());
      }
      
      double pid2 = Math.PI / 2d;
      Graphics2D g2 = ( (Graphics2D) g.create());
      g2.setFont(btn.getFont());
      g2.setColor(btn.getForeground());
      FontMetrics fm = btn.getFontMetrics(btn.getFont());
      Icon icon = btn.getIcon();
      Insets i = btn.getInsets();
      
      String text = btn.getText(); // 2005/07/12 added text != null controls
      
      if (zone == DockingConstants.INT_HIDE_LEFT) {
        g2.translate(0, btn.getHeight());
        g2.rotate( -pid2);
        if (icon != null) {
          icon.paintIcon(btn, g2, i.bottom, i.left);
          if (text != null){
            g2.drawString(text,
                i.bottom + icon.getIconWidth() + btn.getIconTextGap(),
                i.left + btn.getWidth() / 2 +
                fm.getAscent() / 2 /*       fm.getAscent()*/);
          }
        } else {
          if (text != null){
            g2.drawString(text, i.bottom,
                i.left + btn.getWidth() / 2 + fm.getAscent() / 2);
          }
        }
      } else {
        g2.translate(btn.getWidth(), 0);
        g2.rotate(pid2);
        if (icon != null) {
          icon.paintIcon(btn, g2, 1, 1);
          if (text != null){
            g2.drawString(text, i.top + icon.getIconWidth() + btn.getIconTextGap(),
                btn.getWidth() / 2 + fm.getAscent() / 2);
          }
        } else {
          if (text != null){
            g2.drawString(text, i.top,
                btn.getWidth() / 2 + fm.getAscent() / 2);
          }
        }
      }
    }
  }
}

