#define TEAGN_ENABLE_STDOUT_LOG

#include <TePDIExamplesBase.hpp>

#include <TePDIParameters.hpp>
#include <TeAgnostic.h>
#include <TePDIUtils.hpp>
#include <TePDIGeoMosaic.hpp>
#include <TePDIBatchGeoMosaic.hpp>

#include <TeInitRasterDecoders.h>
#include <TeProgress.h>
#include <TeStdIOProgress.h>

#include <vector> 

void GeoMosaic_noblend_test()
{
  TePDIParameters params1;

  /* Building rasters */

  TePDITypes::TePDIRasterPtrType input_raster1( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_A.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster1->init(), 
    "Unable to init input_raster1" );
    
  TePDITypes::TePDIRasterPtrType input_raster2( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_B_contraste.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster2->init(), 
    "Unable to init input_raster2" );    
    
  TePDITypes::TePDIRasterPtrType output_raster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( output_raster,
    1, 1, 1, false, TeDOUBLE, 0 ), "output_raster Alloc error" );
    
  params1.SetParameter( "input_raster1" , input_raster1 );
  params1.SetParameter( "input_raster2" , input_raster2 );
  params1.SetParameter( "output_raster" , output_raster );
  
  std::vector< int > channels1;
  channels1.push_back( 0 );
  params1.SetParameter( "channels1" , channels1 );
  
  std::vector< int > channels2;
  channels2.push_back( 0 );
  params1.SetParameter( "channels2" , channels2 );
  
  params1.SetParameter( "blending_type" , std::string( "no_blending" ) );
  params1.SetParameter( "dummy_value" , (double)0. );
  params1.SetParameter( "keep_best_res" , (int)1 );
  params1.SetParameter( "auto_equalize" , (int)1 );
  
  TePDIGeoMosaic mos;
  TEAGN_TRUE_OR_THROW( mos.Reset(params1), "Reset failed" );
  TEAGN_TRUE_OR_THROW( mos.Apply(), "Apply error" );
  
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_raster,
    TEPDIEXAMPLESBINPATH "Mosaic_geo_noblend_test.tif" ), "GeoTIF generation error" );
}

void GeoMosaic_euclidian_test()
{
  TePDIParameters params1;

  /* Building rasters */

  TePDITypes::TePDIRasterPtrType input_raster1( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_A.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster1->init(), 
    "Unable to init input_raster1" );
    
  TePDITypes::TePDIRasterPtrType input_raster2( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_B_contraste.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster2->init(), 
    "Unable to init input_raster2" );    
    
  TePDITypes::TePDIRasterPtrType output_raster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( output_raster,
    1, 1, 1, false, TeDOUBLE, 0 ), "output_raster Alloc error" );
    
  params1.SetParameter( "input_raster1" , input_raster1 );
  params1.SetParameter( "input_raster2" , input_raster2 );
  params1.SetParameter( "output_raster" , output_raster );
  
  std::vector< int > channels1;
  channels1.push_back( 0 );
  params1.SetParameter( "channels1" , channels1 );
  
  std::vector< int > channels2;
  channels2.push_back( 0 );
  
  params1.SetParameter( "channels2" , channels2 );
  params1.SetParameter( "blending_type" , std::string( "euclidian_blending" ) );
  params1.SetParameter( "dummy_value" , (double)0. );
  params1.SetParameter( "auto_equalize" , (int)1 );  
  
  TePDIGeoMosaic mos;
  TEAGN_TRUE_OR_THROW( mos.Reset(params1), "Reset failed" );
  TEAGN_TRUE_OR_THROW( mos.Apply(), "Apply error" );
  
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_raster,
    TEPDIEXAMPLESBINPATH "Mosaic_geo_euclidianblend_test.tif" ), "GeoTIF generation error" );
}


void BatchGeoMosaic_noblend_test()
{
  TePDIParameters params1;

  /* Building rasters */

  TePDITypes::TePDIRasterPtrType input_raster1( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_A.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster1->init(), 
    "Unable to init input_raster1" );
    
  TePDITypes::TePDIRasterPtrType input_raster2( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_B_contraste.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster2->init(), 
    "Unable to init input_raster2" ); 
    
  TePDITypes::TePDIRasterPtrType input_raster3( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_C.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster3->init(), 
    "Unable to init input_raster2" );      
    
  std::vector< int > bands;
  bands.push_back( 0 );   
  bands.push_back( 0 );   
  bands.push_back( 0 );   
    
  TePDITypes::TePDIRasterPtrType output_raster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( output_raster,
    1, 1, 1, false, TeDOUBLE, 0 ), "output_raster Alloc error" );
    
  TePDITypes::TePDIRasterVectorType input_rasters;
  input_rasters.push_back( input_raster1 );
  input_rasters.push_back( input_raster2 );
  input_rasters.push_back( input_raster3 );
    
  params1.SetParameter( "input_rasters" , input_rasters );
  params1.SetParameter( "bands" , bands );
  params1.SetParameter( "output_raster" , output_raster );
  params1.SetParameter( "blending_type" , std::string( "no_blending" ) );
  params1.SetParameter( "dummy_value" , (double)0. );
  params1.SetParameter( "auto_equalize" , (int)1 );
  
  TePDIBatchGeoMosaic mos;
  TEAGN_TRUE_OR_THROW( mos.Reset(params1), "Reset failed" );
  TEAGN_TRUE_OR_THROW( mos.Apply(), "Apply error" );
  
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_raster,
    TEPDIEXAMPLESBINPATH "Mosaic_batchgeo_noblend_test.tif" ), "GeoTIF generation error" );
}



void BatchGeoMosaic_euclidian_test()
{
  TePDIParameters params1;

  /* Building rasters */

  TePDITypes::TePDIRasterPtrType input_raster1( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_A.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster1->init(), 
    "Unable to init input_raster1" );
    
  TePDITypes::TePDIRasterPtrType input_raster2( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_B_contraste.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster2->init(), 
    "Unable to init input_raster2" ); 
    
  TePDITypes::TePDIRasterPtrType input_raster3( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_C.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster3->init(), 
    "Unable to init input_raster2" );      
    
  std::vector< int > bands;
  bands.push_back( 0 );   
  bands.push_back( 0 );   
  bands.push_back( 0 );   
    
  TePDITypes::TePDIRasterPtrType output_raster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( output_raster,
    1, 1, 1, false, TeDOUBLE, 0 ), "output_raster Alloc error" );
    
  TePDITypes::TePDIRasterVectorType input_rasters;
  input_rasters.push_back( input_raster1 );
  input_rasters.push_back( input_raster2 );
  input_rasters.push_back( input_raster3 );
    
  params1.SetParameter( "input_rasters" , input_rasters );
  params1.SetParameter( "bands" , bands );
  params1.SetParameter( "output_raster" , output_raster );
  params1.SetParameter( "blending_type" , std::string( "euclidian_blending" ) );
  params1.SetParameter( "dummy_value" , (double)0. );
  params1.SetParameter( "auto_equalize" , (int)1 );
  
  TePDIBatchGeoMosaic mos;
  TEAGN_TRUE_OR_THROW( mos.Reset(params1), "Reset failed" );
  TEAGN_TRUE_OR_THROW( mos.Apply(), "Apply error" );
  
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_raster,
    TEPDIEXAMPLESBINPATH "Mosaic_batchgeo_euclidianblend_test.tif" ), "GeoTIF generation error" );
}

int main()
{
  TEAGN_LOGMSG( "Test started." );

  try{
    TeInitRasterDecoders();
    
    TeStdIOProgress pi;
    TeProgress::setProgressInterf( dynamic_cast< TeProgressBase* >( &pi ) );     

    GeoMosaic_noblend_test();
    BatchGeoMosaic_noblend_test();
    
    GeoMosaic_euclidian_test();
    BatchGeoMosaic_euclidian_test();
  }
  catch( const TeException& e ){
    TEAGN_LOGERR( "Test Failed - " + e.message() );
    return EXIT_FAILURE;
  } 

  TEAGN_LOGMSG( "Test OK." );
  return EXIT_SUCCESS;
}

