#define TEAGN_ENABLE_STDOUT_LOG

#include <TePDIInterpolator.hpp>

#include <TeAgnostic.h>
#include <TePDITypes.hpp>
#include <TePDIUtils.hpp>

#include <TeInitRasterDecoders.h>

void NN_test()
{
  TePDITypes::TePDIRasterPtrType input_raster;
  
  TeRasterParams params;
  params.nBands( 1 );
  params.nlines_ = 2;
  params.ncols_ = 2;
  params.setDataType( TeDOUBLE, -1 );
    
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( input_raster,
    params, false ), "Allocation error" );
    
  TEAGN_TRUE_OR_THROW( input_raster->setElement( 0, 0, 1.0, 0 ), 
    "error defining raster element");
  TEAGN_TRUE_OR_THROW( input_raster->setElement( 1, 0, 2.0, 0 ), 
    "error defining raster element");
  TEAGN_TRUE_OR_THROW( input_raster->setElement( 0, 1, 3.0, 0 ), 
    "error defining raster element");
  TEAGN_TRUE_OR_THROW( input_raster->setElement( 1, 1, 4.0, 0 ), 
    "error defining raster element");
    
  TePDIInterpolator interp;
  
  TEAGN_TRUE_OR_THROW( interp.reset( input_raster, 
    TePDIInterpolator::NNMethod, 0 ), "Reset error" );
    
  double value = 0;
    
  interp.interpolate( 0, 0, 0, value );
  TEAGN_CHECK_EPS( 1.0, value , 0.000001, "");
  interp.interpolate( 0, 1, 0, value );
  TEAGN_CHECK_EPS( 2.0, value , 0.000001, "");
  interp.interpolate( 1, 0, 0, value );
  TEAGN_CHECK_EPS( 3.0, value , 0.000001, "");
  interp.interpolate( 1, 1, 0, value );
  TEAGN_CHECK_EPS( 4.0, value , 0.000001, "");
  
  interp.interpolate( 0.2, 0.2, 0, value );
  TEAGN_CHECK_EPS( 1.0, value , 0.000001, "");  
  interp.interpolate( 0.7, 0.7, 0, value );
  TEAGN_CHECK_EPS( 4.0, value , 0.000001, "");  
}


void bilinear_test()
{
  TePDITypes::TePDIRasterPtrType input_raster;
  
  TeRasterParams params;
  params.nBands( 1 );
  params.nlines_ = 2;
  params.ncols_ = 2;
  params.setDataType( TeDOUBLE, -1 );
    
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( input_raster,
    params, false ), "Allocation error" );
    
  TEAGN_TRUE_OR_THROW( input_raster->setElement( 0, 0, 1.0, 0 ), 
    "error defining raster element");
  TEAGN_TRUE_OR_THROW( input_raster->setElement( 1, 0, 2.0, 0 ), 
    "error defining raster element");
  TEAGN_TRUE_OR_THROW( input_raster->setElement( 0, 1, 3.0, 0 ), 
    "error defining raster element");
  TEAGN_TRUE_OR_THROW( input_raster->setElement( 1, 1, 4.0, 0 ), 
    "error defining raster element");
    
  TePDIInterpolator interp;
  
  TEAGN_TRUE_OR_THROW( interp.reset( input_raster, 
    TePDIInterpolator::BilinearMethod, 0 ), "Reset error" );
    
  double value = 0;
    
  interp.interpolate( 0, 0, 0, value );
  TEAGN_CHECK_EPS( 1.0, value , 0.000001, "");
  interp.interpolate( 0, 1, 0, value );
  TEAGN_CHECK_EPS( 2.0, value , 0.000001, "");
  interp.interpolate( 1, 0, 0, value );
  TEAGN_CHECK_EPS( 3.0, value , 0.000001, "");
  interp.interpolate( 1, 1, 0, value );
  TEAGN_CHECK_EPS( 4.0, value , 0.000001, "");
  
  interp.interpolate( 0.5, 0.5, 0, value );
  TEAGN_CHECK_EPS( 2.5, value , 0.000001, "");  
}


void bicubic_test()
{
  TePDITypes::TePDIRasterPtrType input_raster;
  
  TeRasterParams params;
  params.nBands( 1 );
  params.nlines_ = 4;
  params.ncols_ = 4;
  params.setDataType( TeDOUBLE, -1 );
    
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( input_raster,
    params, false ), "Allocation error" );
    
  unsigned int line = 0;
  unsigned int col = 0;  
  
  for( line = 0 ; line < 4 ; ++line ) {
    for( col = 0 ; col < 4 ; ++col ) {
      TEAGN_TRUE_OR_THROW( input_raster->setElement( col, line, 1.0, 0 ), 
      "error defining raster element");  
    }
  }
    
  TePDIInterpolator interp;
  
  TEAGN_TRUE_OR_THROW( interp.reset( input_raster, 
    TePDIInterpolator::BicubicMethod, 0 ), "Reset error" );
    
  double value = 0;
  
  for( line = 0 ; line < 4 ; ++line ) {
    for( col = 0 ; col < 4 ; ++col ) {
      interp.interpolate( (double)line, (double)col, 0, value );
      TEAGN_CHECK_EPS( 1.0, value , 0.000001, "");
    }
  }  
  
  interp.interpolate( 1.5, 1.5, 0, value );
  TEAGN_CHECK_EPS( 1.0, value , 0.000001, "");  
}


int main()
{
  TEAGN_LOGMSG( "Test started." );

  try{
    TeInitRasterDecoders();

    NN_test();
    bilinear_test();
    bicubic_test();
  }
  catch( const TeException& excpt ){
    TEAGN_LOGERR( excpt.message() )
    return EXIT_FAILURE;
  }

  TEAGN_LOGMSG( "Test OK." );
  return EXIT_SUCCESS;
}

