#define TEAGN_ENABLE_STDOUT_LOG

#include <TePDIExamplesBase.hpp>

#include <TePDIBlending.hpp>

#include <TePDIParameters.hpp>
#include <TeAgnostic.h>
#include <TePDIUtils.hpp>

#include <TeInitRasterDecoders.h>
#include <TeProgress.h>
#include <TeStdIOProgress.h>

#include <vector>

void Noblend_TeOVERPLAPS_RGB_test()
{
  TePDIParameters blend_params;

  /* Building rasters */

  TePDITypes::TePDIRasterPtrType input_raster1( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_rgb342_crop2.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster1->init(), 
    "Unable to init input_raster1" );
    
  TePDITypes::TePDIRasterPtrType input_raster2( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_rgb342_crop1.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster2->init(), 
    "Unable to init input_raster2" );
    
  TePDITypes::TePDIRasterPtrType output_raster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( output_raster,
    1, 1, 1, false, TeUNSIGNEDCHAR, 0 ), "output_raster Alloc error" );
    
  blend_params.SetParameter( "blending_type" , std::string( "no_blending" ) );
  blend_params.SetParameter( "input_raster1" , input_raster1 );
  blend_params.SetParameter( "input_raster2" , input_raster2 );
  blend_params.SetParameter( "output_raster" , output_raster );
  
  std::vector< int > channels1;
  channels1.push_back( 0 );
  channels1.push_back( 1 );
  channels1.push_back( 2 );
  blend_params.SetParameter( "channels1" , channels1 );
  
  std::vector< int > channels2;
  channels2.push_back( 0 );
  channels2.push_back( 1 );
  channels2.push_back( 2 );
  blend_params.SetParameter( "channels2" , channels2 );
  
  TeBox input_raster1_box = input_raster1->params().boundingBox();
  TePDITypes::TePDIPolygonPtrType raster1_pol_ptr(
    new TePolygon );
  *raster1_pol_ptr = polygonFromBox( input_raster1_box );
  blend_params.SetParameter( "raster1_pol_ptr" , raster1_pol_ptr );

  TeBox input_raster2_box = input_raster2->params().boundingBox();
  TePDITypes::TePDIPolygonPtrType raster2_pol_ptr(
    new TePolygon );  
  *raster2_pol_ptr = polygonFromBox( input_raster2_box );
  blend_params.SetParameter( "raster2_pol_ptr" , raster2_pol_ptr );
  
  double raster2_pol_offset_x = 
    input_raster1->coord2Index(
      input_raster2->index2Coord( TeCoord2D( 0, 0 ) ) ).x();
  blend_params.SetParameter( "raster2_pol_offset_x" , raster2_pol_offset_x );
  
  double raster2_pol_offset_y = 
    input_raster1->coord2Index(
      input_raster2->index2Coord( TeCoord2D( 0, 0 ) ) ).y();
  blend_params.SetParameter( "raster2_pol_offset_y" , raster2_pol_offset_y );

  blend_params.SetParameter( "auto_equalize" , (int)1 );
  
  blend_params.SetParameter( "dummy_value" , (double)0 );

  blend_params.SetParameter( "enable_multi_thread" , (int)1 );

  TePDIBlending blend_instance;
  TEAGN_TRUE_OR_THROW( blend_instance.Reset(blend_params), "Reset error" );
  TEAGN_TRUE_OR_THROW( blend_instance.Apply(), "Apply error" );
  
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_raster,
    TEPDIEXAMPLESBINPATH "Blending_noblend_TeOVERPLAPS_test.tif" ), "GeoTIF generation error" );
}


void Noblend_TeWITHIN_test()
{
  TePDIParameters blend_params;

  /* Building rasters */

  TePDITypes::TePDIRasterPtrType input_raster1( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster1->init(), 
    "Unable to init input_raster1" );
    
  TePDITypes::TePDIRasterPtrType input_raster2_disk( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_A.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster2_disk->init(), 
    "Unable to init input_raster2" );
    
  /* Building a input_raster2 with 3 bands no projection */
    
  TePDITypes::TePDIRasterPtrType input_raster2( new TeRaster() );
  {
    TeRasterParams input_raster2_params;
    input_raster2_params.nBands( 1 );
    input_raster2_params.setDataType( TeUNSIGNEDCHAR, -1 );
    input_raster2_params.boxResolution( 0, 0, 
      (double)( input_raster2_disk->params().ncols_ - 1 ),
      (double)( input_raster2_disk->params().nlines_ - 1 ), 1, 1 );
      
    TeProjectionParams projparams;
    projparams.name = "NoProjection";
    TeSharedPtr< TeProjection > proj( TeProjectionFactory::make( projparams ) );          
    input_raster2_params.projection( proj.nakedPointer() );        
      
    TEAGN_TRUE_OR_THROW( 
      ( input_raster2_params.nlines_ == input_raster2_disk->params().nlines_ ),
      "Invalid box lines" )
    TEAGN_TRUE_OR_THROW( 
      ( input_raster2_params.ncols_ == input_raster2_disk->params().ncols_ ),
      "Invalid box lines" )
    
    TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( input_raster2,
      input_raster2_params, false ), "adjust_raster Alloc error" );   
      
    TEAGN_TRUE_OR_THROW( TePDIUtils::TeCopyRasterBands( input_raster2_disk,
      input_raster2, false, false ), "Pixel copy error" );
  }        
    
  TePDITypes::TePDIRasterPtrType output_raster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( output_raster,
    1, 1, 1, false, TeDOUBLE, 0 ), "output_raster Alloc error" );
    
  blend_params.SetParameter( "blending_type" , std::string( "no_blending" ) );
  blend_params.SetParameter( "input_raster1" , input_raster1 );
  blend_params.SetParameter( "input_raster2" , input_raster2 );
  blend_params.SetParameter( "output_raster" , output_raster );
  
  std::vector< int > channels1;
  channels1.push_back( 0 );
  blend_params.SetParameter( "channels1" , channels1 );
  
  std::vector< int > channels2;
  channels2.push_back( 0 );
  blend_params.SetParameter( "channels2" , channels2 );
  
  TeBox input_raster1_box = input_raster1->params().boundingBox();
  TePDITypes::TePDIPolygonPtrType raster1_pol_ptr(
    new TePolygon );
  *raster1_pol_ptr = polygonFromBox( input_raster1_box );
  blend_params.SetParameter( "raster1_pol_ptr" , raster1_pol_ptr );

  TeBox input_raster2_box = input_raster2->params().boundingBox();
  TePDITypes::TePDIPolygonPtrType raster2_pol_ptr(
    new TePolygon );  
  *raster2_pol_ptr = polygonFromBox( input_raster2_box );
  blend_params.SetParameter( "raster2_pol_ptr" , raster2_pol_ptr );
  
  double raster2_pol_offset_x = input_raster1->coord2Index(
    input_raster2_disk->index2Coord( TeCoord2D( 0, 0 ) ) ).x();
  blend_params.SetParameter( "raster2_pol_offset_x" , raster2_pol_offset_x );
  
  double raster2_pol_offset_y = input_raster1->coord2Index(
    input_raster2_disk->index2Coord( TeCoord2D( 0, 0 ) ) ).y();
  blend_params.SetParameter( "raster2_pol_offset_y" , raster2_pol_offset_y );

  blend_params.SetParameter( "auto_equalize" , (int)1 );
  
  blend_params.SetParameter( "dummy_value" , (double)0 );
  
  blend_params.SetParameter( "enable_multi_thread" , (int)1 );
    
  TePDIBlending blend_instance;
  TEAGN_TRUE_OR_THROW( blend_instance.Reset(blend_params), "Reset error" );
  TEAGN_TRUE_OR_THROW( blend_instance.Apply(), "Apply error" );
  
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_raster,
    TEPDIEXAMPLESBINPATH "Blending_no_blend_TeWITHIN_test.tif" ), "GeoTIF generation error" );
}

void Euclidian_TeOVERPLAPS_test()
{
  TePDIParameters blend_params;

  /* Building rasters */

  TePDITypes::TePDIRasterPtrType input_raster1( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_A.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster1->init(), 
    "Unable to init input_raster1" );
    
  TePDITypes::TePDIRasterPtrType input_raster2_disk( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_B_contraste.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster2_disk->init(), 
    "Unable to init input_raster2" );
    
  /* Building a input_raster2 with no projection */
    
  TePDITypes::TePDIRasterPtrType input_raster2( new TeRaster() );
  {
    TeRasterParams input_raster2_params;
    input_raster2_params.nBands( 1 );
    input_raster2_params.setDataType( TeUNSIGNEDCHAR, -1 );
    input_raster2_params.boxResolution( 0, 0, 
      (double)( input_raster2_disk->params().ncols_ - 1 ),
      (double)( input_raster2_disk->params().nlines_ - 1 ), 1, 1 );
      
    TeProjectionParams projparams;
    projparams.name = "NoProjection";
    TeSharedPtr< TeProjection > proj( TeProjectionFactory::make( projparams ) );          
    input_raster2_params.projection( proj.nakedPointer() );      
      
    TEAGN_TRUE_OR_THROW( 
      ( input_raster2_params.nlines_ == input_raster2_disk->params().nlines_ ),
      "Invalid box lines" )
    TEAGN_TRUE_OR_THROW( 
      ( input_raster2_params.ncols_ == input_raster2_disk->params().ncols_ ),
      "Invalid box lines" )
    
    TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( input_raster2,
      input_raster2_params, false ), "adjust_raster Alloc error" );   
    TEAGN_TRUE_OR_THROW( TePDIUtils::TeCopyRasterBands( input_raster2_disk,
      input_raster2, false, false ), "Pixel copy error" );
  }        
    
  TePDITypes::TePDIRasterPtrType output_raster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( output_raster,
    1, 1, 1, false, TeDOUBLE, 0 ), "output_raster Alloc error" );
    
  blend_params.SetParameter( "blending_type" , 
    std::string( "euclidian_blending" ) );
  blend_params.SetParameter( "input_raster1" , input_raster1 );
  blend_params.SetParameter( "input_raster2" , input_raster2 );
  blend_params.SetParameter( "output_raster" , output_raster );
  
  std::vector< int > channels1;
  channels1.push_back( 0 );
  blend_params.SetParameter( "channels1" , channels1 );
  
  std::vector< int > channels2;
  channels2.push_back( 0 );
  blend_params.SetParameter( "channels2" , channels2 );
  
  TeBox input_raster1_box = input_raster1->params().boundingBox();
  TePDITypes::TePDIPolygonPtrType raster1_pol_ptr(
    new TePolygon );
  *raster1_pol_ptr = polygonFromBox( input_raster1_box );
  blend_params.SetParameter( "raster1_pol_ptr" , raster1_pol_ptr );

  TeBox input_raster2_box = input_raster2->params().boundingBox();
  TePDITypes::TePDIPolygonPtrType raster2_pol_ptr(
    new TePolygon );  
  *raster2_pol_ptr = polygonFromBox( input_raster2_box );
  blend_params.SetParameter( "raster2_pol_ptr" , raster2_pol_ptr );
  
  double raster2_pol_offset_x = input_raster1->coord2Index(
    input_raster2_disk->index2Coord( TeCoord2D( 0, 0 ) ) ).x();
  blend_params.SetParameter( "raster2_pol_offset_x" , raster2_pol_offset_x );
  
  double raster2_pol_offset_y = input_raster1->coord2Index(
    input_raster2_disk->index2Coord( TeCoord2D( 0, 0 ) ) ).y();
  blend_params.SetParameter( "raster2_pol_offset_y" , raster2_pol_offset_y );

  blend_params.SetParameter( "auto_equalize" , (int)1 );
  
  blend_params.SetParameter( "dummy_value" , (double)0 );
  
//  blend_params.SetParameter( "draw_blend_lines" , (double)255 );

  blend_params.SetParameter( "enable_multi_thread" , (int)1 );
    
  TePDIBlending blend_instance;
  TEAGN_TRUE_OR_THROW( blend_instance.Reset(blend_params), "Reset error" );
  TEAGN_TRUE_OR_THROW( blend_instance.Apply(), "Apply error" );
  
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_raster,
    TEPDIEXAMPLESBINPATH "Blending_euclidian_TeOVERPLAPS_test.tif" ), "GeoTIF generation error" );
}


void Euclidian_TeWITHIN_test()
{
  TePDIParameters blend_params;

  /* Building rasters */

  TePDITypes::TePDIRasterPtrType input_raster1( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster1->init(), 
    "Unable to init input_raster1" );
    
  TePDITypes::TePDIRasterPtrType input_raster2_disk( new TeRaster(
    std::string( TEPDIEXAMPLESRESPATH "cbers_b2_crop_B_contraste.tif" ), 'r' ) );
  TEAGN_TRUE_OR_THROW( input_raster2_disk->init(), 
    "Unable to init input_raster2" );
    
  /* Building a input_raster2 with no projection */
    
  TePDITypes::TePDIRasterPtrType input_raster2( new TeRaster() );
  {
    TeRasterParams input_raster2_params;
    input_raster2_params.nBands( 1 );
    input_raster2_params.setDataType( TeUNSIGNEDCHAR, -1 );
    input_raster2_params.boxResolution( 0, 0, 
      (double)( input_raster2_disk->params().ncols_ - 1 ),
      (double)( input_raster2_disk->params().nlines_ - 1 ), 1, 1 );
      
    TeProjectionParams projparams;
    projparams.name = "NoProjection";
    TeSharedPtr< TeProjection > proj( TeProjectionFactory::make( projparams ) );          
    input_raster2_params.projection( proj.nakedPointer() );      
      
    TEAGN_TRUE_OR_THROW( 
      ( input_raster2_params.nlines_ == input_raster2_disk->params().nlines_ ),
      "Invalid box lines" )
    TEAGN_TRUE_OR_THROW( 
      ( input_raster2_params.ncols_ == input_raster2_disk->params().ncols_ ),
      "Invalid box lines" )
    
    TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( input_raster2,
      input_raster2_params, false ), "adjust_raster Alloc error" );   
    TEAGN_TRUE_OR_THROW( TePDIUtils::TeCopyRasterBands( input_raster2_disk,
      input_raster2, false, false ), "Pixel copy error" );
  }        
    
  TePDITypes::TePDIRasterPtrType output_raster;
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( output_raster,
    1, 1, 1, false, TeDOUBLE, 0 ), "output_raster Alloc error" );
    
  blend_params.SetParameter( "blending_type" , 
    std::string( "euclidian_blending" ) );
  blend_params.SetParameter( "input_raster1" , input_raster1 );
  blend_params.SetParameter( "input_raster2" , input_raster2 );
  blend_params.SetParameter( "output_raster" , output_raster );
  
  std::vector< int > channels1;
  channels1.push_back( 0 );
  blend_params.SetParameter( "channels1" , channels1 );
  
  std::vector< int > channels2;
  channels2.push_back( 0 );
  blend_params.SetParameter( "channels2" , channels2 );
  
  TeBox input_raster1_box = input_raster1->params().boundingBox();
  TePDITypes::TePDIPolygonPtrType raster1_pol_ptr(
    new TePolygon );
  *raster1_pol_ptr = polygonFromBox( input_raster1_box );
  blend_params.SetParameter( "raster1_pol_ptr" , raster1_pol_ptr );

  TeBox input_raster2_box = input_raster2->params().boundingBox();
  TePDITypes::TePDIPolygonPtrType raster2_pol_ptr(
    new TePolygon );  
  *raster2_pol_ptr = polygonFromBox( input_raster2_box );
  blend_params.SetParameter( "raster2_pol_ptr" , raster2_pol_ptr );
  
  double raster2_pol_offset_x = input_raster1->coord2Index(
    input_raster2_disk->index2Coord( TeCoord2D( 0, 0 ) ) ).x();
  blend_params.SetParameter( "raster2_pol_offset_x" , raster2_pol_offset_x );
  
  double raster2_pol_offset_y = input_raster1->coord2Index(
    input_raster2_disk->index2Coord( TeCoord2D( 0, 0 ) ) ).y();
  blend_params.SetParameter( "raster2_pol_offset_y" , raster2_pol_offset_y );

  blend_params.SetParameter( "auto_equalize" , (int)1 );
  
  blend_params.SetParameter( "dummy_value" , (double)0 );
  
  blend_params.SetParameter( "draw_blend_lines" , (double)255 );
  
  blend_params.SetParameter( "enable_multi_thread" , (int)1 );
    
  TePDIBlending blend_instance;
  TEAGN_TRUE_OR_THROW( blend_instance.Reset(blend_params), "Reset error" );
  TEAGN_TRUE_OR_THROW( blend_instance.Apply(), "Apply error" );
  
  TEAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( output_raster,
    TEPDIEXAMPLESBINPATH "Blending_euclidian_TeWITHIN_test.tif" ), "GeoTIF generation error" );
}


int main()
{
  TEAGN_LOGMSG( "Test started." );

  try{
    TeInitRasterDecoders();
    
    TeStdIOProgress pi;
    TeProgress::setProgressInterf( dynamic_cast< TeProgressBase* >( &pi ) );     

    Noblend_TeOVERPLAPS_RGB_test();
    Noblend_TeWITHIN_test();
    Euclidian_TeOVERPLAPS_test();
    Euclidian_TeWITHIN_test();
  }
  catch( const TeException& excpt ){
    TEAGN_LOGERR( excpt.message() )
    return EXIT_FAILURE;
  }

  TEAGN_LOGMSG( "Test OK." );
  return EXIT_SUCCESS;
}

