/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library p rovided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

#ifndef  __TERRALIB_INTERNAL_STOFUNCTIONS_H
#define  __TERRALIB_INTERNAL_STOFUNCTIONS_H

#include "TeDatabase.h"
#include <vector>
#include <string>

class TeSTElementSet;
class TeSTEventSet;

//! Builds the spatial object set from database according to the restrictions previously defined
/*! 
	\param stoset				the STOSet that will be filled 
	\param loadGeometries		if the STOSet will be filled with the geometries 
	\param loadAllAttributes	if the STOSet will be filled with all attributes of the tables of the STOSet 
	\param attrNames			a subset of the attribute names that will be loaded, if the param loadAllAttributes is false 
*/
bool
TeSTOSetBuildDB(TeSTElementSet* stoset, bool loadGeometries = false, bool loadAllAttributes = false, vector<string> attrNames = vector<string>());


//! Builds the spatial object set from database according to the restrictions previously defined
/*! 
	\param stoset				the STOSet that will be filled 
	\param groupAttr			a map from attribute name to statistic type  
	\param loadGeometries		if the STOSet will be filled with the geometries 
*/
bool
TeSTOSetBuildDB(TeSTElementSet* stoset, TeGroupingAttr& groupAttr, bool loadGeometries = false);


//! Updates the database table from a element set
bool  
TeUpdateDBFromSet (TeSTElementSet* elemSet, const string& tableName, vector<int>* indexes = 0);


//! Updates the database table from a element set
bool  
TeUpdateDBFromSet (TeSTEventSet* elemSet, const string& tableName, vector<int>* indexes = 0);


/** \example STObjectSetExample1.cpp
 *	This is an example of how to create a new Spatial Temporal Object 
	Set (STObjectSet) filled whit attributes from a layer .
 */

 /** \example STObjectSetExample2.cpp
 *	This is an example of how to create a new Spatial Temporal Object 
	Set (STObjectSet) filled whit geometries and attributes from a theme.
 */

 /** \example STObjectSetExample3.cpp
 *	This is an example of how to create a new Spatial Temporal Object 
	Set (STObjectSet) and to use it in spatial algorithms.
 */

#endif

