#ifndef TAGCOLL_EXPRESSION_FILTER_H
#define TAGCOLL_EXPRESSION_FILTER_H

/*
 * TagcollFilter that filters items using a tag expression
 * 
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma interface

#include <tagcoll/TagcollFilter.h>
#include <tagcoll/tagexpr/Tagexpr.h>

#include <string>

namespace Tagcoll
{

class ExpressionFilter : public TagcollFilter<std::string>
{
protected:
	Tagexpr* expr;
	int matched;

	bool match(const OpSet<std::string>& ts) const throw ();
	
public:
	enum MatchType { PLAIN, INVERTED };

protected:
	MatchType matchType;

public:	
	ExpressionFilter() throw () : expr(0), matched(0), matchType(PLAIN) {}
	virtual ~ExpressionFilter() throw () { if (expr) delete expr; }

	// Set the expression to use for this filter
	// Return false if parsing the expression failed
	bool setExpression(const std::string& expression) throw ();

	void setMatchType(MatchType type) throw () { matchType = type; }

	int countMatched() const throw () { return matched; }

	virtual void consume(const std::string& item) throw ()
	{
		if (match(OpSet<std::string>()))
		{
			matched++;
			consumer->consume(item);
		}
	}

	virtual void consume(const std::string& item, const OpSet<std::string>& tags) throw ()
	{
		if (match(tags))
		{
			matched++;
			consumer->consume(item, tags);
		}
	}

	virtual void consume(const OpSet<std::string>& items) throw ()
	{
		if (match(OpSet<std::string>()))
		{
			matched += items.size();
			consumer->consume(items);
		}
	}

	virtual void consume(const OpSet<std::string>& items, const OpSet<std::string>& tags) throw ()
	{
		if (match(tags))
		{
			matched += items.size();
			consumer->consume(items, tags);
		}
	}
};

};

// vim:set ts=4 sw=4:
#endif
