#pragma implementation

#include <tagcoll/BasicTagMatcher.h>

#include <tagcoll/Tag.h>
#include <tagcoll/TagConsumer.h>
#include <tagcoll/TagSet.h>

#include <string.h>	// strcasestr

using namespace std;
using namespace Tagcoll;


bool BasicFacetMatcher::matchName(const std::string& text) const throw ()
{
	if (name.empty())
		return true;
	return strcasestr(text.c_str(), name.c_str());
}
bool BasicFacetMatcher::matchString(const std::string& text) const throw ()
{
	if (str.empty())
		return true;
	return strcasestr(text.c_str(), str.c_str());
}

bool BasicFacetMatcher::match(const Facet& tag) const throw ()
{
	bool got = true;
	if (hasName() && !matchName(tag.name()))
		got = false;
	if (hasString() && !matchString(tag.name()) && !matchString(tag.sdesc()) && !matchString(tag.ldesc()))
		got = false;
	return got;
}


bool BasicTagMatcher::matchName(const std::string& text) const throw ()
{
	if (name.empty())
		return true;
	return strcasestr(text.c_str(), name.c_str());
}
bool BasicTagMatcher::matchString(const std::string& text) const throw ()
{
	if (str.empty())
		return true;
	return strcasestr(text.c_str(), str.c_str());
}

bool BasicTagMatcher::match(const Tag& tag) const throw ()
{
	bool got = true;
	if (hasName() && !matchName(tag.fullname()))
		got = false;
	if (hasString() && !matchString(tag.fullname()) && !matchString(tag.sdesc()) && !matchString(tag.ldesc()))
		got = false;
	return got;
}

// vim:set ts=4 sw=4:
