%{
/*
 * Parser for tag expressions
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include "Tagexpr.h"
#include "TagexprParser.h"

#define YYSTYPE	Tagexpr*
//#define YYDEBUG 1

extern int yylex();

void yyerror(const char* s);

%}

%start Input

%token TAG LPAREN RPAREN

%left AND OR
%left NOT

%%

Input	: Expr					{ TagexprParser::instance()->setResult($1); }

Expr	: TAG					{ $$ = $1; }
		| NOT Expr				{ $$ = new TagexprNot($2); }
		| LPAREN Expr RPAREN	{ $$ = $2; }
		| Expr AND Expr			{ $$ = new TagexprAnd($1, $3); }
		| Expr OR Expr			{ $$ = new TagexprOr($1, $3); }
		;

%%

void yyerror(const char* s)
{
	TagexprParser::instance()->addError(s);
}

/* vim:set syntax=yacc ts=4 sw=4: */
