#ifndef TAGCOLL_PARSER_H
#define TAGCOLL_PARSER_H

/*
 * Parser for a serialized tagged collection
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma interface

#include <string>
#include <Exception.h>
#include <TagcollConsumer.h>
#include <ParserBase.h>

namespace TagcollParser
{

//#define TRACE_PARSE

// Parse a word in a tagged collection; return the delimiting char following the word
// Stores the word it finds in `item'
int parseElement(ParserInput& in, std::string& item) throw (ParserException);

// Parse a tagged collection, sending the data to `consumer'
void parseTagcoll(ParserInput& in, TagcollConsumer<std::string>& consumer) throw (ParserException);

// Parse a tagged collection, sending the data to `consumer'
// Expands implementation from the `impls' input and derived tags from the `dervs' input
void parseTagcoll(ParserInput& in, ParserInput& impls, ParserInput& dervs, TagcollConsumer<std::string>& consumer) throw (ParserException);

};

// vim:set ts=4 sw=4:
#endif
