/* AttributedContext.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.commands;

import java.util.HashMap;
import java.util.Map;

/**
 * Context object for use with {@link org.pietschy.command.CommandManager}. Provides
 * a way to store and retrieve attributes using string keys.<p>
 *
 * <b>Important note:</b> work on this part of the Swirl library will be 
 * discontinued because unfortunately newer versions
 * of the <i>GUI commands</i> framework will no longer be available as <i>open source</i>.
 * In due course this class will become deprecated and will eventually be
 * removed from the library.
 * @see AttributedCommandManager
 */
public class AttributedContext {
    
    //
    private final Map<String,Object> map;
    
    /** Create a context of this type without any keys. */
    public AttributedContext() {
	map = new HashMap <String,Object> ();
    }
    
    /**
     * Retrieve the attribute with the given key. A null key is not allowed.
     * @return Attribute with the given key or {@code null} if no such attribute
     * exists in this context.
     */
    public Object getAttribute (String key) {
	assert key != null;
	return map.get (key);
    }
    
    /**
     * Stores an attribute with the given key. If an attribute with that key
     * already exists in this context, the old value is replaced
     * by the value given. Setting an attribute value to {@code null} 
     * removes the attribute.
     */
    public void setAttribute (String key, Object value) {
	assert key != null;
	if (value == null)
	    map.remove (key);
	else {
	    map.put (key, value);
	}
    }
}
