# vim:noet:ai:ts=8:sw=8:filetype=make:

# push dir ... 
# If anything in this makefile needs to use the directory name, use the 
# $(d) variable. It will be properly set and reset, even in submake files.
# Any variable that uses the $(d) variable must be an IMMEDIATE variable, 
# ie. it must be "variable :=  $(d)/file", note the ":=".

# only works for make version >= 3.80
#dir := $(dir $(word $(words $(MAKEFILE_LIST)),$(MAKEFILE_LIST)))
sp 				:= $(sp).x
dirstack_$(sp)	:= $(d)
d				:= $(dir)

DO_SO:=$(d)/DO_SO

#
smbios_LIBS := 
smbios_MAJOR := $(shell echo $$(( $(RELEASE_MAJOR) + 1 )))
smbios_MINOR := $(RELEASE_MINOR)
smbiosxml_LIBS := 
smbiosxml_MAJOR := $(shell echo $$(( $(RELEASE_MAJOR) + 1 )))
smbiosxml_MINOR := $(RELEASE_MINOR)

# order of these includes is important. 
# make sure that libs that depend on others are after the libs they depend on
dir := $(d)/cmos
include $(dir)/module.mk

dir := $(d)/smbios
include $(dir)/module.mk

dir := $(d)/token
include $(dir)/module.mk

dir := $(d)/memory
include $(dir)/module.mk

dir := $(d)/systeminfo
include $(dir)/module.mk

dir := $(d)/smi
include $(dir)/module.mk

dir := $(d)/rbu
include $(dir)/module.mk

dir := $(d)/bmc
-include $(dir)/module.mk

dir := $(d)/common
include $(dir)/module.mk

ifeq ($(XMLLIB),libxerces)
dir := $(d)/xml_libxerces
else
dir := $(d)/xml_libxml2
endif
include $(dir)/module.mk


# set up dependencies and whatnot
libname := smbios
libclass := BASE
include $(DO_SO)
lib/$(call libname_SONAME,$(libname)): lib/$(call libname_SOVER,$(libname))
lib/$(call libname_SO,$(libname)): lib/$(call libname_SOVER,$(libname))
lib/$(call libname_SOVER,$(libname)): $($(libname)_LIBS:%.o=%.lo)
	$(call build_dyn_lib,smbios)

$($(libname)_STATIC):  $($(libname)_LIBS)
	$(call build_static_lib,smbios)

$($(libname)_STATIC_DEBUG): $($(libname)_LIBS:%.o=%.do)
	$(call build_static_debug_lib,smbios)


libname := smbiosxml
libclass := EXT
include $(DO_SO)
lib/$(call libname_SONAME,$(libname)): lib/$(call libname_SOVER,$(libname))
lib/$(call libname_SO,$(libname)): lib/$(call libname_SOVER,$(libname))
lib/$(call libname_SOVER,$(libname)): $($(libname)_LIBS:%.o=%.lo)
	$(call build_dyn_lib,smbiosxml)

$($(libname)_STATIC):  $($(libname)_LIBS)
	$(call build_static_lib,smbiosxml)

$($(libname)_STATIC_DEBUG): $($(libname)_LIBS:%.o=%.do)
	$(call build_static_debug_lib,smbiosxml)

#special dependencies because we have a generated .h file here
$($(libname)_DYN_FILENAMES):  $(STD_SMBIOS_XML)
$($(libname)_STATIC):  	      $(STD_SMBIOS_XML)
$($(libname)_STATIC_DEBUG):   $(STD_SMBIOS_XML)


# Pop dir stack back to what it was
d		:= $(dirstack_$(sp))
sp		:= $(basename $(sp))
