// vim:expandtab:autoindent:tabstop=4:shiftwidth=4:filetype=c:cindent:
/*
 * Copyright (C) 2005 Dell Inc.
 *  by Michael Brown <Michael_E_Brown@dell.com>
 * Licensed under the Open Software License version 2.1
 *
 * Alternatively, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 */


#ifndef SMBIOSXMLIMPL_XERCES_h
#define SMBIOSXMLIMPL_XERCES_h

// compat header should always be first header
#include "smbios/compat.h"

#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/dom/DOMImplementation.hpp>
#include <xercesc/dom/DOMImplementationLS.hpp>

#include "smbios/ISmbiosXml.h"
#include "../smbios/SmbiosImpl.h"

namespace smbios
{
    class SmbiosItemXml : public SmbiosItem
    {
    public:
        SmbiosItemXml (const SmbiosItem & source)
                : SmbiosItem(source), doc(0)
        {}
        ;
        explicit SmbiosItemXml (const smbiosLowlevel::smbios_structure_header *header = 0)
                : SmbiosItem(header), doc(0)
        {}
        ;
        virtual std::ostream & streamify( std::ostream & cout ) const;

        void setXmlFilePath( const std::string newFile, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *newDoc );

        // TODO: listFields
        using  SmbiosItem::getU8;
        using  SmbiosItem::getU16;
        using  SmbiosItem::getU32;
        using  SmbiosItem::getU64;
        using  SmbiosItem::getString;
        using  SmbiosItem::getBitfield;
        virtual u8 getU8( const std::string field ) const;
        virtual u16 getU16( const std::string field ) const;
        virtual u32 getU32( const std::string field ) const;
        virtual u64 getU64( const std::string field ) const;
        virtual u32 getBitfield( const std::string field, const std::string bitField) const;
        virtual const char* getString( const std::string field ) const;

    protected:
        std::string getTypeAsString() const;
        std::string xmlFile;
        XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *doc;
    };

    class SmbiosTableXml : public virtual SmbiosTable
    {
    public:
        // ITERATORS!
        using  SmbiosTable::operator[];
        virtual iterator operator[]( const std::string & );
        virtual const_iterator operator[]( const std::string & ) const;

        virtual std::ostream & streamify(std::ostream & cout ) const;

        // CONSTRUCTORS/DESTRUCTORS
        virtual ~SmbiosTableXml();
        explicit SmbiosTableXml(std::vector<SmbiosStrategy *> initStrategyList, bool strictValidation = 0);

        void setXmlFilePath( std::string );
        int getTypeForString( const std::string )const;
        const std::string getStringForType( const int )const;

        const XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *getXmlDoc() const;

    protected:
        // Private, should never construct empty object.
        SmbiosTableXml ();

        virtual ISmbiosItem &makeItem( const void *header = 0) const;

    protected:
        std::string xmlFile;

        // parser owns all XML entities. When it is deleted, everything
        // goes with it.
        XERCES_CPP_NAMESPACE_QUALIFIER DOMBuilder *parser;

        // The doc is owned by the parser. We do not have to clean it up
        // it is deleted when the parser is released. We keep a ref
        // here for speed purposes
        XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *doc;

        // indicates if XML subsystem has been initialized and should be
        // terminated.
        bool xmlInitialized;

    private:
        SmbiosTableXml (const SmbiosTableXml & source);
        SmbiosTableXml & operator = (const SmbiosTableXml & source);
    };
}

#endif /* SMBIOSXMLIMPL_XERCES_h */

