# vim:noet:ai:ts=8:sw=8:filetype=make:

# push dir ... 
# If anything in this makefile needs to use the directory name, use the 
# $(d) variable. It will be properly set and reset, even in submake files.
# Any variable that uses the $(d) variable must be an IMMEDIATE variable, 
# ie. it must be "variable :=  $(d)/file", note the ":=".

# only works for make version >= 3.80
#dir := $(dir $(word $(words $(MAKEFILE_LIST)),$(MAKEFILE_LIST)))
sp 				:= $(sp).x
dirstack_$(sp)	:= $(d)
d				:= $(dir)

  rbu_rpm_build_dir := $(shell cd $(d); pwd)/rburpm
  dcdbas_rpm_build_dir := $(shell cd $(d); pwd)/dcdrpm
  kernel_dir := $(d)

  dell_rbu_RPM := dell_rbu-0.7-2dkms.noarch.rpm
  dcdbas_RPM := dcdbas-5.6.0-2dkms.noarch.rpm

  RPMS += $(dell_rbu_RPM) $(dcdbas_RPM)

  $(dell_rbu_RPM): $(d)/linux/dell_rbu/2.6.12_and_earlier/dell_rbu.c $(d)/linux/dell_rbu/2.6.12_and_earlier/dkms.conf $(d)/linux/dell_rbu/2.6.12_and_earlier/dell_rbu_spec
	[ ! -e $(rbu_rpm_build_dir) ] || rm -rf $(rbu_rpm_build_dir)
	mkdir -p $(rbu_rpm_build_dir)
	cd $(rbu_rpm_build_dir); mkdir -p SOURCES BUILD RPMS RPMS/i386 RPMS/noarch SRPMS SPECS
	cp $(kernel_dir)/linux/dell_rbu/2.6.12_and_earlier/dell_rbu.c    $(rbu_rpm_build_dir)/SOURCES
	cp $(kernel_dir)/linux/dell_rbu/2.6.12_and_earlier/dkms.conf     $(rbu_rpm_build_dir)/SOURCES
	cp $(kernel_dir)/linux/dell_rbu/2.6.12_and_earlier/Makefile      $(rbu_rpm_build_dir)/SOURCES
	cp $(kernel_dir)/linux/dell_rbu/2.6.12_and_earlier/dell_rbu_spec $(rbu_rpm_build_dir)/SPECS
	rpmbuild --define "_topdir $(rbu_rpm_build_dir)" -ba $(rbu_rpm_build_dir)/SPECS/dell_rbu_spec 
	-mv $(rbu_rpm_build_dir)/RPMS/*/*rpm .
	-mv $(rbu_rpm_build_dir)/SRPMS/*rpm .
	rm -rf $(rbu_rpm_build_dir)

  $(dcdbas_RPM): $(d)/linux/dcdbas/2.6.12_and_earlier/dcdbas.c $(d)/linux/dcdbas/2.6.12_and_earlier/dcdbas.h $(d)/linux/dcdbas/2.6.12_and_earlier/dkms.conf $(d)/linux/dcdbas/2.6.12_and_earlier/dcdbas_spec
	[ ! -e $(dcdbas_rpm_build_dir) ] || rm -rf $(dcdbas_rpm_build_dir)
	mkdir -p $(dcdbas_rpm_build_dir)
	cd $(dcdbas_rpm_build_dir); mkdir -p SOURCES BUILD RPMS RPMS/i386 RPMS/noarch SRPMS SPECS
	cp $(kernel_dir)/linux/dcdbas/2.6.12_and_earlier/dcdbas.c    $(dcdbas_rpm_build_dir)/SOURCES
	cp $(kernel_dir)/linux/dcdbas/2.6.12_and_earlier/dcdbas.h    $(dcdbas_rpm_build_dir)/SOURCES
	cp $(kernel_dir)/linux/dcdbas/2.6.12_and_earlier/dkms.conf   $(dcdbas_rpm_build_dir)/SOURCES
	cp $(kernel_dir)/linux/dcdbas/2.6.12_and_earlier/Makefile    $(dcdbas_rpm_build_dir)/SOURCES
	cp $(kernel_dir)/linux/dcdbas/2.6.12_and_earlier/dcdbas_spec $(dcdbas_rpm_build_dir)/SPECS
	rpmbuild --define "_topdir $(dcdbas_rpm_build_dir)" -ba $(dcdbas_rpm_build_dir)/SPECS/dcdbas_spec 
	-mv $(dcdbas_rpm_build_dir)/RPMS/*/*rpm .
	-mv $(dcdbas_rpm_build_dir)/SRPMS/*rpm .
	rm -rf $(dcdbas_rpm_build_dir)

  CLEAN_LIST += dcdbas*.rpm dell_rbu*.rpm
  CLEAN_LIST += $(rbu_rpm_build_dir) $(dcdbas_rpm_build_dir)

# Pop dir stack back to what it was
d		:= $(dirstack_$(sp))
sp		:= $(basename $(sp))
