// vim:expandtab:autoindent:tabstop=4:shiftwidth=4:filetype=c:
/*
 * Copyright (C) 2005 Dell Inc.
 *  by Michael Brown <Michael_E_Brown@dell.com>
 * Licensed under the Open Software License version 2.1 
 * 
 * Alternatively, you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, 
 * or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details.
 */


#ifndef _OUTPUTCTL_H
#define _OUTPUTCTL_H

#include "smbios/compat.h"

#include <exception>
#include <typeinfo>     // for typeid()

// A collection of macros to use in the unit tests.
// They print things out in a standard format, or shorten unit tests.

class skip_test : public std::exception
    {}
;


#ifdef LIBSMBIOS_HAS_PRETTY_FUNCTION
#define WHEREAMI "\t%s... ", __PRETTY_FUNCTION__
#else
#define WHEREAMI "%s (line %d)... ", typeid(*this).name(), __LINE__ 
#endif 

#define startTest(arg1, arg2) do{ printf(arg1, arg2); printf(WHEREAMI) ;}while(0)
#define passTest() do {printf( "[ ok ]\n" ); } while(0)
#define failTest() do {printf( "[FAIL]\n" ); } while(0)
#define skipTest() do {printf( "[SKIP]\n" ); } while(0)

// standard stuff

// Standard test start/end header
#ifdef LIBSMBIOS_HAS_PRETTY_FUNCTION
#define STD_TEST_START(arg1, arg2) startTest(arg1, arg2);  bool skip=false; cout << flush; try { checkSkipTest(__FUNCTION__)
#else
#define STD_TEST_START(arg1, arg2) startTest(arg1, arg2);  bool skip=false; cout << flush; try {
#endif

#define STD_TEST_END()                              \
        } catch (const skip_test &) {               \
                skip = true;                        \
        } catch ( const smbios::IException &e ) {   \
                failTest();                         \
                CPPUNIT_FAIL( e.what() );           \
        } catch ( const std::exception &e ) {   \
                failTest();                         \
                CPPUNIT_FAIL( e.what() );           \
        } catch (...) {         \
                failTest();     \
                throw;          \
        }                       \
        if( skip )              \
            skipTest();         \
        else                    \
            passTest();

// extra macros that make CPPUNIT tests shorter.
#define ASSERT_THROWS( expr, exc )  \
    do {                        \
    bool caught = false;        \
    try                         \
    {                           \
        expr;                   \
    }                           \
    catch( const exc & )        \
    {                           \
            caught = true;      \
    }                           \
    catch( const std::exception &e ) \
    {                           \
        ostringstream ost;      \
        ost << "Executed: " #expr "\nCaught wrong exception. Expected: " #exc;    \
        ost << "\nLine: " << __LINE__;   \
        ost << "\nFile: " << __FILE__;   \
        ost << "\nException Caught: " << typeid(e).name();        \
        CPPUNIT_FAIL (ost.str().c_str());   \
    }                           \
    catch( ... )                \
    {                           \
        ostringstream ost;      \
        ost << "Executed: " #expr "\nCaught wrong exception. Expected: " #exc;    \
        ost << "\nLine: " << __LINE__;   \
        ost << "\nFile: " << __FILE__;   \
        CPPUNIT_FAIL (ost.str().c_str());   \
    }                           \
    if ( ! caught )             \
        CPPUNIT_FAIL ("Executed: " #expr "\nShould have thrown an exception, but did not. Expected: " #exc);\
    } while(0)



#endif  /* ! defined _OUTPUTCTL_H */
