/*  
  Copyright 2002-2003, Andreas Rottmann
*/
#include <unistd.h>

#include <string>
#include <iostream>
#include <stdexcept>

#include <sigc++/slot.h>
#include <sigc++/object_slot.h>
#include <sigcx/thread.h>
#include <sigcx/thread_tunnel.h>

using namespace std;
using namespace SigC;
using namespace SigCX;
using namespace SigCX::Threads;

Semaphore done(0);

static int result = 1;

class Receiver : public StandardDispatcher
{
  public:
    // override default run method
    virtual bool run(bool infinite = true);
    void receive(const string& msg) {
      cout << "received: " << msg << endl;
      usleep(200 * 1000);
      result += msg.size();
    }
    bool receive_bool(const string& msg) {
      cout << "received (synchronous): " << msg << endl;
      result += msg.size() * 2;
      return true;
    }
};

class Sender : public Object
{
  private:
    Receiver& receiver_;
    Tunnel& tunnel_;
  public:
    Sender(Receiver& receiver, Tunnel& tunnel) 
        : receiver_(receiver), tunnel_(tunnel) { 
    }
    void main();
};

int main()
{
  Receiver receiver;
  ThreadTunnel tunnel(receiver);
  Sender sender(receiver, tunnel);
  
  Thread sender_thread(slot(sender, &Sender::main));

  done.down();
  return result != 19;
}

bool Receiver::run(bool)
{
  while (true)
  {
    try
    {
      StandardDispatcher::run();
      break;
    }
    catch (std::exception& e)
    {
      cout << "caught exception: " << e.what() << endl;
      result += string(e.what()).size() * 3;
    }
  }
  done.up();
  return false;
}

void raise_exception(const string& msg)
{
  throw std::runtime_error(msg);
}

void Sender::main()
{
  const int N = 12;
  string msg;
  for (int i = 0; i < N; i++)
  {
    msg = (char)('A' + i);
    cout << "sending message: " << msg << " ";
    if ((i + 1) % 7 == 0)
    {
      cout << "as exception!" << endl;
      tunnel<void, const string&>(slot(&raise_exception), msg, &tunnel_);
    }
    else if ((i + 1) % 3 == 0)
    {
      cout << "synchronous!" << endl;
      cout << "response: " <<
        tunnel<bool, const string&>(
                slot(receiver_, &Receiver::receive_bool), msg, &tunnel_, true)
           << endl;
    }
    else
    {
      cout << "asynchronous" << endl;
      tunnel<void, const string&>(slot(receiver_, &Receiver::receive), msg, &tunnel_);
    }
  }
  cout << "sending exit message" << endl;
  tunnel(slot(dynamic_cast<Dispatcher&>(receiver_), 
              &Dispatcher::exit), &tunnel_);
}
