#!/usr/local/bin/perl
#
# $DUH: client.pl,v 1.3 2002/12/16 22:45:09 tv Exp $
#
# Copyright (c) 2002 Todd Vierling <tv@pobox.com> <tv@duh.org>.
# All rights reserved.
# Please see the COPYRIGHT file, part of the PMilter distribution,
# for full copyright and license terms.

use strict;
use warnings;

use Data::Dumper;
use IO::Socket::INET;

# Basic SMTP client for doing debug testing.

my $socket = IO::Socket::INET->new(PeerAddr => (shift @ARGV || 'localhost').':25') || die $!;
$socket->autoflush(1);

sub getresponse {
	my $resp;

	do {
		$resp = <$socket>;
		print $resp;
	} until ($resp !~ /^...-/);

	$resp !~ /^[45]/;
}

sub sendcommand {
	my $cmd = join(' ', @_);

	print $cmd."\n";
	$socket->print($cmd."\r\n");

	getresponse;
}

getresponse;
sendcommand('HELO my.duh.org') || exit;
sendcommand('MAIL FROM:<tv@duh.org>') || exit;

sendcommand('RSET') || exit;
sendcommand('MAIL FROM:<tv@duh.org>') || exit;

sendcommand('RCPT TO:<tv@duh.org>');
sendcommand('RCPT TO:<pmiltertest@duh.org>');
sendcommand('DATA') || exit;

my $subject = 'Subject: PMilter test message '.(time);
my $body = <<EOF ;
From: tv\@duh.org
To: tv\@duh.org
$subject

This is a test.
.
EOF
$body =~ s/\n/\r\n/g;

print $subject."\n";
$socket->print($body);
getresponse || exit;

sendcommand('MAIL FROM:<tv@duh.org>') || exit;
sendcommand('RCPT TO:<tv@duh.org>');
sendcommand('RSET') || exit;
sendcommand('QUIT');
