/*
 * @file    TestL3ModelHistory.java
 * @brief   test for ModelHistory on any SBase object
 *
 * @author  Akiya Jouraku (Java conversion)
 * @author  Sarah Keating 
 * 
 * ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
 *
 * DO NOT EDIT THIS FILE.
 *
 * This file was generated automatically by converting the file located at
 * src/sbml/test/TestL3ModelHistory.cpp
 * using the conversion program dev/utilities/translateTests/translateTests.pl.
 * Any changes made here will be lost the next time the file is regenerated.
 *
 * -----------------------------------------------------------------------------
 * This file is part of libSBML.  Please visit http://sbml.org for more
 * information about SBML, and the latest version of libSBML.
 *
 * Copyright 2005-2010 California Institute of Technology.
 * Copyright 2002-2005 California Institute of Technology and
 *                     Japan Science and Technology Corporation.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.  A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as http://sbml.org/software/libsbml/license.html
 * -----------------------------------------------------------------------------
 */

package org.sbml.libsbml.test.annotation;

import org.sbml.libsbml.*;

import java.io.File;
import java.lang.AssertionError;

public class TestL3ModelHistory {

  static void assertTrue(boolean condition) throws AssertionError
  {
    if (condition == true)
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertEquals(Object a, Object b) throws AssertionError
  {
    if ( (a == null) && (b == null) )
    {
      return;
    }
    else if ( (a == null) || (b == null) )
    {
      throw new AssertionError();
    }
    else if (a.equals(b))
    {
      return;
    }

    throw new AssertionError();
  }

  static void assertNotEquals(Object a, Object b) throws AssertionError
  {
    if ( (a == null) && (b == null) )
    {
      throw new AssertionError();
    }
    else if ( (a == null) || (b == null) )
    {
      return;
    }
    else if (a.equals(b))
    {
      throw new AssertionError();
    }
  }

  static void assertEquals(boolean a, boolean b) throws AssertionError
  {
    if ( a == b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertNotEquals(boolean a, boolean b) throws AssertionError
  {
    if ( a != b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertEquals(int a, int b) throws AssertionError
  {
    if ( a == b )
    {
      return;
    }
    throw new AssertionError();
  }

  static void assertNotEquals(int a, int b) throws AssertionError
  {
    if ( a != b )
    {
      return;
    }
    throw new AssertionError();
  }
  private SBMLDocument d;
  private Compartment c;
  private Model m;


  public boolean equals(String s1, String s2)
  {
    return s1.equals(s2);
  }

  protected void setUp() throws Exception
  {
    String filename = "../../sbml/annotation/test/test-data/annotationL3.xml";
    d = libsbml.readSBML(filename);
    m = d.getModel();
    c = m.getCompartment(0);
  }

  protected void tearDown() throws Exception
  {
  }

  public void test_L3ModelHistory_delete()
  {
    XMLNode node = RDFAnnotationParser.parseModelHistory(c);
    XMLNode n1 = RDFAnnotationParser.deleteRDFAnnotation(node);
    String expected =  "<annotation/>";
    assertTrue( n1.getNumChildren() == 0 );
    assertTrue( n1.getName().equals( "annotation") );
    assertEquals( true, equals(expected,n1.toXMLString()) );
    node = null;
  }

  public void test_L3ModelHistory_deleteWithOther()
  {
    Compartment c = m.getCompartment(1);
    XMLNode node = RDFAnnotationParser.deleteRDFAnnotation(c.getAnnotation());
    String expected = "<annotation>\n" + "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "</annotation>";
    assertEquals( true, equals(expected,node.toXMLString()) );
  }

  public void test_L3ModelHistory_deleteWithOutOther()
  {
    Compartment c = m.getCompartment(2);
    XMLNode node = c.getAnnotation();
    String expected = "<annotation>\n" + "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "</annotation>";
    assertEquals( true, equals(expected,node.toXMLString()) );
  }

  public void test_L3ModelHistory_delete_Model()
  {
    XMLNode node = RDFAnnotationParser.parseModelHistory(m);
    XMLNode n1 = RDFAnnotationParser.deleteRDFAnnotation(node);
    String expected =  "<annotation/>";
    assertTrue( n1.getNumChildren() == 0 );
    assertTrue( n1.getName().equals( "annotation") );
    assertEquals( true, equals(expected,n1.toXMLString()) );
    node = null;
  }

  public void test_L3ModelHistory_getModelHistory()
  {
    assertTrue( ! (c == null) );
    ModelHistory history = c.getModelHistory();
    assertTrue( history != null );
    ModelCreator mc = history.getCreator(0);
    assertTrue(mc.getFamilyName().equals( "Le Novere"));
    assertTrue(mc.getGivenName().equals( "Nicolas"));
    assertTrue(mc.getEmail().equals( "lenov@ebi.ac.uk"));
    assertTrue(mc.getOrganisation().equals( "EMBL-EBI"));
    Date date = history.getCreatedDate();
    assertTrue( date.getYear() == 2005 );
    assertTrue( date.getMonth() == 2 );
    assertTrue( date.getDay() == 2 );
    assertTrue( date.getHour() == 14 );
    assertTrue( date.getMinute() == 56 );
    assertTrue( date.getSecond() == 11 );
    assertTrue( date.getSignOffset() == 0 );
    assertTrue( date.getHoursOffset() == 0 );
    assertTrue( date.getMinutesOffset() == 0 );
    assertTrue(date.getDateAsString().equals( "2005-02-02T14:56:11Z"));
    date = history.getModifiedDate();
    assertTrue( date.getYear() == 2006 );
    assertTrue( date.getMonth() == 5 );
    assertTrue( date.getDay() == 30 );
    assertTrue( date.getHour() == 10 );
    assertTrue( date.getMinute() == 46 );
    assertTrue( date.getSecond() == 2 );
    assertTrue( date.getSignOffset() == 0 );
    assertTrue( date.getHoursOffset() == 0 );
    assertTrue( date.getMinutesOffset() == 0 );
    assertTrue(date.getDateAsString().equals( "2006-05-30T10:46:02Z"));
  }

  public void test_L3ModelHistory_getModelHistory_Model()
  {
    assertTrue( ! (m == null) );
    ModelHistory history = m.getModelHistory();
    assertTrue( history != null );
    ModelCreator mc = history.getCreator(0);
    assertTrue(mc.getFamilyName().equals( "Le Novere"));
    assertTrue(mc.getGivenName().equals( "Nicolas"));
    assertTrue(mc.getEmail().equals( "lenov@ebi.ac.uk"));
    assertTrue(mc.getOrganisation().equals( "EMBL-EBI"));
    Date date = history.getCreatedDate();
    assertTrue( date.getYear() == 2005 );
    assertTrue( date.getMonth() == 2 );
    assertTrue( date.getDay() == 2 );
    assertTrue( date.getHour() == 14 );
    assertTrue( date.getMinute() == 56 );
    assertTrue( date.getSecond() == 11 );
    assertTrue( date.getSignOffset() == 0 );
    assertTrue( date.getHoursOffset() == 0 );
    assertTrue( date.getMinutesOffset() == 0 );
    assertTrue(date.getDateAsString().equals( "2005-02-02T14:56:11Z"));
    date = history.getModifiedDate();
    assertTrue( date.getYear() == 2006 );
    assertTrue( date.getMonth() == 5 );
    assertTrue( date.getDay() == 30 );
    assertTrue( date.getHour() == 10 );
    assertTrue( date.getMinute() == 46 );
    assertTrue( date.getSecond() == 2 );
    assertTrue( date.getSignOffset() == 0 );
    assertTrue( date.getHoursOffset() == 0 );
    assertTrue( date.getMinutesOffset() == 0 );
    assertTrue(date.getDateAsString().equals( "2006-05-30T10:46:02Z"));
  }

  public void test_L3ModelHistory_parseModelHistory()
  {
    XMLNode node = RDFAnnotationParser.parseModelHistory(c);
    assertTrue( node.getNumChildren() == 1 );
    XMLNode rdf = node.getChild(0);
    assertTrue(rdf.getName().equals( "RDF"));
    assertTrue(rdf.getPrefix().equals( "rdf"));
    assertTrue(rdf.getURI().equals( "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
    assertTrue( rdf.getNumChildren() == 1 );
    XMLNode desc = rdf.getChild(0);
    assertTrue(desc.getName().equals( "Description"));
    assertTrue(desc.getPrefix().equals( "rdf"));
    assertTrue(desc.getURI().equals( "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
    assertTrue( desc.getNumChildren() == 4 );
    XMLNode creator = desc.getChild(0);
    assertTrue(creator.getName().equals( "creator"));
    assertTrue(creator.getPrefix().equals( "dc"));
    assertTrue(creator.getURI().equals( "http://purl.org/dc/elements/1.1/"));
    assertTrue( creator.getNumChildren() == 1 );
    XMLNode Bag = creator.getChild(0);
    assertTrue(Bag.getName().equals( "Bag"));
    assertTrue(Bag.getPrefix().equals( "rdf"));
    assertTrue(Bag.getURI().equals( "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
    assertTrue( Bag.getNumChildren() == 1 );
    XMLNode li = Bag.getChild(0);
    assertTrue(li.getName().equals( "li"));
    assertTrue(li.getPrefix().equals( "rdf"));
    assertTrue(li.getURI().equals( "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
    assertTrue( li.getNumChildren() == 3 );
    XMLNode N = li.getChild(0);
    assertTrue(N.getName().equals( "N"));
    assertTrue(N.getPrefix().equals( "vCard"));
    assertTrue(N.getURI().equals( "http://www.w3.org/2001/vcard-rdf/3.0#"));
    assertTrue( N.getNumChildren() == 2 );
    XMLNode Family = N.getChild(0);
    assertTrue(Family.getName().equals( "Family"));
    assertTrue(Family.getPrefix().equals( "vCard"));
    assertTrue(Family.getURI().equals( "http://www.w3.org/2001/vcard-rdf/3.0#"));
    assertTrue( Family.getNumChildren() == 1 );
    XMLNode Given = N.getChild(1);
    assertTrue(Given.getName().equals( "Given"));
    assertTrue(Given.getPrefix().equals( "vCard"));
    assertTrue(Given.getURI().equals( "http://www.w3.org/2001/vcard-rdf/3.0#"));
    assertTrue( Given.getNumChildren() == 1 );
    XMLNode EMAIL = li.getChild(1);
    assertTrue(EMAIL.getName().equals( "EMAIL"));
    assertTrue(EMAIL.getPrefix().equals( "vCard"));
    assertTrue(EMAIL.getURI().equals( "http://www.w3.org/2001/vcard-rdf/3.0#"));
    assertTrue( EMAIL.getNumChildren() == 1 );
    XMLNode ORG = li.getChild(2);
    assertTrue(ORG.getName().equals( "ORG"));
    assertTrue(ORG.getPrefix().equals( "vCard"));
    assertTrue(ORG.getURI().equals( "http://www.w3.org/2001/vcard-rdf/3.0#"));
    assertTrue( ORG.getNumChildren() == 1 );
    XMLNode Orgname = ORG.getChild(0);
    assertTrue(Orgname.getName().equals( "Orgname"));
    assertTrue(Orgname.getPrefix().equals( "vCard"));
    assertTrue(Orgname.getURI().equals( "http://www.w3.org/2001/vcard-rdf/3.0#"));
    assertTrue( Orgname.getNumChildren() == 1 );
    XMLNode created = desc.getChild(1);
    assertTrue(created.getName().equals( "created"));
    assertTrue(created.getPrefix().equals( "dcterms"));
    assertTrue(created.getURI().equals( "http://purl.org/dc/terms/"));
    assertTrue( created.getNumChildren() == 1 );
    XMLNode cr_date = created.getChild(0);
    assertTrue(cr_date.getName().equals( "W3CDTF"));
    assertTrue(cr_date.getPrefix().equals( "dcterms"));
    assertTrue(cr_date.getURI().equals( "http://purl.org/dc/terms/"));
    assertTrue( cr_date.getNumChildren() == 1 );
    XMLNode modified = desc.getChild(2);
    assertTrue(modified.getName().equals( "modified"));
    assertTrue(modified.getPrefix().equals( "dcterms"));
    assertTrue(modified.getURI().equals( "http://purl.org/dc/terms/"));
    assertTrue( modified.getNumChildren() == 1 );
    XMLNode mo_date = created.getChild(0);
    assertTrue(mo_date.getName().equals( "W3CDTF"));
    assertTrue(mo_date.getPrefix().equals( "dcterms"));
    assertTrue(mo_date.getURI().equals( "http://purl.org/dc/terms/"));
    assertTrue( mo_date.getNumChildren() == 1 );
    node = null;
  }

  public void test_L3ModelHistory_parseModelHistory_Model()
  {
    XMLNode node = RDFAnnotationParser.parseModelHistory(m);
    assertTrue( node.getNumChildren() == 1 );
    XMLNode rdf = node.getChild(0);
    assertTrue(rdf.getName().equals( "RDF"));
    assertTrue(rdf.getPrefix().equals( "rdf"));
    assertTrue(rdf.getURI().equals( "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
    assertTrue( rdf.getNumChildren() == 1 );
    XMLNode desc = rdf.getChild(0);
    assertTrue(desc.getName().equals( "Description"));
    assertTrue(desc.getPrefix().equals( "rdf"));
    assertTrue(desc.getURI().equals( "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
    assertTrue( desc.getNumChildren() == 3 );
    XMLNode creator = desc.getChild(0);
    assertTrue(creator.getName().equals( "creator"));
    assertTrue(creator.getPrefix().equals( "dc"));
    assertTrue(creator.getURI().equals( "http://purl.org/dc/elements/1.1/"));
    assertTrue( creator.getNumChildren() == 1 );
    XMLNode Bag = creator.getChild(0);
    assertTrue(Bag.getName().equals( "Bag"));
    assertTrue(Bag.getPrefix().equals( "rdf"));
    assertTrue(Bag.getURI().equals( "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
    assertTrue( Bag.getNumChildren() == 1 );
    XMLNode li = Bag.getChild(0);
    assertTrue(li.getName().equals( "li"));
    assertTrue(li.getPrefix().equals( "rdf"));
    assertTrue(li.getURI().equals( "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
    assertTrue( li.getNumChildren() == 3 );
    XMLNode N = li.getChild(0);
    assertTrue(N.getName().equals( "N"));
    assertTrue(N.getPrefix().equals( "vCard"));
    assertTrue(N.getURI().equals( "http://www.w3.org/2001/vcard-rdf/3.0#"));
    assertTrue( N.getNumChildren() == 2 );
    XMLNode Family = N.getChild(0);
    assertTrue(Family.getName().equals( "Family"));
    assertTrue(Family.getPrefix().equals( "vCard"));
    assertTrue(Family.getURI().equals( "http://www.w3.org/2001/vcard-rdf/3.0#"));
    assertTrue( Family.getNumChildren() == 1 );
    XMLNode Given = N.getChild(1);
    assertTrue(Given.getName().equals( "Given"));
    assertTrue(Given.getPrefix().equals( "vCard"));
    assertTrue(Given.getURI().equals( "http://www.w3.org/2001/vcard-rdf/3.0#"));
    assertTrue( Given.getNumChildren() == 1 );
    XMLNode EMAIL = li.getChild(1);
    assertTrue(EMAIL.getName().equals( "EMAIL"));
    assertTrue(EMAIL.getPrefix().equals( "vCard"));
    assertTrue(EMAIL.getURI().equals( "http://www.w3.org/2001/vcard-rdf/3.0#"));
    assertTrue( EMAIL.getNumChildren() == 1 );
    XMLNode ORG = li.getChild(2);
    assertTrue(ORG.getName().equals( "ORG"));
    assertTrue(ORG.getPrefix().equals( "vCard"));
    assertTrue(ORG.getURI().equals( "http://www.w3.org/2001/vcard-rdf/3.0#"));
    assertTrue( ORG.getNumChildren() == 1 );
    XMLNode Orgname = ORG.getChild(0);
    assertTrue(Orgname.getName().equals( "Orgname"));
    assertTrue(Orgname.getPrefix().equals( "vCard"));
    assertTrue(Orgname.getURI().equals( "http://www.w3.org/2001/vcard-rdf/3.0#"));
    assertTrue( Orgname.getNumChildren() == 1 );
    XMLNode created = desc.getChild(1);
    assertTrue(created.getName().equals( "created"));
    assertTrue(created.getPrefix().equals( "dcterms"));
    assertTrue(created.getURI().equals( "http://purl.org/dc/terms/"));
    assertTrue( created.getNumChildren() == 1 );
    XMLNode cr_date = created.getChild(0);
    assertTrue(cr_date.getName().equals( "W3CDTF"));
    assertTrue(cr_date.getPrefix().equals( "dcterms"));
    assertTrue(cr_date.getURI().equals( "http://purl.org/dc/terms/"));
    assertTrue( cr_date.getNumChildren() == 1 );
    XMLNode modified = desc.getChild(2);
    assertTrue(modified.getName().equals( "modified"));
    assertTrue(modified.getPrefix().equals( "dcterms"));
    assertTrue(modified.getURI().equals( "http://purl.org/dc/terms/"));
    assertTrue( modified.getNumChildren() == 1 );
    XMLNode mo_date = created.getChild(0);
    assertTrue(mo_date.getName().equals( "W3CDTF"));
    assertTrue(mo_date.getPrefix().equals( "dcterms"));
    assertTrue(mo_date.getURI().equals( "http://purl.org/dc/terms/"));
    assertTrue( mo_date.getNumChildren() == 1 );
    node = null;
  }

  public void test_L3ModelHistory_recreate()
  {
    Compartment c = m.getCompartment(1);
    String expected = "<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "      <jd2:header>\n" + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "      </jd2:header>\n" + 
    "    </jd2:JDesignerLayout>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000003\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_L3ModelHistory_recreateFromEmpty()
  {
    Compartment c = m.getCompartment(3);
    String expected = "<compartment metaid=\"_000004\" id=\"C\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000004\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  public void test_L3ModelHistory_recreateFromEmpty_Model()
  {
    String ann = m.getAnnotationString();
    m.setAnnotation((XMLNode)null);
    XMLNode n1 = m.getAnnotation();
    assertTrue( n1 == null );
    m.setAnnotation(ann);
    n1 = m.getAnnotation();
    String expected = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000001\">\n" + 
    "      <dc:creator>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:parseType=\"Resource\">\n" + 
    "            <vCard:N rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Family>Le Novere</vCard:Family>\n" + 
    "              <vCard:Given>Nicolas</vCard:Given>\n" + 
    "            </vCard:N>\n" + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "            </vCard:ORG>\n" + 
    "          </rdf:li>\n" + 
    "        </rdf:Bag>\n" + 
    "      </dc:creator>\n" + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "      </dcterms:created>\n" + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "      </dcterms:modified>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>";
    assertEquals( true, equals(expected,n1.toXMLString()) );
  }

  public void test_L3ModelHistory_recreateWithOutOther()
  {
    Compartment c = m.getCompartment(2);
    String expected = "<compartment id=\"B\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "      <jd2:header>\n" + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "      </jd2:header>\n" + 
    "    </jd2:JDesignerLayout>\n" + 
    "  </annotation>\n" + 
    "</compartment>";
    assertEquals( true, equals(expected,c.toSBML()) );
  }

  /**
   * Loads the SWIG-generated libSBML Java module when this class is
   * loaded, or reports a sensible diagnostic message about why it failed.
   */
  static
  {
    String varname;
    String shlibname;

    if (System.getProperty("mrj.version") != null)
    {
      varname = "DYLD_LIBRARY_PATH";    // We're on a Mac.
      shlibname = "libsbmlj.jnilib and/or libsbml.dylib";
    }
    else
    {
      varname = "LD_LIBRARY_PATH";      // We're not on a Mac.
      shlibname = "libsbmlj.so and/or libsbml.so";
    }

    try
    {
      System.loadLibrary("sbmlj");
      // For extra safety, check that the jar file is in the classpath.
      Class.forName("org.sbml.libsbml.libsbml");
    }
    catch (SecurityException e)
    {
      e.printStackTrace();
      System.err.println("Could not load the libSBML library files due to a"+
                         " security exception.\n");
      System.exit(1);
    }
    catch (UnsatisfiedLinkError e)
    {
      e.printStackTrace();
      System.err.println("Error: could not link with the libSBML library files."+
                         " It is likely\nyour " + varname +
                         " environment variable does not include the directories\n"+
                         "containing the " + shlibname + " library files.\n");
      System.exit(1);
    }
    catch (ClassNotFoundException e)
    {
      e.printStackTrace();
      System.err.println("Error: unable to load the file libsbmlj.jar."+
                         " It is likely\nyour -classpath option and CLASSPATH" +
                         " environment variable\n"+
                         "do not include the path to libsbmlj.jar.\n");
      System.exit(1);
    }
  }
}
