#!/do/not/bash
# toc_run_description = checking if gcc supports precompiled headers
# toc_begin_help = 
#   Checks whether gcc supports precompiled headers.
#
#   Sets the config var:
#
#     GCC_SUPPORTS_PCH = 0 or 1
#
# = toc_end_help

pchtmp=test_pch.h
trap "rm $pchtmp" 0

echo '#include <stdio.h>
#define GCC_PCH_TEST 1' > $pchtmp

toc_test gcc_try_compile -xc $pchtmp && toc_test gcc_try_compile -xc++ $pchtmp
err=$?

useem=0
echo -n "precompiled headers are "
test $err = 0 && {
    useem=1
} || {
    useem=0
    echo -n "not "
}
echo "supported"

toc_add_config GCC_SUPPORTS_PCH=$useem

return $?
