#include <module.h>

inherit "module";
inherit "http";
inherit "roxenlib";


/*
 * Error-message module for Roxen/1.1 and up.
 * This module generate a error-message for some virtual trees. 
 *
 * (C) 1997 Kai Garlipp <garlipp@informatik.uni-rostock.de>
 * This code can be used, modified and redistributed freely under the terms
 * of the GNU General Public License version 2.
 * This code comes on a AS-IS basis, with NO WARRANTY OF ANY KIND, either
 * implicit or explicit. Use at your own risk.
 *
 */

array register_module()
{
  return ({ 
     MODULE_LOCATION|MODULE_LAST,
     "Error-messages",
     ("This module gives an error message"),
   });
}

void create ()
{
  defvar("path", "UNKNOWN", "Mount point", TYPE_STRING,
	 "This is where the error message will be inserted in the "+
	 "namespace of your server.");

  defvar("message", "<title>Sorry. I cannot find this resource</title>"
	 "\n<h2 align=center><configimage src=roxen.gif alt=\"File not found\">\n"
	 "<p><hr noshade>"
	 "\n<i>Sorry</i></h2>\n"
	 "<br clear>\n<font size=+2>The resource requested "
	 "<i>$File</i>\ncannot be found.<p>\n\nIf you feel that this is a "
	 "configuration error, please contact "
	 "the administrators or the author of the <if referer>"
	 "<a href=<referer>>referring</a> </if> <else>referring</else> page."
	 "<p>\n</font>\n"
	 "<hr noshade>"
	 "<A HREF=\"http://www.roxen.com/\"><version></a>, at <a href=$Me>$Me</a>.\n", 
/**/
	 "Message: No such file", TYPE_TEXT_FIELD,
	 "What to return when there is no resource of file available "
	 "at a certain location. $File will be replaced with the name "
	 "of the resource requested, and $Me with the URL of this server ");

  defvar("refresh", 0,"Automatic Refresh", TYPE_FLAG,
	 "Automaic refresh after a short delay");

  defvar("refresh_url", "NONE", "Refresh to", TYPE_STRING,
	 "URL\n");
  defvar("return", 404, "HTTP-Return-Code", TYPE_INT_LIST,
	 "HTTP-Return Code:<table border>"
	 "<TR><TD>200<TD>OK"
	 "<TR><TD>404<TD>Not Found"
	 "<TR><TD>500<TD>Internal Server Error"
	 "<TR><TD>501<TD>Not Implemented"
	 "<TR><TD>502<TD>Bad Gateway"
	 "<TR><TD>503<TD>Service Unavailable"
	 "</table>",
	 ({200,404,500,501,502,503}));

}

string query_location()
{
  return query("path");
}

void start()
{
  //perror("Error-message Online at "+QUERY(path)+"\n");
}

string real_file( mixed f, mixed id )
{
  return f;
}

mixed find_file(string filename, object id)
{
string s;

    if (id->raw_url!=id->not_query) return 0;
    s = replace(parse_rxml(query("message"), id)
		,({"$File", "$Me"}), ({ query("path")+filename, 
					roxen->query("MyWorldLocation")
					}));
    if (QUERY(refresh))
      return http_string_answer(s)
      + ([ "extra_heads":
	  ([
	    "Refresh":4 +"; URL="+replace(QUERY(refresh_url),"$File",query("path")+filename)
	    ]),
	    "error": QUERY(return)
	  ]);
    else
      return http_low_answer(QUERY(return),s);

}

array find_dir(string filename, object id){
  //perror("find_dir "+filename+"\n");
  return 0;
    //return find_file(filename,id);
}

string query_name()
{
  return sprintf("Error Message at <i>%s</i>", query("path"));
}

