
constant cvs_version="$Id: ecms.pike,v 1.0 2000/07/18 12:38:34 pit Exp $";

#include <module.h>
#include <stdio.h>
#include <process.h>
inherit "roxenlib";
inherit "xmlutils";
inherit "ecms_util";

constant module_type = MODULE_PARSER;
constant module_name = "eCms";
constant module_doc  = "eCms - easy content management suite";

object I;

void create() {
  defvar("template_location", "NONE/", "XML Template search path", TYPE_DIR
	 , "The directory where your templates are stored");
  
  defvar("content_location", "/usr/local/httpd/htdocs/content", "Content search path", TYPE_DIR
	 , "The directory where your content is stored");
  
  defvar("public_location", "/usr/local/httpd/htdocs/content", "public search path", TYPE_DIR
	 , "The directory where your content is stored");
}


void start () {
  I=TemplateStructure(query("template_location"));
}


mapping get_files() {
  mapping(string:array(mapping(string:string))) 
    ret=(["content":({}), "public":({}), "template":({}) ]);
  string rc;
  array tmp, splt;
  string n, d, t;
  mixed y,x;
  
  foreach(indices(ret), y) {
    if(y=="public") {
      rc=popen(sprintf("/usr/bin/find %s -printf \"%%p %%AY-%%Am-%%Ad %%AT\n\"| /usr/bin/sort | /usr/bin/grep .xml",
		       query(y+"_location")));
      rc+=popen(sprintf("/usr/bin/find %s -printf \"%%p %%AY-%%Am-%%Ad %%AT\n\"| /usr/bin/sort | /usr/bin/grep .html",
		       query(y+"_location")));
    } else {
      rc=popen(sprintf("/usr/bin/find %s -printf \"%%p %%AY-%%Am-%%Ad %%AT\n\"| /usr/bin/sort | /usr/bin/grep .xml",
		       query(y+"_location")));
    }
    tmp=rc/"\n";
    tmp-=({"\n"});
    tmp-=({""});
    foreach(tmp, x) {
      if(y=="public" && search(x, query("content_location")) != -1) continue;
      sscanf(x, "%s %s %s", n, d, t);
      splt=n/"/";
      ret[y]+=({ (["file":n , "date":d, "time":t, "short":splt[sizeof(splt)-1] ]) });
    }
  }
 
  return ret;
}



string tag_index( string name, mapping args, object id ) {
  string out="";
  mapping SiteFiles=get_files();
  mixed x,y,z;
  string tmp;
  out+="<foldlist>\n";
  foreach(indices(SiteFiles), x) {
    switch(x) {
    case "template":
      tmp="Template Files";
      break;
    case "content":
      tmp="Content Files";
      break;
    case "public":
      tmp="Public Files";
      break;
    default:
      tmp="Unknown";
      break;
    }
  
    out+=sprintf("<ft>%s\n<fd><ul>\n", mk_font(tmp));
    out+="<table nosave cellspacing=\"5\" cellpadding=\"5\">";
    foreach(indices(SiteFiles[x]), y) {
      out+=sprintf("<tr><td><tt>"+
		   "<li><font color=\"#000000\"><b>%s%s</b></font></li>"+
		   "<br>&nbsp;</tt><font size=\"-1\">&nbsp;[%s/%s]</font></td>"+
		   "<td><tt>&nbsp;&nbsp;"+
		   "<a href=\"edit.html?file=%s&type=%s\">"+
		   "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_1>Edit </gbutton>&nbsp;\n"+
		   "</a>"+
		   "<a href=\"edit.html?file=%s&type=%s&todo=ask_delete_file&asktext=Do yout really want to delete the %s\">"+
		   "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_3>Delete </gbutton>\n"+
		   "</a>"+
		   "</tt></td></tr>\n",
		   (tmp=="Public Files")?"/"+((SiteFiles[x][y]["file"]-query("public_location"))-SiteFiles[x][y]["short"]):"",
		   SiteFiles[x][y]["short"], 
		   SiteFiles[x][y]["date"], SiteFiles[x][y]["time"],
		   SiteFiles[x][y]["file"], x, SiteFiles[x][y]["file"], x, x 
		   );
    }
    out+="</table>\n";
    out+="\n</ul><br></fd></ft>\n";
  }
  out+="</foldlist>\n";
  return out;
}


string tag_var( string name, mapping args, object id ) {
  if(args->name) {
    if(id->variables[args->name]) 
      return((string)id->variables[args->name]);
  }
  return("");
}

private string preserve_file="";
private string preserve_type="";

string tag_edit( string name, mapping args, object id ) {
  string out="";
  string file_contents, misc;
  array xml, tmp;
  string content="";
  mixed v,x,y,z;
  int i;
  array(mapping(string:string)) template_content=({});
  array(string) unparsed_content=({});
  
  if(id->variables->todo=="add_article") {
    string new_file="";
    string new_article="";
    string dummy="";
    array fields=I->get_fields(id->variables->add_template);
    /*
       
       add a new article
       
    */
    
    if(id->variables->file) 
      file_contents=Stdio.read_file(id->variables->file);
    else
      return mk_err_font("Failed to read file\n");
    if(!file_contents || sizeof(file_contents)<1) {
      return mk_err_font("Failed to read file: "+id->variables->file+"\n");
    }
    
    tmp=file_contents/"</xmltemplate>";
    tmp-=({});
    foreach(fields, mixed x) {
      dummy+=make_xml_container( x->name, ([]), "empty")+"\n";
    }
    new_article=make_xml_container( "xmltemplate",
				   (["file":id->variables->add_template]),
				   dummy);
    new_article-="</xmltemplate>";
    tmp+=({new_article});
        
    i=0;
    foreach(tmp, x) {
      if(sizeof(x)>1)
	new_file+=x+"\n</xmltemplate>\n";
      i++;
    }
    
    object x=Stdio.File();
    if(!x->open(id->variables->file,"wtc")) {
      out += mk_err_font("File could not be opened for writing");
    } else {
      if(!x->write(new_file)) {
	out += mk_err_font("File could not be saved");
      } else {
	x->close();
	out += mk_ok_font("Empty Article has been added");
      }
    }
    
    out += "<br><br><br><br><hr>";
    out += sprintf("<gbutton href=\"edit.html?file=%s&type=%s\" bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_1>",
		   id->variables->file, id->variables->type);
    out+="Ok </gbutton></a>&nbsp;\n";
    return(out);
        
  } else if(id->variables->todo=="save") {
    /*
       
       Save a File
       
    */
    object x=Stdio.File();
    if(!x->open(id->variables->file,"wtc")) {
      out += mk_err_font("File could not be opened for writing");
    } else {
      if(!x->write(id->variables->content)) {
	out += mk_err_font("File could not be saved");
      } else {
	x->close();
	out += mk_ok_font("File has been saved");
      }
    }
    
    if(lower_case(id->variables->file[sizeof(id->variables->file)-11..])=="inheritance") {
      destruct(I);
      I=TemplateStructure(query("template_location"));
    }
    out += footer_toindex2;
    return(out);
    
    
  } else if(((string)id->variables->todo)[0..12] == "save_article_") {
    /*
       
       Save an Article
       
    */
    string article_id=((string)id->variables->todo)[13..];
    string new_article="";
    string new_article_contents="";
    mapping new_args=([]);
    string new_file="";

    // parse and remove atribute variables
    if(id->variables["template_file_"+article_id]) {
      new_args+=([ "file":id->variables["template_file_"+article_id] ]);
      id->variables-=(["template_file_"+article_id:id->variables["template_file_"+article_id] ]);
    }  
   
    if(id->variables["parse_rxml_"+article_id]) {
      new_args+=([ "parse_rxml":"1" ]);
      id->variables-=(["parse_rxml_"+article_id:id->variables["parse_rxml_"+article_id] ]);
    }  
        
    foreach(indices(id->variables), x) {
      tmp=x/"_";
      if(tmp[sizeof(tmp)-1] == article_id) {
	  new_article_contents+="\n";
	  new_article_contents+=make_xml_container(x-("_"+article_id), ([]), id->variables[x]);
      }
    }
       
    new_article=make_xml_container("xmltemplate", new_args, new_article_contents);
            
    if(id->variables->file) 
      file_contents=Stdio.read_file(id->variables->file);
    else
      return mk_err_font("Failed to read file\n");
    if(!file_contents || sizeof(file_contents)<1) {
      return mk_err_font("Failed to read file: "+id->variables->file+"\n");
    }
    
    tmp=file_contents/"</xmltemplate>";
    tmp-=({});
    i=0;
    foreach(tmp, x) {
      if(i==(int)article_id) {
	new_file+=new_article+"\n";
      } else {
	if(sizeof(x)>1)
	  new_file+=x+"\n</xmltemplate>\n";
      }
      i++;
    }
    
    
    object x=Stdio.File();
    if(!x->open(id->variables->file,"wtc")) {
      out += mk_err_font("File could not be opened for writing");
    } else {
      if(!x->write(new_file)) {
	out += mk_err_font("File could not be saved");
      } else {
	x->close();
	out += mk_ok_font(sprintf("Article %d has been saved", (int)article_id+1)   );
      }
    }
    
    out += "<br><br><br><br><hr>";
    out += sprintf("<gbutton href=\"edit.html?file=%s&type=%s\" bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_1>",
		   id->variables->file, id->variables->type);
    out+="Ok </gbutton></a>&nbsp;\n";
        
    return(out);
  } else if(((string)id->variables->todo)[0..17] == "ask_delete_article") {
    /*
       
       ask for confirmation to delete an article
       
    */
    string article_id=((string)id->variables->todo)[18..];
    out+="<obox bgcolor=\"#FFFFFF\" outlinecolor=\"#CCCCCC\" outlinewidth=\"1\" textcolor=\"#000000\" width=\"550\"><div align=\"center\">";
    out+=sprintf("<tt><br><b>Do you really want to delete the article</b><br><br>"+
		 "<b><font size=\"+1\">%s</font></b><br><br><br>",
		 id->variables["heading"+article_id], 
		 (id->variables->file/"/")[sizeof(id->variables->file/"/")-1]    );
    
    out+=sprintf("<a href=\"edit.html?file=%s&todo=delete_article%s&type=%s\">"+
		 "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_1>"+
		 "Yes </gbutton></a>&nbsp;\n",
		 id->variables->file, article_id, id->variables->type
		 );
    
    out+=sprintf("<a href=\"edit.html?file=%s&type=%s\" onClick='history.go(-1);'>"+
		 "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_3>"+
		 "No </gbutton></a>\n",
		 id->variables->file, id->variables->type
		 );
            
    out+="</div></obox>";
    return out;
    
  } else if(((string)id->variables->todo)[0..14] == "delete_article_") {
    /*
       
       delete an article
       
    */
    string article_id=((string)id->variables->todo)[15..];
    string new_file="";
    
    if(id->variables->file) 
      file_contents=Stdio.read_file(id->variables->file);
    else
      return mk_err_font("Failed to read file\n");
    if(!file_contents || sizeof(file_contents)<1) {
      return mk_err_font("Failed to read file: "+id->variables->file+"\n");
    }
    
    tmp=file_contents/"</xmltemplate>";
    i=0;
    foreach(tmp, x) {
      if(i!=(int)article_id) {
	if(sizeof(x)>1)
	  new_file+=x+"</xmltemplate>\n"; 
      }
      i++;
    }
        
    object x=Stdio.File();
    if(!x->open(id->variables->file,"wtc")) {
      out += mk_err_font("File could not be opened for writing");
    } else {
      if(!x->write(new_file)) {
	out += mk_err_font("File could not be saved");
      } else {
	x->close();
	out += mk_ok_font(sprintf("Article %d has been deleted", (int)article_id+1)   );
      }
    }
    
    out += "<br><br><br><br><hr>";
    out += sprintf("<gbutton href=\"edit.html?file=%s&type=%s\" bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_1>",
		   id->variables->file, id->variables->type);
    out+="Ok </gbutton></a>&nbsp;\n";
    
    return parse_rxml(out, id);
    
  } else if(((string)id->variables->todo) == "ask_delete_file") {
    /*
       
       ask for confirmation to delete a file)
       
    */
    
    out+="<obox bgcolor=\"#FFFFFF\" outlinecolor=\"#CCCCCC\" outlinewidth=\"1\" textcolor=\"#000000\" width=\"550\"><div align=\"center\">";
    
    out+=sprintf("<tt><br><b>%s</b><br><br>"+
		 "<b><font size=\"+1\">%s</font></b><br><br><br>",
		 id->variables->asktext, (id->variables->file/"/")[sizeof(id->variables->file/"/")-1]    );
    
    out+=sprintf("<a href=\"edit.html?file=%s&todo=%s\">"+
		 "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_1>"+
		 "Yes </gbutton></a>&nbsp;\n",
		 id->variables->file, id->variables->todo[4..sizeof(id->variables->todo)]
		 );
    
    out+=sprintf("<a href=\"ecms.html\">"+
		 "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_3>"+
		 "No </gbutton></a>\n"
		 );
            
    out+="</div></obox>";
    return out;
    
  } else if(((string)id->variables->todo) == "delete_file") {
    /*
    
       delete a file
       
    */
    rm(id->variables->file);
    out += mk_ok_font("File has been removed");
    out += footer_toindex2;
    return out;
  } else {
    /*
       
       show an edit page
    
    */
       
    if(id->variables->file) 
      file_contents=Stdio.read_file(id->variables->file);
    else if (preserve_file) 
      file_contents=Stdio.read_file(preserve_file);
    else
      return mk_err_font("Failed to read file\n");
    
    if(!file_contents || sizeof(file_contents)<1) {
      return mk_err_font("Failed to read file: "+id->variables->file+"\n");
    }
    
    /*
       
       Edit Content files
       
    */
    if(id->variables->type=="content" || preserve_type=="content") {
      
      // get unparsed content between <content></>
      tmp=file_contents/"<content>";
      foreach(tmp, x) {
	z="";
	sscanf(x, "%s</content>%*s", z);
	unparsed_content+=({z});
	
      }
      unparsed_content-=({""});
      
      // workaround for dull xml parser; this is ok, because we got the content earlyer
      file_contents=replace(file_contents, 
			    ({ "<br>",   "<BR>",   "<p>",   "<P>",   "<HR>",   "<hr>"     }),
			    ({ "||br||", "||br||", "||p||", "||p||", "||hr||", "||hr||"   })
			    );
      
      xml = spider.XML()->parse(file_contents, callback);
      t_content=({});
      template_content=get_template_content(xml);
      
      out+=sprintf("<input type=\"hidden\" name=\"file\" value=\"%s\"/>", 
		   (id->variables->file)?id->variables->file:preserve_file);
      out+=sprintf("<input type=\"hidden\" name=\"type\" value=\"%s\"/>", 
		   (id->variables->type)?id->variables->type:preserve_type);
      if(id->variables->file) 
	preserve_file=id->variables->file;
      if(id->variables->type)
	preserve_type=id->variables->type;

      out+="<foldlist>\n";
      
      
      // show only level 2 templates
      mapping Struct=I->get_structure();
      string valid_templates="";
      array have=({});
      foreach(indices(Struct), mixed a) {
	foreach(Struct[a], mixed b) {
	  if(search(have, b->file) == -1) {
	    valid_templates+=sprintf("<option name=\"%s\">%s</option>\n", b->file, b->file);
	    have+=({b->file});
	  }
	}
      }

      i=0;
      foreach(template_content, x) {
	// a edit section for each template-entry using <foldlist></>
	
	if(x["heading"]) misc="  \""+x["heading"]+"\"";
	else misc=sprintf(" %d", i+1);
	out+=sprintf("<ft>%s<fd><br><ul>\n", mk_font(sprintf("Article %s", misc )));
	
	out+=sprintf("<a href=\"javascript:document.edit.action='edit.html?todo=save_article_%d'; document.edit.submit();\">"+
		     "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_1>"+
		     "Save </gbutton></a>&nbsp;\n",
		     i );
	
	out+=sprintf("<a href=\"javascript:document.edit.action='edit.html?todo=ask_delete_article_%d'; document.edit.submit();\">"+
		     "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_3>"+
		     "Delete </gbutton></a>&nbsp;\n",
		     i );
	out+="<br><br>\n";
	
		
	foreach(indices(x), y) {
	  if((string)y=="template_file") { // specialities for <xmlemplate></>
	    
	    out+=sprintf("<b>Template:</b> <select name=\"template_file_%d\">\n\n", i);
	    out+=sprintf("<option selected name=\"%s\">%s</option>", (string)x[y], (string)x[y]);
	    out+="<option>--------</option>";
	    out+=valid_templates;
	    out+=sprintf("\n</select>&nbsp;&nbsp;Parse RXML: <input type=\"checkbox\" name=\"parse_rxml_%d\" /><br>\n\n", i);
	  } else {
	    if(mappingp(x[y])) { // to enable <sometag> in editing fields
	      misc=make_xml_tag(x[y]->name, x[y]->attributes);
	    }
	    else misc=(string)x[y];
	    out+=sprintf("<noparse><b>%s:</b><br><input type=\"text\" name=\"%s_%d\" value='%s' size=\"85\" maxlength=\"100\"/></noparse><br>",
			 (string)y, (string)y, i, misc );
	  }
	}
	
	if(sizeof(unparsed_content)) {
	  out+=sprintf("<br><b>Content:</b><br><noparse><textarea name=\"content_%d\" rows=\"12\" cols=\"85\">%s</textarea></noparse>\n", 
		       i, "<noparse>"+unparsed_content[i]+"</noparse>" );
	}
	out+="\n</ul><br><br></fd></ft>\n";
	i++;
      }
     
      out+="</foldlist>\n";
      
      out+="<br><br><br><br><hr>";
      out +="<table><tr>";
      out += "<td><a href=\"ecms.html\">"+
	     "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_3>"+
	     "Cancel </gbutton></a>&nbsp;\n</td>";
      out +="<td><a href=\"javascript:document.edit.action='edit.html?todo=add_article'; document.edit.submit();\">"+
	    "<gbutton align_icon=\"right\" bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-next>"+
	    "New Article </gbutton></a>&nbsp;\n</td>";
      out +="<td><select name=\"add_template\">";
      out +=valid_templates;
      out +="\n</select></td>\n";
      
      out +="</tr></table>";
      
    } else if(id->variables->type=="public") {
      out+=sprintf("<textarea name=\"content\" rows=\"20\" cols=\"85\">%s</textarea>\n", 
		   "<noparse>"+file_contents+"</noparse>");
      out+=sprintf("<input type=\"hidden\" name=\"file\" value=\"%s\"/>", 
		   (id->variables->file)?id->variables->file:preserve_file);
      out += footer_std;
      
    } else {
      out+=sprintf("<textarea name=\"content\" rows=\"20\" cols=\"85\">%s</textarea>\n", 
		   "<noparse>"+file_contents+"</noparse>");
      out+=sprintf("<input type=\"hidden\" name=\"file\" value=\"%s\"/>", 
		   (id->variables->file)?id->variables->file:preserve_file);
      out += footer_std;
    }
    
  } // end todo-check
  
  return out;
}

string tag_new( string name, mapping args, object id ) {
  string cont="";

  
  
  switch(id->variables->todo) {

  case "filename":
    cont ="<input type=\"hidden\" name=\"todo\" value=\"check_file\">";
    foreach(indices(id->variables), mixed x) {
      if(x=="todo") continue;
      cont+=sprintf("<input type=hidden name=\"%s\" value=\"%s\">", x, (string)id->variables[x]); 
    }
    cont+="<tt><b>Enter Filename:</b><br><ul>";
    cont+=sprintf("<input type=text name=new_filename size=25 value=\"%s\"/>",
		  (id->variables->new_filename)?id->variables->new_filename:".xml");
    cont+="</ul><br></tt>";
    return wizardpage("Create new "+id->variables->new_type+" file", cont, "javascript:document.wiz.action='new.html'; document.wiz.submit();",
		      "javascript:document.wiz.todo.value='nope'; document.wiz.action='new.html'; document.wiz.submit();", "javascript:document.wiz.action='new.html'; document.wiz.submit();", "ecms.html" );  
    break;
    
  case "check_file":
    foreach(indices(id->variables), mixed x) {
      cont+=sprintf("<input type=hidden name=\"%s\" value=\"%s\">", x, (string)id->variables[x]); 
    }
    if(file_stat(sprintf("%s%s", query(id->variables->new_type+"_location"), id->variables->new_filename))) {
      // file exists
      cont+="<br>";
      cont+=mk_err_font(sprintf("File \"%s\" already exists. Choose another name.",id->variables->new_filename ));
      cont+="<br><br><br>";
      return wizardpage("Create new "+id->variables->new_type+" file", cont,
			"",
			"javascript:document.wiz.todo.value='filename'; document.wiz.action='new.html'; document.wiz.submit();",
			"javascript:document.wiz.todo.value='filename'; document.wiz.action='new.html'; document.wiz.submit();",
			"ecms.html" );  
    } else {
      cont+="<tt><b>Select Template:</b><br><ul>";
      cont+="<select name=new_template>\n";
      if(id->variables->new_type=="public") {
	// only top-level templates
	mapping Struct=I->get_structure();
	array have=({});
	foreach(indices(Struct), mixed a) {
	  if(search(have, a) == -1) {
	    cont+=sprintf("<option name=\"%s\">%s</option>\n", a, a);
	    have+=({a});
	  }
	}
      } else if (id->variables->new_type=="content") {
	// only secont level templates
	mapping Struct=I->get_structure();
	array have=({});
	foreach(indices(Struct), mixed a) {
	  foreach(Struct[a], mixed b) {
	    if(search(have, b->file) == -1) {
	      cont+=sprintf("<option name=\"%s\">%s</option>\n", b->file, b->file);
	      have+=({b->file});
	    }
	  }
	}
      } else { 
	// all templates
	mapping SiteFiles=get_files();
	foreach(SiteFiles->template, mixed x) {
	  cont+=sprintf("<option value=\"%s\">%s", x->short, x->short);
	}
      }
            
      cont+="</select></ul><br></tt>";
      return wizardpage("Create new "+id->variables->new_type+" file", cont,
			"javascript:document.wiz.todo.value='mkfile'; document.wiz.action='new.html'; document.wiz.submit();",
			"javascript:document.wiz.todo.value='filename'; document.wiz.action='new.html'; document.wiz.submit();",
			"javascript:document.wiz.todo.value='mkfile'; document.wiz.action='new.html'; document.wiz.submit();",
			"ecms.html" ); 
    }
    break;
    
  case "mkfile":
    // make an empty file from template
    cont="";
    array fields;
    string new_file="";
    
    string tmp="";
    string new_file="";
    if(id->variables->new_type=="template") { // we make a copy of the selected template
      new_file=Stdio.read_file(query("template_location")+id->variables->new_template);
    } else {
      array fields=I->get_fields(id->variables->new_template);
      foreach(fields, mixed x) {
	tmp+=make_xml_container( x->name, ([]), "empty")+"\n";
      }
      new_file=make_xml_container( "xmltemplate",
				  (["file":id->variables->new_template])
				  , tmp);
    }
    object x=Stdio.File();
    if(!x->open(query(id->variables->new_type+"_location")+id->variables->new_filename, "wtc")) {
      cont += mk_err_font("File could not be opened for writing.");
    } else {
      if(!x->write(new_file)) {
	cont += mk_err_font("File could not be saved.");
      } else {
	x->close();
	cont += mk_ok_font(sprintf("New %s file \"%s\" has been saved",
				   id->variables->new_type, id->variables->new_filename));
	cont += "<br><ul><b>Edit it immediatly by klicking \"Ok\" or<br>use \"Cancel\" to return to index.</b></ul><br><br>";
      }
    }
        
    return wizardpage("Create new "+id->variables->new_type+" file", cont,
			"",
			"",
			sprintf("javascript:top.location='edit.html?file=%s&type=%s';",
				query(id->variables->new_type+"_location")+id->variables->new_filename,
				id->variables->new_type				
				),
			"ecms.html" ); 
    
    break;
    
    
  default:
    cont ="<input type=\"hidden\" name=\"todo\" value=\"filename\">";
    cont+="<tt><b>Select File Type:</b><br><ul>";
    cont+="<select name=new_type>\n";
    cont+="<option value=content>Content File\n";
    cont+="<option value=public>Public File\n";
    cont+="<option value=template>Template File\n";
    cont+="</select></ul><br></tt>";
    return wizardpage("Create new file", cont, "javascript:document.wiz.action='new.html'; document.wiz.submit();",
		      "", "javascript:document.wiz.action='new.html'; document.wiz.submit();", "ecms.html" );  
    break;
  }

}


string wizardpage(string title, string content, string next, string prev, string ok, string cancel) {
  string out="";
    
  out+="<form name=\"wiz\" method=\"put\">";
  out+="<table bgcolor=\"#000000\" cellpadding=\"1\" border=\"0\" cellspacing=\"0\" width=\"80%\">";
  out+="<tr><td><table bgcolor=\"#EEEEEE\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">";
  out+="<tr><td valign=\"top\"><table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\">";
  out+="<tr><td valign=top>";
  // title
  out+=sprintf("<gtext nfont=\"futura\" scale=\"0.6\">%s</gtext></td>", title);
  // page -------------------v
  out+="<td align=\"right\">   </td><td align=\"right\"></td>";
  out+="</tr><tr><td colspan=\"3\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">";
  out+="<tr bgcolor=\"#000000\"><td><img src=\"/internal-roxen-unit\" width=\"1\" height=\"1\"/></td></tr>";
  out+="</table></td></tr></table><table cellpadding=\"6\"><tr><td>";
  // content
  out+=content;
  out+="</td></tr></table><table cellspacing=2 cellpadding=2 width=\"100%\"><tr>";
  // buttons  
  out+="<td align=\"left\">";
  out+=sprintf("<gbutton state=%s href=\"%s\" bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-prev align_icon=\"left\" align=\"right\">"+
	       "Prev </gbutton>",
	       (sizeof(prev))?"enabled":"disabled", prev
	       );
  out+="</td>\n";
    
  out+="<td align=\"center\">";
  out+=sprintf("<gbutton state=%s  href=\"%s\" bgcolor=\"#CCCCCC\" icon_src=/internal-roxen-err_1 textcolor=\"#000000\">"+
	       "Ok </gbutton>&nbsp;&nbsp;",
	       (sizeof(ok))?"enabled":"disabled", ok
	       );
  out+=sprintf("<gbutton state=%s href=\"%s\" bgcolor=\"#CCCCCC\" icon_src=/internal-roxen-err_3 textcolor=\"#000000\">"+
	       "Cancel </gbutton>",
	       (sizeof(cancel))?"enabled":"disabled", cancel
	       );
  out+="</td>\n";
  
  out+="<td align=\"right\">";
  out+=sprintf("<gbutton state=%s href=\"%s\" bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-next align_icon=\"right\" align=\"left\">"+
	       "Next </gbutton>",
	       (sizeof(next))?"enabled":"disabled", next	       
	       );
  out+="</td>\n";
  // end buttons 
  out+="</tr></table></td></tr></table></td></tr></table></form>";
  return(out);
}

//id->conf->name





array(mapping(string:string)) t_content=({});
array get_template_content(array data) {
  mixed x,y,z;
  mapping current=([]);
  foreach(data, x) {
    
    if(mappingp(x)) {
      if (x->name && x->name=="xmltemplate") {
	current =(["template_file":x->attributes->file]);
	
	if(arrayp(x->data)) {
	  foreach(x->data, y) {
	    if(mappingp(y)) {
	      if(y->name && y->name != "content")
		current+=([y->name:y->data[0]]);
	    }
	  }
	}
	t_content+=({ current });
      }
      if(x->data && arrayp(x->data))
	get_template_content(x->data);
    }
  }
  return t_content;
}

string footer_std=
  "<br><br><br><br><hr>"+
  "<a href=\"javascript:document.edit.action='edit.html?todo=save'; document.edit.submit();\">"+
  "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_1>"+
  "Save </gbutton></a>&nbsp;\n"+
  "<a href=\"ecms.html\">"+
  "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_3>"+
  "Cancel </gbutton></a>&nbsp;\n";

string footer_toindex=
  "<br><br><br><br><hr>"+
  "<a href=\"ecms.html\">"+
  "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_3>"+
  "Cancel </gbutton></a>&nbsp;\n";

string footer_toindex2=
  "<br><br><br><br><hr>"+
  "<a href=\"ecms.html\">"+
  "<gbutton bgcolor=\"#CCCCCC\" textcolor=\"#000000\" icon_src=/internal-roxen-err_1>"+
  "Ok </gbutton></a>&nbsp;\n";












/* HINTS */





/*

   
   
   
   mapping decompress_state(string from)
{
  if(!from) return ([]);
  from = MIME.decode_base64(from);
  catch
  {
    object gz = Gz;
    if(sizeof(indices(gz)))
      from = gz->inflate()->inflate(from);
    return decode_value(from);
  };
  return ([]);
}


string compress_state(mapping state)
{
  state = copy_value(state);
  m_delete(state,"_state");
  m_delete(state,"next_page");
  m_delete(state,"prev_page");
  m_delete(state,"help");
  m_delete(state,"action");
  m_delete(state,"unique");

//  werror(sprintf("State=%O\n", state));

  string from = encode_value(state);
  object gz = Gz;
  if(sizeof(indices(gz)))
    from = gz->deflate()->deflate(from);
  return MIME.encode_base64( from );
}
   
   
   
   
   
   
   
   
   
   
   class TagMytest {
  inherit RXML.Tag;

  constant name  = "mytest";
  mapping(string:RXML.Type) opt_arg_types = ([ "alt" : RXML.t_text ]);

  class Frame {
    inherit RXML.Frame;
    array do_enter(RequestID id) {
      //id->prestate
      //args->alt
      result="mytesttag";
      return 0;
    }
    
    array do_return(RequestID id) {
      //id->variables=oldvar;
      //result=content;
      return 0;
    }
    
  };
  
};

*/


//Roxen.make_tag("img", m)
//Roxen.add_http_header(_extra_heads, "Set-Cookie", cookies);
//Roxen.add_pre_state(href, prestate);
//Roxen.make_container("a", args, content);
//RXML.parse_error("No src given.\n");

/*
private string tag_xxx (string tag, mapping m, string c, RequestID id, object state, mapping fl) {
  return("zzz!\n<br>"+c);
}


string container_zzz(string tag, mapping m, string c, RequestID id) {
  return("zzz!\n<br>"+c);
  //c=parse_html(c,([]),(["xxx":tag_xxx]),id,state,fl);
}
*/



/*
   string tag_remove_cookie(string tag, mapping m, RequestID id)
{
  if(!m->name || !id->cookies[m->name]) RXML.run_error("That cookie does not exists.\n");

  Roxen.add_http_header(_extra_heads, "Set-Cookie",
    Roxen.http_encode_cookie(m->name)+"="+Roxen.http_encode_cookie(m->value||"")+
			"; expires=Thu, 01-Jan-70 00:00:01 GMT; path=/"
  );

  return "";
}
   
string tag_set_cookie(string tag, mapping m, RequestID id)
{
  if(!m->name)
    RXML.parse_error("Requires a name attribute.\n");

  string cookies = Roxen.http_encode_cookie(m->name)+"="+Roxen.http_encode_cookie(m->value||"");
  int t;     //time

  if(m->persistent)
    t=(3600*(24*365*2));
  else
    t=Roxen.time_dequantifier(m);

  if(t)
    cookies += "; expires="+Roxen.http_date(t+time(1));

  if (m->domain)
    cookies += "; domain=" + Roxen.http_encode_cookie(m->domain);

  //FIXME: Check the parameter's usability
  cookies += "; path=" + Roxen.http_encode_cookie(m->path||"/");

  Roxen.add_http_header(_extra_heads, "Set-Cookie", cookies);

  return "";
}
*/