#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "xanim.h"
#include "xa_color.h"

xaLONG x11_red_mask    = 0x00FF0000;
xaLONG x11_green_mask  = 0x0000FF00;
xaLONG x11_blue_mask   = 0x000000FF;
xaLONG x11_red_shift   = 16;
xaLONG x11_green_shift = 8;
xaLONG x11_blue_shift  = 0;
xaULONG x11_red_bits    = 8; 
xaULONG x11_green_bits  = 8;
xaULONG x11_blue_bits   = 8;

int x11_byte_mismatch = 0;

int xa_debug = 0;
int xa_verbose = 0;
int xa_optimize_flag = 0;

int x11_display_type = XA_TRUECOLOR;
int cmap_color_func = 0;

int cmap_true_to_332 = 0;
xaLONG x11_cmap_size = 0x01000000;
int xa_dither_flag = 0;

xaUBYTE * xa_byte_limit = (xaUBYTE*)0;

xaUSHORT qt_gamma_adj[32];

xaUSHORT xa_gamma_adj[256];

xaULONG xa_gamma_flag = 0;
YUVBufs jpg_YUVBufs;
xaULONG jpg_MCUbuf_size = 0;
int jpg_init_flag = 0;

/* Setup functions for tables */

static double  cmap_cur_gamma = 0.0;

#define CENTERJSAMPLE 128
#define MAXJSAMPLE 255
#define DCTSIZE2 64

#define GAMMA_MIN 0.0001

xaULONG CMAP_Gamma_Adjust(gamma_adj,disp_gamma,anim_gamma)
xaUSHORT *gamma_adj;
double disp_gamma,anim_gamma;
{
  register xaULONG i;
  double pow(),t64k,d;
 
  DEBUG_LEVEL2 fprintf(stderr,"CMAP_Gamma_Adjust\n");
  if (disp_gamma < GAMMA_MIN) disp_gamma = 1.0;
  if (anim_gamma < GAMMA_MIN) anim_gamma = 1.0;

  cmap_cur_gamma = anim_gamma/disp_gamma;
  t64k = (double)(65535.0);
  for(i=0;i<256;i++)
  {
    d = (double)(i * 257)/t64k;
    gamma_adj[i] = (xaUSHORT)(0.5 + t64k * pow(d, cmap_cur_gamma));
  }
  if (disp_gamma == anim_gamma) return(xaFALSE);
  else return(xaTRUE);
}

typedef void XA_ANIM_HDR;

static xaUBYTE  jpg_samp_limit[(5 * (MAXJSAMPLE+1) + CENTERJSAMPLE)];

void XA_Add_Func_To_Free_Chain(anim_hdr,function)
XA_ANIM_HDR *anim_hdr;
void (*function)();
{
}

xaUBYTE *jpg_Ybuf = 0;
xaUBYTE *jpg_Ubuf = 0;
xaUBYTE *jpg_Vbuf = 0;

void JPG_Free_Samp_Limit_Table()
{
}

void JPG_Setup_Samp_Limit_Table(anim_hdr)
XA_ANIM_HDR *anim_hdr;
{
  xaUBYTE *table;
  xaLONG i;

  xa_byte_limit = jpg_samp_limit + (MAXJSAMPLE + 1);

  table = jpg_samp_limit;
  table += (MAXJSAMPLE+1);   /* allow negative subscripts of simple table */

  /* First segment of "simple" table: limit[x] = 0 for x < 0 */
  memset(table - (MAXJSAMPLE+1), 0, (MAXJSAMPLE+1));

  /* Main part of "simple" table: limit[x] = x */
  for (i = 0; i <= MAXJSAMPLE; i++) table[i] = (xaUBYTE) i;

  table += CENTERJSAMPLE;       /* Point to where post-IDCT table starts */
  /* End of simple table, rest of first half of post-IDCT table */

  for (i = CENTERJSAMPLE; i < 2*(MAXJSAMPLE+1); i++) table[i] = MAXJSAMPLE;

  /* Second half of post-IDCT table */
  memset(table + (2 * (MAXJSAMPLE+1)), 0, (2 * (MAXJSAMPLE+1) - CENTERJSAMPLE));
  memcpy(table + (4 * (MAXJSAMPLE+1) - CENTERJSAMPLE),
          (char *)(jpg_samp_limit+(MAXJSAMPLE+1)), CENTERJSAMPLE);
}

void JPG_Free_MCU_Bufs()
{
  if (jpg_Ybuf)         { free(jpg_Ybuf); jpg_Ybuf = 0; }
  if (jpg_Ubuf)         { free(jpg_Ubuf); jpg_Ubuf = 0; }
  if (jpg_Vbuf)         { free(jpg_Vbuf); jpg_Vbuf = 0; }
  jpg_YUVBufs.Ybuf = 0; jpg_YUVBufs.Ubuf = 0; jpg_YUVBufs.Vbuf = 0;
}


void jpg_init_stuff()
{ xaLONG i;
/*   DEBUG_LEVEL1 fprintf(stderr,"JJINIT\n"); */
  if (jpg_init_flag==xaTRUE) return;
/*   for(i=0; i < JJ_NUM_QUANT_TBLS; i++) jpg_quant_tables[i] = 0; */
  if (jpg_samp_limit==0) JPG_Setup_Samp_Limit_Table(0);
  jpg_init_flag = xaTRUE;
/*   jpg_std_DHT_flag = 0; */
/*   qt_jpeg_info.valid = xaFALSE; */
/*   avi_jpeg_info.valid = xaFALSE; */
}


void JPG_Alloc_MCU_Bufs(anim_hdr,width,height,full_flag)
XA_ANIM_HDR *anim_hdr;
xaULONG width, height, full_flag;
{ xaULONG twidth  = (width + 15) / 16;
  xaULONG theight = (height + 15) / 16;  if (theight & 1) theight++;

  if (full_flag==xaTRUE) twidth *= (theight << 2);
  else                   twidth <<= 2; /* four dct's deep */

DEBUG_LEVEL1 fprintf(stderr,"Alloc_MCU: wh %d %d twid %d act %d\n",
                        width,height,twidth,(twidth * DCTSIZE2) );

  if (anim_hdr) XA_Add_Func_To_Free_Chain(anim_hdr,JPG_Free_MCU_Bufs);
  if (jpg_init_flag==xaFALSE) jpg_init_stuff();
  if (jpg_Ybuf == 0)
  { jpg_MCUbuf_size = twidth;
    jpg_Ybuf = (xaUBYTE *)malloc(twidth * DCTSIZE2);
    jpg_Ubuf = (xaUBYTE *)malloc(twidth * DCTSIZE2);
    jpg_Vbuf = (xaUBYTE *)malloc(twidth * DCTSIZE2);
  }
  else if (twidth > jpg_MCUbuf_size)
  { jpg_MCUbuf_size = twidth;
    jpg_Ybuf = (xaUBYTE *)realloc( jpg_Ybuf,(twidth * DCTSIZE2) );
    jpg_Ubuf = (xaUBYTE *)realloc( jpg_Ubuf,(twidth * DCTSIZE2) );
    jpg_Vbuf = (xaUBYTE *)realloc( jpg_Vbuf,(twidth * DCTSIZE2) );
  }
  jpg_YUVBufs.Ybuf = jpg_Ybuf;
  jpg_YUVBufs.Ubuf = jpg_Ubuf;
  jpg_YUVBufs.Vbuf = jpg_Vbuf;

}



xaULONG X11_Get_True_Color(r,g,b,bits)
register xaULONG r,g,b,bits;
{
  register xaULONG temp,temp_color;

  temp = (x11_red_bits >= bits)?(r << (x11_red_bits - bits))
                               :(r >> (bits - x11_red_bits));
  temp_color  = (temp << x11_red_shift) & x11_red_mask;

  temp = (x11_green_bits >= bits)?(g << (x11_green_bits - bits))
                                 :(g >> (bits - x11_green_bits));
  temp_color |= (temp << x11_green_shift) & x11_green_mask;

  temp = (x11_blue_bits >= bits)?(b << (x11_blue_bits - bits))
                                :(b >> (bits - x11_blue_bits));
  temp_color |= (temp << x11_blue_shift) & x11_blue_mask;


/*
temp = temp_color;
temp_color  = ((temp >> 24) & 0xff) ;
temp_color |= ((temp >> 16) & 0xff) <<  8;
temp_color |= ((temp >>  8) & 0xff) << 16;
temp_color |= ((temp      ) & 0xff) << 24;
*/
  return(temp_color);
}


xaULONG AVI_Get_Color(color,map_flag,map,chdr)
xaULONG color,map_flag,*map;
XA_CHDR *chdr;
{ register xaULONG clr,ra,ga,ba,tr,tg,tb;
 
  ra = (color >> 10) & 0x1f;
  ga = (color >>  5) & 0x1f;
  ba =  color & 0x1f;
  tr = (ra << 3) | (ra >> 2);
  tg = (ga << 3) | (ga >> 2);
  tb = (ba << 3) | (ba >> 2);
  if (xa_gamma_flag==xaTRUE) { tr = xa_gamma_adj[tr]>>8;  
     tg = xa_gamma_adj[tg]>>8; tb = xa_gamma_adj[tb]>>8; }

  clr = X11_Get_True_Color(ra,ga,ba,5);
  return(clr);
}

xaULONG XA_RGB24_To_CLR32(r,g,b,map_flag,map,chdr)
register xaULONG r,g,b;
xaULONG map_flag,*map;
XA_CHDR *chdr;
{ xaULONG clr;

        clr = X11_Get_True_Color( xa_gamma_adj[r], 
                                  xa_gamma_adj[g], xa_gamma_adj[b], 16);
  return(clr);
}

/* Quicktime color palette stuff */

static int qt_2map[] = {
0x93, 0x65, 0x5e,
0xff, 0xff, 0xff,
0xdf, 0xd0, 0xab,
0x00, 0x00, 0x00
};

/* MAX */
static int qt_4map[] = {
0xff, 0xfb, 0xff,
0xef, 0xd9, 0xbb,
0xe8, 0xc9, 0xb1,
0x93, 0x65, 0x5e,
0xfc, 0xde, 0xe8,
0x9d, 0x88, 0x91,
0xff, 0xff, 0xff,
0xff, 0xff, 0xff,
0xff, 0xff, 0xff,
0x47, 0x48, 0x37,
0x7a, 0x5e, 0x55,
0xdf, 0xd0, 0xab,
0xff, 0xfb, 0xf9,
0xe8, 0xca, 0xc5,
0x8a, 0x7c, 0x77,
0x00, 0x00, 0x00
};

/**************************************
 * QT_Create_Default_Cmap
 *
 * This routine recreates the Default Apple colormap.
 * It is an educated quess after looking at two quicktime animations
 * and may not be totally correct, but seems to work okay.
 */
void QT_Create_Default_Cmap(cmap,cnum)
ColorReg *cmap;
xaULONG cnum;
{
  xaLONG r,g,b,i;

  if (cnum == 4)
  { 
    for(i=0;i<4;i++)
    { int d = i * 3;
      cmap[i].red   = 0x101 * qt_2map[d];
      cmap[i].green = 0x101 * qt_2map[d+1];
      cmap[i].blue  = 0x101 * qt_2map[d+2];
    }
  }
  else if (cnum == 16)
  { 
    for(i=0;i<16;i++)
    { int d = i * 3;
      cmap[i].red   = 0x101 * qt_4map[d];
      cmap[i].green = 0x101 * qt_4map[d+1];
      cmap[i].blue  = 0x101 * qt_4map[d+2];
    }
  }
  else
  { static xaUBYTE pat[10] = {0xee,0xdd,0xbb,0xaa,0x88,0x77,0x55,0x44,0x22,0x11};
    r = g = b = 0xff;
    for(i=0;i<215;i++)
    {
      cmap[i].red   = 0x101 * r;
      cmap[i].green = 0x101 * g;
      cmap[i].blue  = 0x101 * b;
      b -= 0x33;
      if (b < 0) { b = 0xff; g -= 0x33; if (g < 0) { g = 0xff; r -= 0x33; } }
    }
    for(i=0;i<10;i++)
    { xaULONG d = 0x101 * pat[i];
      xaULONG ip = 215 + i; 
      cmap[ip].red   = d; cmap[ip].green = cmap[ip].blue  = 0; ip += 10;
      cmap[ip].green = d; cmap[ip].red   = cmap[ip].blue  = 0; ip += 10;
      cmap[ip].blue  = d; cmap[ip].red   = cmap[ip].green = 0; ip += 10;
      cmap[ip].red   = cmap[ip].green = cmap[ip].blue  = d;
    }
    cmap[255].red = cmap[255].green = cmap[255].blue  = 0x00;
  }
}

/**************************************
 * QT_Create_Gray_Cmap
 *
 * This routine recreates the Default Gray Apple colormap.
 */
void QT_Create_Gray_Cmap(cmap,flag,num)
ColorReg *cmap;
xaULONG flag;   /* flag=0  0=>255;  flag=1 255=>0 */
xaULONG num;    /* size of color map */
{
  xaLONG g,i;

  if (num == 256)
  {
    g = (flag)?(0x00):(0xff);
    for(i=0;i<256;i++)
    {
      cmap[i].red   = 0x101 * g;
      cmap[i].green = 0x101 * g;
      cmap[i].blue  = 0x101 * g;
      cmap[i].gray  = 0x101 * g;
      if (flag) g++; else g--;
    }
  }
  else if (num == 16)
  {
    g = 0xf;
    for(i=0;i<16;i++)
    {
      cmap[i].red   = 0x1111 * g;
      cmap[i].green = 0x1111 * g;
      cmap[i].blue  = 0x1111 * g;
      cmap[i].gray  = 0x1111 * g;
      g--;
    }
  }
}

#define QT_raw3 0x72617733
#define QT_jpeg 0x6a706567
#define QT_cvid 0x63766964

void xanim_create_qt_colormap(XA_DEC_INFO * info, int depth, char * fourcc)
  {
  ColorReg cmap[256];
  int imagec = 0, i;
  xaULONG id =
    (fourcc[0] << 24) |
    (fourcc[1] << 16) |
    (fourcc[2] << 8) |
    (fourcc[3]);
  
  if((depth == 8) || (depth == 40)
     || (depth == 4) || (depth == 36)
     || (depth == 2) || (depth == 34)) /* generate colormap */
    {
    if((depth & 0x0f) == 0x04)
      imagec = 16;
    else if((depth & 0x0f) == 0x02)
      imagec = 4;
    else
      imagec = 256;

    if ((depth < 32) && (id != QT_raw3))
      {
      QT_Create_Default_Cmap(cmap,imagec);
      }
    else /* grayscale */
      {
      if ((id == QT_jpeg) || (id == QT_cvid) || (id == QT_raw3)) 
        QT_Create_Gray_Cmap(cmap,1,imagec);
      else
        QT_Create_Gray_Cmap(cmap,0,imagec);
      }
    }

  /* Copy the colormap */

  info->map = malloc(sizeof(xaULONG)*imagec);
  
  for(i = 0; i < imagec; i++)
    {
    info->map[i]  = (xaULONG)(cmap[i].red   & 0xff00) << 8; 
    info->map[i] |= (xaULONG)(cmap[i].green & 0xff00);
    info->map[i] |= (xaULONG)(cmap[i].blue  & 0xff00) >> 8; 
    /*    fprintf(stderr, "map[%d]: 0x%08x\n", i, info->map[i]); */
    }
  
  }
