/**
 * \file protein/proteinintegercode.h
 * \date 22/05/2023
 * \author Olivier Langella
 * \brief transform protein amino acid sequence into vectors of amino acid codes
 */

/*******************************************************************************
 * Copyright (c) 2023 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once

#include "../exportinmportconfig.h"
#include "../amino_acid/aastringcodec.h"
#include "protein.h"
#include <vector>

namespace pappso
{

/**
 * @brief
 */
class PMSPP_LIB_DECL ProteinIntegerCode
{
  public:
  /**
   * Default constructor
   */
  ProteinIntegerCode(ProteinSp protein,
                     const AaStringCodec &codec,
                     std::size_t aa_str_max_size = 5);

  /**
   * Copy constructor
   *
   * @param other TODO
   */
  ProteinIntegerCode(const ProteinIntegerCode &other);

  /**
   * Destructor
   */
  ~ProteinIntegerCode();

  const std::vector<std::uint32_t> &
  getPeptideCodedFragment(std::size_t size) const;

  std::vector<std::pair<std::size_t, std::uint32_t>> match(const std::vector<uint32_t> &code_list) const;

  private:
  std::vector<std::uint32_t>
  computePeptideCodeFragments(const AaStringCodec &codec,
                              std::size_t fragment_size) const;

  private:
  ProteinSp msp_protein;

  std::vector<std::uint8_t> m_seqAaCode;
  std::vector<std::vector<std::uint32_t>> m_peptideCodedFragments;
};

} // namespace pappso
