// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libpanelappletmm/applet.h>
#include <libpanelappletmm/private/applet_p.h>

#include <gtkmm/private/eventbox_p.h>
/* Copyright 2003 libpanelappletmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Gnome
{

namespace Panel
{

AppletOrient Applet::get_orientation() const
{
  PanelAppletOrient c_orient = panel_applet_get_orient(const_cast<PanelApplet*>(gobj()));
  AppletOrient returncode = APPLET_ORIENT_UP; // Arbitrary value.

  switch(c_orient)
  {
    case PANEL_APPLET_ORIENT_UP:
      returncode = APPLET_ORIENT_UP;
      break;
    case PANEL_APPLET_ORIENT_DOWN:
      returncode = APPLET_ORIENT_DOWN;
      break;
    case PANEL_APPLET_ORIENT_LEFT:
      returncode = APPLET_ORIENT_LEFT;
      break;
    case PANEL_APPLET_ORIENT_RIGHT:
      returncode = APPLET_ORIENT_RIGHT;
      break;
    default:
      g_warning("Unexpected Orientation Value");
  }

  return returncode;
}

AppletBackgroundType Applet::get_background(Gdk::Color& color, Glib::RefPtr<Gdk::Pixmap>& pixmap) const
{
  GdkColor cColor;
  GdkPixmap* cpPixmap = 0;
  PanelAppletBackgroundType result = panel_applet_get_background(const_cast<PanelApplet*>(gobj()), &cColor, &cpPixmap);

  //This must be copied, because it is a local instance here that will be automatically deleted.
  color = Glib::wrap(&cColor, true /* take_copy */);

  //This seems to come from a gdk_pixmap_new(), in the source code, so it doesn't need an extra ref.
  //However, the C function is undocumented, and seems to be unused.
  //Normally the documentation would say whether it should be reffed and/or unreffed by the caller.
  pixmap = Glib::wrap((GdkPixmapObject*)cpPixmap); //, true /* take_copy */);  //We need the cast because the C type is not a real type.

  return (AppletBackgroundType)result;
}

void Applet::set_size_hints(const Glib::ArrayHandle<int>& size_hints, int base_size)
{
  panel_applet_set_size_hints(gobj(), size_hints.data(), size_hints.size(), base_size);
}

void Applet::gconf_set_list(const Glib::ustring& key, const Gnome::Conf::SListHandle_ValueBool& list)
{
  GError *error = 0;
  panel_applet_gconf_set_list(gobj(), key.c_str(), GCONF_VALUE_BOOL, list.data(), &(error));
  if(error) ::Glib::Error::throw_exception(error);
}

void Applet::gconf_set_list(const Glib::ustring& key, const Gnome::Conf::SListHandle_ValueInt& list)
{
  GError *error = 0;
  panel_applet_gconf_set_list(gobj(), key.c_str(), GCONF_VALUE_INT, list.data(), &(error));
  if(error) ::Glib::Error::throw_exception(error);
}

void Applet::gconf_set_list(const Glib::ustring& key, const Gnome::Conf::SListHandle_ValueString& list)
{
  GError *error = 0;
  panel_applet_gconf_set_list(gobj(), key.c_str(), GCONF_VALUE_STRING, list.data(), &(error));
  if(error) ::Glib::Error::throw_exception(error);
}

void Applet::gconf_set_list(const Glib::ustring& key, const Gnome::Conf::SListHandle_ValueFloat& list)
{
  GError *error = 0;
  panel_applet_gconf_set_list(gobj(), key.c_str(), GCONF_VALUE_FLOAT, list.data(), &(error));
  if(error) ::Glib::Error::throw_exception(error);
}

Gnome::Conf::SListHandle_ValueBool Applet::gconf_get_bool_list(const Glib::ustring& key) const
{
  GError *error = 0;
  return Gnome::Conf::SListHandle_ValueBool(panel_applet_gconf_get_list(const_cast<PanelApplet*>(gobj()), key.c_str(), GCONF_VALUE_BOOL, &(error)), Glib::OWNERSHIP_NONE);
  if(error) ::Glib::Error::throw_exception(error);
}

Gnome::Conf::SListHandle_ValueInt Applet::gconf_get_int_list(const Glib::ustring& key) const
{
  GError *error = 0;
  return Gnome::Conf::SListHandle_ValueInt(panel_applet_gconf_get_list(const_cast<PanelApplet*>(gobj()), key.c_str(), GCONF_VALUE_INT, &(error)), Glib::OWNERSHIP_NONE);
  if(error) ::Glib::Error::throw_exception(error);
}

Gnome::Conf::SListHandle_ValueString Applet::gconf_get_string_list(const Glib::ustring& key) const
{
  GError *error = 0;
  return Gnome::Conf::SListHandle_ValueString(panel_applet_gconf_get_list(const_cast<PanelApplet*>(gobj()), key.c_str(), GCONF_VALUE_STRING, &(error)), Glib::OWNERSHIP_NONE);
  if(error) ::Glib::Error::throw_exception(error);
}

Gnome::Conf::SListHandle_ValueFloat Applet::gconf_get_float_list(const Glib::ustring& key) const
{
  GError *error = 0;
  return Gnome::Conf::SListHandle_ValueFloat(panel_applet_gconf_get_list(const_cast<PanelApplet*>(gobj()), key.c_str(), GCONF_VALUE_FLOAT, &(error)), Glib::OWNERSHIP_NONE);
  if(error) ::Glib::Error::throw_exception(error);
}

} //namespace Panel

} //namespace Gnome


namespace
{


static void Applet_signal_change_orientation_callback(PanelApplet* self, PanelAppletOrient p0,void* data)
{
  using namespace Gnome::Panel;
  typedef sigc::slot< void,AppletOrient > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))((AppletOrient)(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Applet_signal_change_orientation_info =
{
  "change_orient",
  (GCallback) &Applet_signal_change_orientation_callback,
  (GCallback) &Applet_signal_change_orientation_callback
};


static void Applet_signal_change_size_callback(PanelApplet* self, guint p0,void* data)
{
  using namespace Gnome::Panel;
  typedef sigc::slot< void,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))((int)(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Applet_signal_change_size_info =
{
  "change_size",
  (GCallback) &Applet_signal_change_size_callback,
  (GCallback) &Applet_signal_change_size_callback
};


static void Applet_signal_change_background_callback(PanelApplet* self, PanelAppletBackgroundType p0,GdkColor* p1,GdkPixmap* p2,void* data)
{
  using namespace Gnome::Panel;
  typedef sigc::slot< void,AppletBackgroundType,const Gdk::Color &,const Glib::RefPtr<const Gdk::Pixmap>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))((AppletBackgroundType)(p0)
, Glib::wrap(p1, true)
, Glib::wrap((GdkPixmapObject*)(p2), true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Applet_signal_change_background_info =
{
  "change_background",
  (GCallback) &Applet_signal_change_background_callback,
  (GCallback) &Applet_signal_change_background_callback
};


static void Applet_signal_move_focus_out_of_applet_callback(PanelApplet* self, GtkDirectionType p0,void* data)
{
  using namespace Gnome::Panel;
  typedef sigc::slot< void,Gtk::DirectionType > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(((Gtk::DirectionType)(p0))
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Applet_signal_move_focus_out_of_applet_info =
{
  "move_focus_out_of_applet",
  (GCallback) &Applet_signal_move_focus_out_of_applet_callback,
  (GCallback) &Applet_signal_move_focus_out_of_applet_callback
};


} // anonymous namespace


namespace Glib
{

Gnome::Panel::Applet* wrap(PanelApplet* object, bool take_copy)
{
  return dynamic_cast<Gnome::Panel::Applet *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace Panel
{


/* The *_Class implementation: */

const Glib::Class& Applet_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Applet_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(panel_applet_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Applet_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->change_orient = &change_orient_callback;
  klass->change_size = &change_size_callback;
  klass->change_background = &change_background_callback;
  klass->move_focus_out_of_applet = &move_focus_out_of_applet_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Applet_Class::change_orient_callback(PanelApplet* self, PanelAppletOrient p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_change_orientation((AppletOrient)(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->change_orient)
    (*base->change_orient)(self, p0);
}
void Applet_Class::change_size_callback(PanelApplet* self, guint p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_change_size((int)(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->change_size)
    (*base->change_size)(self, p0);
}
void Applet_Class::change_background_callback(PanelApplet* self, PanelAppletBackgroundType p0, GdkColor* p1, GdkPixmap* p2)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_change_background((AppletBackgroundType)(p0)
, Glib::wrap(p1, true)
, Glib::wrap((GdkPixmapObject*)(p2), true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->change_background)
    (*base->change_background)(self, p0, p1, p2);
}
void Applet_Class::move_focus_out_of_applet_callback(PanelApplet* self, GtkDirectionType p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_move_focus_out_of_applet(((Gtk::DirectionType)(p0))
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->move_focus_out_of_applet)
    (*base->move_focus_out_of_applet)(self, p0);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Applet_Class::wrap_new(GObject* o)
{
  return manage(new Applet((PanelApplet*)(o)));

}


/* The implementation: */

Applet::Applet(const Glib::ConstructParams& construct_params)
:
  Gtk::EventBox(construct_params)
{
  }

Applet::Applet(PanelApplet* castitem)
:
  Gtk::EventBox((GtkEventBox*)(castitem))
{
  }

Applet::~Applet()
{
  destroy_();
}

Applet::CppClassType Applet::applet_class_; // initialize static member

GType Applet::get_type()
{
  return applet_class_.init().get_type();
}

GType Applet::get_base_type()
{
  return panel_applet_get_type();
}


Applet::Applet()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Gtk::EventBox(Glib::ConstructParams(applet_class_.init()))
{
  

}

int Applet::get_size() const
{
  return (int)(panel_applet_get_size(const_cast<PanelApplet*>(gobj())));
}

bool Applet::get_locked_down() const
{
  return panel_applet_get_locked_down(const_cast<PanelApplet*>(gobj()));
}

void Applet::request_focus(guint32 timestamp)
{
panel_applet_request_focus(gobj(), timestamp); 
}

void Applet::set_background_widget(Gtk::Widget& widget)
{
panel_applet_set_background_widget(gobj(), (widget).gobj()); 
}

Glib::ustring Applet::get_preferences_key() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(panel_applet_get_preferences_key(const_cast<PanelApplet*>(gobj())));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Applet::add_preferences(const Glib::ustring& schema_dir)
#else
void Applet::add_preferences(const Glib::ustring& schema_dir, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  panel_applet_add_preferences(gobj(), schema_dir.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

AppletFlags Applet::get_flags() const
{
  return (AppletFlags)(panel_applet_get_flags(const_cast<PanelApplet*>(gobj())));
}

void Applet::set_flags(AppletFlags flags)
{
panel_applet_set_flags(gobj(), (PanelAppletFlags)(flags)); 
}

BonoboControl* Applet::get_control()
{
  return panel_applet_get_control(gobj());
}

const BonoboControl* Applet::get_control() const
{
  return (panel_applet_get_control(const_cast<PanelApplet*>(gobj())));
}

BonoboUIComponent* Applet::get_popup_component()
{
  return panel_applet_get_popup_component(gobj());
}

const BonoboUIComponent* Applet::get_popup_component() const
{
  return (panel_applet_get_popup_component(const_cast<PanelApplet*>(gobj())));
}

void Applet::setup_menu(const Glib::ArrayHandle<Glib::ustring>& xml, const BonoboUIVerb* verb_list, gpointer user_data)
{
panel_applet_setup_menu(gobj(), (const gchar*)(xml.data()), verb_list, user_data); 
}

void Applet::setup_menu(const Glib::ustring& xml, const BonoboUIVerb* verb_list, gpointer user_data)
{
panel_applet_setup_menu(gobj(), xml.c_str(), verb_list, user_data); 
}

void Applet::setup_menu(const Glib::ustring& opt_datadir, const Glib::ustring& file, const Glib::ustring& opt_app_name, const BonoboUIVerb* verb_list, gpointer user_data)
{
panel_applet_setup_menu_from_file(gobj(), opt_datadir.c_str(), file.c_str(), opt_app_name.c_str(), verb_list, user_data); 
}

Glib::ustring Applet::gconf_get_full_key(const Glib::ustring& key) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(panel_applet_gconf_get_full_key(const_cast<PanelApplet*>(gobj()), key.c_str()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Applet::gconf_set(const Glib::ustring& key, bool the_bool)
#else
void Applet::gconf_set(const Glib::ustring& key, bool the_bool, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  panel_applet_gconf_set_bool(gobj(), key.c_str(), static_cast<int>(the_bool), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Applet::gconf_set(const Glib::ustring& key, int the_int)
#else
void Applet::gconf_set(const Glib::ustring& key, int the_int, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  panel_applet_gconf_set_int(gobj(), key.c_str(), the_int, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Applet::gconf_set(const Glib::ustring& key, const Glib::ustring& the_string)
#else
void Applet::gconf_set(const Glib::ustring& key, const Glib::ustring& the_string, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  panel_applet_gconf_set_string(gobj(), key.c_str(), the_string.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Applet::gconf_set(const Glib::ustring& key, double the_float)
#else
void Applet::gconf_set(const Glib::ustring& key, double the_float, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  panel_applet_gconf_set_float(gobj(), key.c_str(), the_float, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Applet::gconf_set(const Glib::ustring& key, const Gnome::Conf::Value& value)
#else
void Applet::gconf_set(const Glib::ustring& key, const Gnome::Conf::Value& value, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  panel_applet_gconf_set_value(gobj(), key.c_str(), const_cast<GConfValue*>(value.gobj()), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Applet::gconf_get_bool(const Glib::ustring& key) const
#else
bool Applet::gconf_get_bool(const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = panel_applet_gconf_get_bool(const_cast<PanelApplet*>(gobj()), key.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
int Applet::gconf_get_int(const Glib::ustring& key) const
#else
int Applet::gconf_get_int(const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  int retvalue = panel_applet_gconf_get_int(const_cast<PanelApplet*>(gobj()), key.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring Applet::gconf_get_string(const Glib::ustring& key) const
#else
Glib::ustring Applet::gconf_get_string(const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::ustring retvalue = Glib::convert_return_gchar_ptr_to_ustring(panel_applet_gconf_get_string(const_cast<PanelApplet*>(gobj()), key.c_str(), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
double Applet::gconf_get_float(const Glib::ustring& key) const
#else
double Applet::gconf_get_float(const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  double retvalue = panel_applet_gconf_get_float(const_cast<PanelApplet*>(gobj()), key.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Gnome::Conf::Value Applet::gconf_get_value(const Glib::ustring& key) const
#else
Gnome::Conf::Value Applet::gconf_get_value(const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Gnome::Conf::Value retvalue = Gnome::Conf::Value(panel_applet_gconf_get_value(const_cast<PanelApplet*>(gobj()), key.c_str(), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}


Glib::SignalProxy1< void,AppletOrient > Applet::signal_change_orientation()
{
  return Glib::SignalProxy1< void,AppletOrient >(this, &Applet_signal_change_orientation_info);
}


Glib::SignalProxy1< void,int > Applet::signal_change_size()
{
  return Glib::SignalProxy1< void,int >(this, &Applet_signal_change_size_info);
}


Glib::SignalProxy3< void,AppletBackgroundType,const Gdk::Color &,const Glib::RefPtr<const Gdk::Pixmap>& > Applet::signal_change_background()
{
  return Glib::SignalProxy3< void,AppletBackgroundType,const Gdk::Color &,const Glib::RefPtr<const Gdk::Pixmap>& >(this, &Applet_signal_change_background_info);
}


Glib::SignalProxy1< void,Gtk::DirectionType > Applet::signal_move_focus_out_of_applet()
{
  return Glib::SignalProxy1< void,Gtk::DirectionType >(this, &Applet_signal_move_focus_out_of_applet_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Applet::property_name() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "name");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Applet::property_name() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "name");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Applet::property_width_request() 
{
  return Glib::PropertyProxy<int>(this, "width-request");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Applet::property_width_request() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "width-request");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Applet::property_height_request() 
{
  return Glib::PropertyProxy<int>(this, "height-request");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Applet::property_height_request() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "height-request");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Applet::property_visible() 
{
  return Glib::PropertyProxy<bool>(this, "visible");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_visible() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "visible");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Applet::property_sensitive() 
{
  return Glib::PropertyProxy<bool>(this, "sensitive");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_sensitive() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "sensitive");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Applet::property_app_paintable() 
{
  return Glib::PropertyProxy<bool>(this, "app-paintable");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_app_paintable() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "app-paintable");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Applet::property_can_focus() 
{
  return Glib::PropertyProxy<bool>(this, "can-focus");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_can_focus() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "can-focus");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Applet::property_has_focus() 
{
  return Glib::PropertyProxy<bool>(this, "has-focus");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_has_focus() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "has-focus");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Applet::property_is_focus() 
{
  return Glib::PropertyProxy<bool>(this, "is-focus");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_is_focus() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "is-focus");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Applet::property_can_default() 
{
  return Glib::PropertyProxy<bool>(this, "can-default");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_can_default() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "can-default");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Applet::property_has_default() 
{
  return Glib::PropertyProxy<bool>(this, "has-default");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_has_default() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "has-default");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Applet::property_receives_default() 
{
  return Glib::PropertyProxy<bool>(this, "receives-default");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_receives_default() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "receives-default");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_composite_child() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "composite-child");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Applet::property_no_show_all() 
{
  return Glib::PropertyProxy<bool>(this, "no-show-all");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_no_show_all() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "no-show-all");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Applet::property_border_width() 
{
  return Glib::PropertyProxy<int>(this, "border-width");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Applet::property_border_width() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "border-width");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Applet::property_visible_window() 
{
  return Glib::PropertyProxy<bool>(this, "visible-window");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_visible_window() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "visible-window");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Applet::property_above_child() 
{
  return Glib::PropertyProxy<bool>(this, "above-child");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Applet::property_above_child() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "above-child");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Gtk::Style> Applet::property_style() 
{
  return Glib::PropertyProxy<Gtk::Style>(this, "style");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Gtk::Style> Applet::property_style() const
{
  return Glib::PropertyProxy_ReadOnly<Gtk::Style>(this, "style");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::Object> Applet::property_parent() 
{
  return Glib::PropertyProxy<Glib::Object>(this, "parent");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::Object> Applet::property_parent() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::Object>(this, "parent");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_WriteOnly<Glib::Object> Applet::property_child() 
{
  return Glib::PropertyProxy_WriteOnly<Glib::Object>(this, "child");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gnome::Panel::Applet::on_change_orientation(AppletOrient orient)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->change_orient)
    (*base->change_orient)(gobj(),(PanelAppletOrient)(orient));
}
void Gnome::Panel::Applet::on_change_size(int size)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->change_size)
    (*base->change_size)(gobj(),(guint)(size));
}
void Gnome::Panel::Applet::on_change_background(AppletBackgroundType type, const Gdk::Color & color, const Glib::RefPtr<const Gdk::Pixmap>& pixmap)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->change_background)
    (*base->change_background)(gobj(),(PanelAppletBackgroundType)(type),const_cast<GdkColor*>((color).gobj()),const_cast<GdkPixmap*>(Glib::unwrap(pixmap)));
}
void Gnome::Panel::Applet::on_move_focus_out_of_applet(Gtk::DirectionType direction)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->move_focus_out_of_applet)
    (*base->move_focus_out_of_applet)(gobj(),((GtkDirectionType)(direction)));
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Panel

} // namespace Gnome


