#include "osl/search/threatmateState.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::search;

class SearchThreatmateStateTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(SearchThreatmateStateTest);
  CPPUNIT_TEST(testConstruction);
  CPPUNIT_TEST(testTransition);
  CPPUNIT_TEST_SUITE_END();
public:
  void testConstruction() {
    ThreatmateState s;
    CPPUNIT_ASSERT_EQUAL(ThreatmateState::UNKNOWN, s.status());
  }
  void testTransition() {
    ThreatmateState t;
    t.setThreatmate(ThreatmateState::THREATMATE);
    CPPUNIT_ASSERT_EQUAL(ThreatmateState::THREATMATE, t.status());

    ThreatmateState mc(t.newStatus(false));
    CPPUNIT_ASSERT_EQUAL(ThreatmateState::MAY_HAVE_CHECKMATE, mc.status());
    
    ThreatmateState ct(t.newStatus(true));
    CPPUNIT_ASSERT_EQUAL(ThreatmateState::CHECK_AFTER_THREATMATE, ct.status());

    ThreatmateState u(ct.newStatus(true));
    CPPUNIT_ASSERT_EQUAL(ThreatmateState::UNKNOWN, u.status());

    ThreatmateState mc2(ct.newStatus(false));
    CPPUNIT_ASSERT_EQUAL(ThreatmateState::MAYBE_THREATMATE, mc2.status());
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(SearchThreatmateStateTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
