#include "osl/hash/hashKey.h"
#include "osl/record/record.h"
#include "osl/record/csaRecord.h"
#include "osl/oslConfig.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <fstream>
#include <sstream>
#include <map>

using namespace osl;

class HashKeyTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(HashKeyTest);
  CPPUNIT_TEST(testDump);
  CPPUNIT_TEST(testPass);
  CPPUNIT_TEST(testFiles);
  CPPUNIT_TEST(testMultiMap);
  CPPUNIT_TEST_SUITE_END();
public:
  void testDump();
  void testFiles();
  void testPass() { 
    const HashKey key;
    const HashKey key_black_pass = key.newHashWithMove(Move::PASS(BLACK));
    CPPUNIT_ASSERT(key != key_black_pass); 
    const HashKey key_white_pass = key.newHashWithMove(Move::PASS(WHITE));
    CPPUNIT_ASSERT(key != key_white_pass); 
  }
  void testMultiMap()
  {
    std::multimap<HashKey, int> table;
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(HashKeyTest);

void HashKeyTest::testDump()
{
  SimpleState state(HIRATE);
  HashKey key(state);
  HashKey null_key;
  CPPUNIT_ASSERT(null_key != key);
  
  std::ostringstream ss;
  key.dumpContents(ss);
  HashKey key2 = HashKey::readFromDump(ss.str());
  CPPUNIT_ASSERT_EQUAL(key, key2);
}

void HashKeyTest::testFiles(){
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  int i=0;
  std::string filename;
  while ((ifs >> filename) && ++i<100) {
    if (filename == "") 
      break;

    Record rec=CsaFile(OslConfig::testCsaFile(filename)).getRecord();
    NumEffectState state(rec.getInitialState());
    const vector<osl::Move> moves=rec.getMoves();

    HashKey key(state);
    for (size_t i=0;i<moves.size();i++)
    {
      const HashKey next = key.newHashWithMove(moves[i]);
      {
	HashKey copy = key;
	copy = copy.newMakeMove(moves[i]);
	CPPUNIT_ASSERT_EQUAL(copy, next);
	CPPUNIT_ASSERT_EQUAL(copy.newUnmakeMove(moves[i]), key);
      }

      key = key.newHashWithMove(moves[i]);
      state.makeMove(moves[i]);
      
      const HashKey batch(state);
      CPPUNIT_ASSERT_EQUAL(batch, next);
      CPPUNIT_ASSERT_EQUAL(key, next);      
    }
  }
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
