/* square.cc
 */
#include "osl/square.h"
#include <boost/static_assert.hpp>
#include <iostream>

BOOST_STATIC_ASSERT(sizeof(osl::Square) == 4);

bool osl::Square::isOnBoardSlow() const 
{
    return (1<=x() && x() <=9 
	    && 1<=y() && y() <=9);
}

bool osl::Square::isValid() const
{
  return isPieceStand() || isOnBoard();
}

const osl::Square osl::
Square::squareForBlackSlow(Player player) const
{
  if (player == BLACK) 
    return *this;
  return Square(reverseX(x()),reverseY(y()));
}

std::ostream& osl::operator<<(std::ostream& os, Square square)
{
  if (square.isPieceStand())
    return os << "OFF";
  return os << "Square(" << square.x() << square.y() << ")";
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
