#include "osl/record/record.h"
#include "osl/record/csaIOError.h"
#include "osl/apply_move/applyMove.h"
#include <stack>
#include <iostream>

osl::record::
MoveRecord::MoveRecord(const Move& mv, int ni)
  : move(mv), nodeIndex(ni), time(0)
{
}

namespace osl
{
namespace record
{
  IRecordStream::~IRecordStream(){}
  
  ORecordStream::~ORecordStream(){}
  
  const Move MoveRecord::getMove() const { return move; }
  
  int MoveRecord::getNodeIndex() const { return nodeIndex; }
  
  void MoveRecord::setTime(int t){
    time=t;
  }
  
  void NodeRecord::addMoveRecord(int moveIndex){
    moves.push_back(moveIndex);
  }
  
  
  Record::Record(){ init(); }
  
  void Record::init(){
    version="";
    playerNames[0]=playerNames[1]="";
    nrs.clear();
    nrs.push_back(NodeRecord());
    initialState.init(HIRATE);
    result = UNKNOWN;
  }

  void Record::load(IRecordStream& irs){
    irs.load(this);
  }
  void Record::save(ORecordStream& /*irs*/){
    // irs.save(this);
  }
  
  void Record::setVersion(const std::string& str){
    version=str;
  }
  void Record::setPlayer(Player player,const std::string& str){
    playerNames[player]=str;
  }
  const std::string& Record::getPlayer(Player player) const{
    return playerNames[player];
  }
  void Record::setInitialState(const SimpleState& state){
    initialState=state;
    initialState.initPawnMask();
  }
  const NumEffectState Record::getInitialState() const {
    if (! initialState.isConsistent(true))
    {
      const char *msg = "Record: bad initial state";
      std::cerr << msg << " " << __FILE__ << " " << __LINE__ << "\n";
      throw CsaIOError(msg);
    }
    return NumEffectState(initialState);
  }
  int Record::addNodeRecord(){
    nrs.push_back(NodeRecord());
    return nrs.size()-1;
  }
  int Record::addMoveRecord(const MoveRecord& moveRecord){
    mrs.push_back(moveRecord);
    return mrs.size()-1;
  }
  NodeRecord* Record::nodeOf(int index){
    return &nrs.at(index);
  }
  const NodeRecord* Record::nodeOf(int index) const{
    return &nrs.at(index);
  }
  MoveRecord* Record::moveOf(int index){
    if (static_cast<size_t>(index) >= mrs.size())
      return NULL;
    else
      return &mrs.at(index);
  }
  const MoveRecord* Record::moveOf(int index) const {
    if (static_cast<size_t>(index) >= mrs.size())
      return NULL;
    else
      return &mrs.at(index);
  }
  NodeRecord& Record::operator[](int index){
    return nrs.at(index);
  }
  
  void RecordVisitor::addMoveAndAdvance(Move move){
    assert(state->isValidMove(move));

    int newNode=rec->addNodeRecord();
    int newMove=rec->addMoveRecord(MoveRecord(move,newNode));
    (*rec)[nodeIndex].addMoveRecord(newMove);
    nodeIndex=newNode;
    lastMoveIndex=newMove;

    assert(state->isConsistent() || ((std::cerr << move <<"\n"<< *state),0));
    ApplyMoveOfTurn::doMove(*state, move);
    assert(state->isConsistent() || ((std::cerr << move <<"\n"<< *state),0));
    for(boost::ptr_vector<record::RecordVisitorObserver>::iterator each = observers.begin(); each != observers.end(); ++each){ 
      each->update(this); 
    }
  }
  
  
  std::ostream& operator<<(std::ostream& os,const MoveRecord & mr){
    return os << "MoveRecord(" << // mr.getMove() << ',' <<
      mr.getNodeIndex()  << ')';
  }
#ifndef MINIMAL  
  std::ostream& operator<<(std::ostream& os,Record & r){
    os << "Record(";
    os << "version=" << r.getVersion()
       << ",BLACK=" << r.getPlayer(BLACK)
       << ",WHITE=" << r.getPlayer(WHITE);
    os << ",initial=" << std:: endl << r.getInitialState() << std::endl;
    SimpleState initial_state=r.getInitialState();
    SimpleState state=initial_state;
    RecordVisitor visitor;
    visitor.setState(&state);
    visitor.setRecord(&r);
    NodeRecord* node=visitor.getNode();
    while(node->size()>0){
      int moveIndex=node->at(0);
      MoveRecord* mr=r.moveOf(moveIndex);
      Move move=mr->getMove();
      os << move << "," << mr->getTime() << "," << mr->getComment() << std::endl;
      node=r.nodeOf(mr->getNodeIndex());
      ApplyMoveOfTurn::doMove(state, move);
      assert(state.isConsistent());
    }
    os << state;
    os << initial_state;
    return os << ')';
  }
#endif  
  
  const vector<Move> Record::getMoves() const {
    vector<Move> moves;
    vector<int> dummy_time;
    getMoves(moves, dummy_time);
    return moves;
  }

  int readInt(std::istream& is)
  {
    int ret=0;
    CArray<char,4> cs;
    is.read(&cs[0],4);
    for (int i=0;i<4;i++) {
      ret = (ret<<8)|(cs[i]&255);
    }
    return ret;
  }
  
  void
  writeInt(std::ostream& os, int n)
  {
    CArray<char,4> buf;
    for (int i = 0; i < 4; i++)
      {
	buf[i] = (n >> (8 * (4 - i - 1))) & 255;
      }
    os.write(&buf[0], 4);
  }

} // namespace record
} // namespace osl

void osl::record::
Record::getMoves(vector<Move>& moves, vector<int>& times,
		 vector<std::string>& comments,
		 vector<SearchInfo>& info) const 
{
  const NodeRecord* node=nodeOf(0);
  while(node->size()>0){
    const int moveIndex=node->at(0);
    const MoveRecord* mr=moveOf(moveIndex);
    const Move move=mr->getMove();
    moves.push_back(move);
    times.push_back(mr->getTime());
    comments.push_back(mr->getComment());
    info.push_back(mr->info);

    node=nodeOf(mr->getNodeIndex());
  }
}

void osl::record::
Record::getMoves(vector<Move>& moves, vector<int>& times) const 
{
  vector<std::string> dummy_comments;
  vector<SearchInfo> dummy_info;
  getMoves(moves, times, dummy_comments, dummy_info);
}

osl::record::
RecordVisitor::~RecordVisitor()
{
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
