#include "osl/piece.h"
#include "osl/move.h"
#include <boost/static_assert.hpp>
#include <iostream>

namespace osl
{
  BOOST_STATIC_ASSERT(sizeof(Move) == 4);
} //namespace osl

bool osl::Move::isValid() const
{
  if (! isNormal())
    return false;
  const Position from = this->from();
  if (! from.isValid())
    return false;
  const Position to = this->to();
  if (! to.isOnBoard())
    return false;
  return osl::isValid(ptype())
    && osl::isValid(capturePtype())
    && capturePtype()!=KING
    && osl::isValid(player());
}

const osl::Move osl::Move::rotate180() const
{
  if (isPass())
    return Move::PASS(alt(player()));
  if (! isNormal())
    return *this;
  return Move(from().rotate180Safe(), to().rotate180(), ptype(),
	      capturePtype(), isPromote(), alt(player()));
}

std::ostream& osl::operator<<(std::ostream& os,const Move move)
{
  if (move == Move::DeclareWin())
    return os << "MOVE_DECLARE_WIN";
  if (move.isInvalid())
    return os << "MOVE_INVALID";
  if (move.isPass())
    return os << "MOVE_PASS";
  const Player turn = move.player();
  if (move.isValid())
  {
    if (move.from().isPieceStand()) 
    {
      os << "Drop(" << turn << "," << move.ptype() << "," << move.to() << ")";
    }
    else
    {
      const Ptype capture_ptype=move.capturePtype();
      os << "Move(" << turn << "," << move.ptype() << "," 
	 << move.from() << "->" << move.to() ;
      if (move.promoteMask())
	os << ",promote";
      if (capture_ptype != PTYPE_EMPTY)
	os << ",capture=" << capture_ptype;
      os << ")";
    }
  }
  else
  {
    os << "InvalidMove " << move.from() << " " << move.to() 
       << " " << move.ptypeO() << " " << move.oldPtypeO()
       << " " << move.promoteMask()
       << " " << move.capturePtype() << "\n";
  }
  return os;
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
