# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AR;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20181205223701;

my $formatters = [
                {
                  'national_rule' => '0$1',
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[68]',
                  'pattern' => '([68]\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'pattern' => '(\\d{2})(\\d{4})',
                  'national_rule' => '$1',
                  'leading_digits' => '[2-9]',
                  'format' => '$1-$2',
                  'intl_format' => 'NA'
                },
                {
                  'leading_digits' => '[2-9]',
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'national_rule' => '$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'national_rule' => '$1',
                  'leading_digits' => '[2-9]',
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'national_rule' => '0$1',
                  'intl_format' => '$1 $2 $3-$4',
                  'format' => '$2 15-$3-$4',
                  'leading_digits' => '911',
                  'pattern' => '(9)(11)(\\d{4})(\\d{4})'
                },
                {
                  'leading_digits' => '
            9(?:
              2(?:
                2(?:
                  0[013-9]|
                  [13]
                )|
                3(?:
                  0[013-9]|
                  [67]
                )|
                49|
                6(?:
                  [0136]|
                  4[0-59]
                )|
                8|
                9(?:
                  [19]|
                  44|
                  7[013-9]|
                  8[14]
                )
              )|
              3(?:
                36|
                4(?:
                  [12]|
                  3(?:
                    4|
                    5[014]|
                    6[1-39]
                  )|
                  [58]4
                )|
                5(?:
                  1|
                  3[0-24-689]|
                  8[46]
                )|
                6|
                7[069]|
                8(?:
                  [01]|
                  34|
                  [578][45]
                )
              )
            )
          ',
                  'intl_format' => '$1 $2 $3-$4',
                  'format' => '$2 15-$3-$4',
                  'national_rule' => '0$1',
                  'pattern' => '(9)(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'leading_digits' => '9[23]',
                  'format' => '$2 15-$3-$4',
                  'intl_format' => '$1 $2 $3-$4',
                  'national_rule' => '0$1',
                  'pattern' => '(9)(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'pattern' => '(11)(\\d{4})(\\d{4})',
                  'national_rule' => '0$1',
                  'format' => '$1 $2-$3',
                  'leading_digits' => '11'
                },
                {
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})',
                  'leading_digits' => '
            2(?:
              2(?:
                0[013-9]|
                [13]
              )|
              3(?:
                0[013-9]|
                [67]
              )|
              49|
              6(?:
                [0136]|
                4[0-59]
              )|
              8|
              9(?:
                [19]|
                44|
                7[013-9]|
                8[14]
              )
            )|
            3(?:
              36|
              4(?:
                [12]|
                3(?:
                  4|
                  5[014]|
                  6[1-39]
                )|
                [58]4
              )|
              5(?:
                1|
                3[0-24-689]|
                8[46]
              )|
              6|
              7[069]|
              8(?:
                [01]|
                34|
                [578][45]
              )
            )
          ',
                  'format' => '$1 $2-$3',
                  'national_rule' => '0$1'
                },
                {
                  'leading_digits' => '[23]',
                  'format' => '$1 $2-$3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'leading_digits' => '
            1[0-2]|
            911
          ',
                  'intl_format' => 'NA',
                  'format' => '$1',
                  'national_rule' => '$1',
                  'pattern' => '(\\d{3})'
                }
              ];

my $validators = {
                'geographic' => '
          11\\d{8}|
          (?:
            2(?:
              2(?:
                [013]\\d|
                2[13-79]|
                4[1-6]|
                5[2457]|
                6[124-8]|
                7[1-4]|
                8[13-6]|
                9[1267]
              )|
              3(?:
                [07]\\d|
                1[467]|
                2[03-6]|
                3[13-8]|
                [49][2-6]|
                5[2-8]|
                6[013-9]
              )|
              4(?:
                7[3-8]|
                9\\d
              )|
              6(?:
                [01346]\\d|
                2[24-6]|
                5[15-8]
              )|
              80\\d|
              9(?:
                [012789]\\d|
                3[1-6]|
                4[02-9]|
                5[234]|
                6[2-46]
              )
            )|
            3(?:
              3(?:
                2[79]|
                6\\d|
                8[2578]
              )|
              4(?:
                0[0124-9]|
                [1-357]\\d|
                4[24-7]|
                6[02-9]|
                8[0-79]|
                9[1236-8]
              )|
              5(?:
                [138]\\d|
                2[1245]|
                4[1-9]|
                6[2-4]|
                7[1-6]
              )|
              6[24]\\d|
              7(?:
                [069]\\d|
                1[1568]|
                2[013-9]|
                3[145]|
                4[0-35-9]|
                5[14-8]|
                7[2-57]|
                8[0-24-9]
              )|
              8(?:
                [01578]\\d|
                2[15-7]|
                3[0-24-9]|
                4[13-6]|
                6[1-357-9]|
                9[124]
              )
            )|
            670\\d
          )\\d{6}
        ',
                'toll_free' => '800\\d{7}',
                'specialrate' => '(60[04579]\\d{7})|(810\\d{7})',
                'personal_number' => '',
                'fixed_line' => '
          11\\d{8}|
          (?:
            2(?:
              2(?:
                [013]\\d|
                2[13-79]|
                4[1-6]|
                5[2457]|
                6[124-8]|
                7[1-4]|
                8[13-6]|
                9[1267]
              )|
              3(?:
                [07]\\d|
                1[467]|
                2[03-6]|
                3[13-8]|
                [49][2-6]|
                5[2-8]|
                6[013-9]
              )|
              4(?:
                7[3-8]|
                9\\d
              )|
              6(?:
                [01346]\\d|
                2[24-6]|
                5[15-8]
              )|
              80\\d|
              9(?:
                [012789]\\d|
                3[1-6]|
                4[02-9]|
                5[234]|
                6[2-46]
              )
            )|
            3(?:
              3(?:
                2[79]|
                6\\d|
                8[2578]
              )|
              4(?:
                0[0124-9]|
                [1-357]\\d|
                4[24-7]|
                6[02-9]|
                8[0-79]|
                9[1236-8]
              )|
              5(?:
                [138]\\d|
                2[1245]|
                4[1-9]|
                6[2-4]|
                7[1-6]
              )|
              6[24]\\d|
              7(?:
                [069]\\d|
                1[1568]|
                2[013-9]|
                3[145]|
                4[0-35-9]|
                5[14-8]|
                7[2-57]|
                8[0-24-9]
              )|
              8(?:
                [01578]\\d|
                2[15-7]|
                3[0-24-9]|
                4[13-6]|
                6[1-357-9]|
                9[124]
              )
            )|
            670\\d
          )\\d{6}
        ',
                'mobile' => '
          675\\d{7}|
          9(?:
            11[2-9]\\d{7}|
            (?:
              2(?:
                2[013]|
                3[067]|
                49|
                6[01346]|
                80|
                9[147-9]
              )|
              3(?:
                36|
                4[12358]|
                5[138]|
                6[24]|
                7[069]|
                8[013578]
              )
            )[2-9]\\d{6}|
            \\d{4}[2-9]\\d{5}
          )
        ',
                'pager' => '',
                'voip' => ''
              };
my %areanames = (
  5411 => "Buenos\ Aires",
  54220 => "Merlo\,\ Buenos\ Aires",
  542202 => "González\ Catán\/Virrey\ del\ Pino\,\ Buenos\ Aires",
  54221 => "La\ Plata\,\ Buenos\ Aires",
  542221 => "Magdalena\/Verónica\,\ Buenos\ Aires",
  542223 => "Brandsen\,\ Buenos\ Aires",
  542224 => "Glew\/Guernica\,\ Buenos\ Aires",
  542225 => "Alejandro\ Korn\,\ Buenos\ Aires",
  542226 => "Cañuelas\,\ Buenos\ Aires",
  542227 => "Lobos\,\ Buenos\ Aires",
  542229 => "Juan\ María\ Gutiérrez\/El\ Pato\,\ Buenos\ Aires",
  54223 => "Mar\ del\ Plata\,\ Buenos\ Aires",
  542241 => "Chascomús\,\ Buenos\ Aires",
  542242 => "Lezama\,\ Buenos\ Aires",
  542243 => "General\ Belgrano\,\ Buenos\ Aires",
  542244 => "Las\ Flores\,\ Buenos\ Aires",
  542245 => "Dolores\,\ Buenos\ Aires",
  542246 => "Santa\ Teresita\,\ Buenos\ Aires",
  542252 => "San\ Clemente\ del\ Tuyú\,\ Buenos\ Aires",
  542254 => "Pinamar\,\ Buenos\ Aires",
  542255 => "Villa\ Gesell\,\ Buenos\ Aires",
  542257 => "Mar\ de\ Ajó\,\ Buenos\ Aires",
  542261 => "Lobería\,\ Buenos\ Aires",
  542262 => "Necochea\,\ Buenos\ Aires",
  542264 => "La\ Dulce\ \(Nicanor\ Olivera\)\,\ Buenos\ Aires",
  542265 => "Coronel\ Vidal\,\ Buenos\ Aires",
  542266 => "Balcarce\,\ Buenos\ Aires",
  542267 => "General\ Juan\ Madariaga\,\ Buenos\ Aires",
  542268 => "Maipú\,\ Buenos\ Aires",
  542271 => "San\ Miguel\ del\ Monte\,\ Buenos\ Aires",
  542272 => "Navarro\,\ Buenos\ Aires",
  542273 => "Carmen\ de\ Areco\,\ Buenos\ Aires",
  542274 => "Carlos\ Spegazzini\,\ Buenos\ Aires",
  542281 => "Azul\,\ Buenos\ Aires",
  542283 => "Tapalqué\,\ Buenos\ Aires",
  542284 => "Olavarría\,\ Buenos\ Aires",
  542285 => "Laprida\,\ Buenos\ Aires",
  542286 => "General\ La\ Madrid\,\ Buenos\ Aires",
  542291 => "Miramar\,\ Buenos\ Aires",
  542292 => "Benito\ Juárez\,\ Buenos\ Aires",
  542296 => "Ayacucho\,\ Buenos\ Aires",
  542297 => "Rauch\,\ Buenos\ Aires",
  54230 => "Pilar\,\ Buenos\ Aires",
  542302 => "General\ Pico\,\ La\ Pampa",
  542314 => "Bolívar\,\ Buenos\ Aires",
  542316 => "Daireaux\,\ Buenos\ Aires",
  542317 => "9\ de\ Julio\,\ Buenos\ Aires",
  542320 => "José\ C\.\ Paz\,\ Buenos\ Aires",
  542323 => "Luján\,\ Buenos\ Aires",
  542324 => "Mercedes\,\ Buenos\ Aires",
  542325 => "San\ Andrés\ de\ Giles\,\ Buenos\ Aires",
  542326 => "San\ Antonio\ de\ Areco\,\ Buenos\ Aires",
  542331 => "Realicó\,\ La\ Pampa",
  542333 => "Quemú\ Quemú\,\ La\ Pampa",
  542334 => "Eduardo\ Castex\,\ La\ Pampa",
  542335 => "Realicó\/Rancul\ Dept\.\,\ La\ Pampa",
  542336 => "Huinca\ Renancó\/Villa\ Huidobro\,\ Córdoba",
  542337 => "América\/Rivadavia\,\ Buenos\ Aires",
  542338 => "Victorica\,\ La\ Pampa",
  542342 => "Bragado\,\ Buenos\ Aires",
  542343 => "Norberto\ de\ La\ Riestra\,\ Buenos\ Aires",
  542344 => "Saladillo\,\ Buenos\ Aires",
  542345 => "25\ de\ Mayo\,\ Buenos\ Aires",
  542346 => "Chivilcoy\,\ Buenos\ Aires",
  542352 => "Chacabuco\,\ Buenos\ Aires",
  542353 => "General\ Arenales\,\ Buenos\ Aires",
  542354 => "Vedia\,\ Buenos\ Aires",
  542355 => "Lincoln\,\ Buenos\ Aires",
  542356 => "General\ Pinto\,\ Buenos\ Aires",
  542357 => "Carlos\ Tejedor\,\ Buenos\ Aires",
  542358 => "Los\ Toldos\,\ Buenos\ Aires",
  54236 => "Junín\,\ Buenos\ Aires",
  54237 => "Moreno\,\ Buenos\ Aires",
  542392 => "Trenque\ Lauquen\,\ Buenos\ Aires",
  542393 => "Salazar\,\ Buenos\ Aires",
  542394 => "Tres\ Lomas\/Salliqueló\,\ Buenos\ Aires",
  542395 => "Carlos\ Casares\,\ Buenos\ Aires",
  542396 => "Pehuajó\,\ Buenos\ Aires",
  542473 => "Colón\,\ Buenos\ Aires",
  542474 => "Salto\,\ Buenos\ Aires",
  542475 => "Rojas\,\ Buenos\ Aires",
  542477 => "Pergamino\,\ Buenos\ Aires",
  542478 => "Arrecifes\,\ Buenos\ Aires",
  54249 => "Tandil\,\ Buenos\ Aires",
  54260 => "San\ Rafael\,\ Mendoza",
  54261 => "Mendoza\,\ Mendoza",
  542622 => "Tunuyán\,\ Mendoza",
  542624 => "Uspallata\,\ Mendoza",
  542625 => "General\ Alvear\,\ Mendoza",
  542626 => "La\ Paz\,\ Mendoza",
  54263 => "San\ Martín\,\ Mendoza",
  54264 => "San\ Juan\,\ San\ Juan",
  542646 => "Villa\ San\ Agustín\,\ San\ Juan",
  542647 => "San\ José\ de\ Jáchal\,\ San\ Juan",
  542648 => "Calingasta\,\ San\ Juan",
  542651 => "San\ Francisco\ del\ Monte\ de\ Oro\,\ San\ Luis",
  542652 => "San\ Luis\ Province",
  542655 => "La\ Toma\,\ San\ Luis",
  542656 => "Merlo\,\ San\ Luis",
  542657 => "Villa\ Mercedes\,\ San\ Luis",
  542658 => "Buena\ Esperanza\,\ San\ Luis",
  54266 => "San\ Luis\,\ San\ Luis",
  54280 => "Trelew\/Rawson\,\ Chubut",
  542901 => "Ushuaia\,\ Tierra\ del\ Fuego",
  542902 => "Río\ Turbio\,\ Santa\ Cruz",
  542903 => "Río\ Mayo\,\ Chubut",
  54291 => "Bahía\ Blanca\,\ Buenos\ Aires",
  542920 => "Viedma\,\ Río\ Negro",
  542921 => "Coronel\ Dorrego\,\ Buenos\ Aires",
  542922 => "Coronel\ Pringles\,\ Buenos\ Aires",
  542923 => "Pigüé\,\ Buenos\ Aires",
  542924 => "Darregueira\,\ Buenos\ Aires",
  542925 => "Villa\ Iris\,\ Buenos\ Aires",
  542926 => "Coronel\ Suárez\,\ Buenos\ Aires",
  542927 => "Médanos\,\ Buenos\ Aires",
  542928 => "Pedro\ Luro\,\ Buenos\ Aires",
  542929 => "Guaminí\,\ Buenos\ Aires",
  542931 => "Río\ Colorado\,\ Río\ Negro",
  542932 => "Punta\ Alta\,\ Buenos\ Aires",
  542933 => "Huanguelén\,\ Buenos\ Aires",
  542934 => "San\ Antonio\ Oeste\,\ Río\ Negro",
  542935 => "Rivera\,\ Buenos\ Aires",
  542936 => "Carhué\,\ Buenos\ Aires",
  54294 => "San\ Carlos\ de\ Bariloche\,\ Río\ Negro",
  542940 => "Ingeniero\ Jacobacci\,\ Río\ Negro",
  542942 => "Zapala\,\ Neuquén",
  542945 => "Esquel\,\ Chubut",
  542946 => "Choele\ Choel\,\ Río\ Negro",
  542948 => "Chos\ Malal\,\ Neuquén",
  542952 => "General\ Acha\,\ La\ Pampa",
  542953 => "Macachín\,\ La\ Pampa",
  542954 => "Santa\ Rosa\,\ La\ Pampa",
  542962 => "Puerto\ San\ Julián\,\ Santa\ Cruz",
  542963 => "Perito\ Moreno\,\ Santa\ Cruz",
  542964 => "Río\ Grande\,\ Tierra\ del\ Fuego",
  542966 => "Río\ Gallegos\,\ Santa\ Cruz",
  54297 => "Comodoro\ Rivadavia\,\ Chubut",
  542972 => "San\ Martín\ de\ los\ Andes\,\ Neuquén",
  54298 => "General\ Roca\,\ Río\ Negro",
  542982 => "Claromecó\,\ Buenos\ Aires",
  54298240 => "Orense\,\ Buenos\ Aires",
  54298242 => "Orense\,\ Buenos\ Aires",
  542982497 => "San\ Francisco\ de\ Bellocq\,\ Buenos\ Aires",
  542983 => "Tres\ Arroyos\,\ Buenos\ Aires",
  54299 => "Neuquén\,\ Neuquén",
  543327 => "Benavídez\,\ Buenos\ Aires",
  543329 => "San\ Pedro\,\ Buenos\ Aires",
  54336 => "San\ Nicolás\,\ Buenos\ Aires",
  543382 => "Rufino\,\ Santa\ Fe",
  543385 => "Laboulaye\,\ Córdoba",
  543387 => "Buchardo\,\ Córdoba",
  543388 => "General\ Villegas\,\ Buenos\ Aires",
  543400 => "Villa\ Constitución\,\ Santa\ Fe",
  543401 => "El\ Trébol\,\ Santa\ Fe",
  543402 => "Arroyo\ Seco\,\ Santa\ Fe",
  543404 => "Las\ Colonias\ Dept\.\,\ Santa\ Fe",
  543405 => "San\ Javier\,\ Santa\ Fe",
  543406 => "San\ Jorge\,\ Santa\ Fe",
  543407 => "Ramallo\,\ Buenos\ Aires",
  543408 => "San\ Cristóbal\,\ Santa\ Fe",
  543409 => "Moisés\ Ville\,\ Santa\ Fe",
  54341 => "Rosario\,\ Santa\ Fe",
  54342 => "Santa\ Fe\,\ Santa\ Fe",
  54343 => "Paraná\,\ Entre\ Ríos",
  543435 => "Nogoyá\,\ Entre\ Ríos",
  543436 => "Victoria\,\ Entre\ Ríos",
  543437 => "La\ Paz\,\ Entre\ Ríos",
  543438 => "Bovril\,\ Entre\ Ríos",
  543442 => "Concepción\ del\ Uruguay\,\ Entre\ Ríos",
  543444 => "Gualeguay\,\ Entre\ Ríos",
  543445 => "Rosario\ del\ Tala\,\ Entre\ Ríos",
  543446 => "Gualeguaychú\,\ Entre\ Ríos",
  543447 => "Colón\,\ Entre\ Ríos",
  54345 => "Concordia\,\ Entre\ Ríos",
  543454 => "Federal\,\ Entre\ Ríos",
  543455 => "Villaguay\,\ Entre\ Ríos",
  543456 => "Chajarí\,\ Entre\ Ríos",
  543458 => "San\ José\ de\ Feliciano\,\ Entre\ Ríos",
  543460 => "Santa\ Teresa\,\ Santa\ Fe",
  543462 => "Venado\ Tuerto\,\ Santa\ Fe",
  543463 => "Canals\,\ Córdoba",
  543464 => "Casilda\,\ Santa\ Fe",
  543465 => "Firmat\,\ Santa\ Fe",
  543466 => "Barrancas\,\ Santa\ Fe",
  543467 => "Cruz\ Alta\,\ Córdoba\/San\ José\ de\ la\ Esquina\,\ Santa\ Fe",
  543468 => "Corral\ de\ Bustos\,\ Córdoba",
  543469 => "Acebal\,\ Santa\ Fe",
  543471 => "Cañada\ de\ Gómez\,\ Santa\ Fe",
  543472 => "Marcos\ Juárez\,\ Córdoba",
  543476 => "San\ Lorenzo\,\ Santa\ Fe",
  54348 => "Escobar\,\ Buenos\ Aires",
  543482 => "Reconquista\,\ Santa\ Fe",
  543483 => "Vera\,\ Santa\ Fe",
  543487 => "Zárate\,\ Buenos\ Aires",
  543489 => "Campana\,\ Buenos\ Aires",
  543491 => "Ceres\,\ Santa\ Fe",
  543492 => "Rafaela\,\ Santa\ Fe",
  543493 => "Sunchales\,\ Santa\ Fe",
  543496 => "Esperanza\,\ Santa\ Fe",
  543497 => "Llambi\ Campbell\,\ Santa\ Fe",
  543498 => "San\ Justo\,\ Santa\ Fe",
  54351 => "Córdoba\,\ Córdoba",
  543521 => "Deán\ Funes\,\ Córdoba",
  543522 => "Villa\ de\ María\,\ Córdoba",
  543524 => "Villa\ del\ Totoral\,\ Córdoba",
  543525 => "Jesús\ María\,\ Córdoba",
  54353 => "Villa\ María\,\ Córdoba",
  543532 => "Oliva\,\ Córdoba",
  543533 => "Las\ Varillas\,\ Córdoba",
  543537 => "Bell\ Ville\,\ Córdoba",
  543541 => "Villa\ Carlos\ Paz\,\ Córdoba",
  543542 => "Salsacate\,\ Córdoba",
  543543 => "Córdoba\ \(Argüello\)\,\ Córdoba",
  543544 => "Villa\ Dolores\,\ Córdoba",
  543546 => "Santa\ Rosa\ de\ Calamuchita\,\ Córdoba",
  543547 => "Alta\ Gracia\,\ Córdoba",
  543548 => "La\ Falda\,\ Córdoba",
  543549 => "Cruz\ del\ Eje\,\ Córdoba",
  543562 => "Morteros\,\ Córdoba",
  543563 => "Balnearia\,\ Córdoba",
  543564 => "San\ Francisco\,\ Córdoba",
  543571 => "Río\ Tercero\,\ Córdoba",
  543572 => "Río\ Segundo\,\ Córdoba",
  543573 => "Villa\ del\ Rosario\,\ Córdoba",
  543574 => "Río\ Primero\,\ Córdoba",
  543575 => "La\ Puerta\,\ Córdoba",
  543576 => "Arroyito\,\ Córdoba",
  54358 => "Río\ Cuarto\,\ Córdoba",
  543582 => "Sampacho\,\ Córdoba",
  543583 => "Vicuña\ Mackenna\,\ Córdoba",
  543584 => "La\ Carlota\,\ Córdoba",
  543585 => "Adelia\ María\,\ Córdoba",
  54362 => "Resistencia\,\ Chaco",
  54364 => "Presidencia\ Roque\ Sáenz\ Peña\,\ Chaco",
  54370 => "Formosa\,\ Formosa",
  543711 => "Ingeniero\ Juárez\,\ Formosa",
  543715 => "Las\ Lomitas\,\ Formosa",
  543716 => "Comandante\ Fontana\,\ Formosa",
  543718 => "Clorinda\,\ Formosa",
  543721 => "Charadai\,\ Chaco",
  543725 => "General\ José\ de\ San\ Martín\,\ Chaco",
  543731 => "Charata\,\ Chaco",
  543734 => "Machagai\/Presidencia\ de\ la\ Plaza\,\ Chaco",
  543735 => "Villa\ Ángela\,\ Chaco",
  543741 => "Bernardo\ de\ Irigoyen\,\ Misiones",
  543743 => "Puerto\ Rico\,\ Misiones",
  543751 => "Eldorado\,\ Misiones",
  543754 => "Leandro\ N\.\ Alem\,\ Misiones",
  543755 => "Oberá\,\ Misiones",
  543756 => "Santo\ Tomé\,\ Corrientes",
  543757 => "Puerto\ Iguazú\,\ Misiones",
  543758 => "Apóstoles\,\ Misiones",
  54376 => "Posadas\,\ Misiones",
  543772 => "Paso\ de\ los\ Libres\,\ Corrientes",
  543773 => "Mercedes\,\ Corrientes",
  543774 => "Curuzú\ Cuatiá\,\ Corrientes",
  543775 => "Monte\ Caseros\,\ Corrientes",
  543777 => "Goya\,\ Corrientes",
  543781 => "Caá\ Catí\,\ Corrientes",
  543782 => "Saladas\,\ Corrientes",
  543786 => "Ituzaingó\,\ Corrientes",
  54379 => "Corrientes\,\ Corrientes",
  54380 => "La\ Rioja\,\ La\ Rioja",
  54381 => "San\ Miguel\ de\ Tucumán\,\ Tucumán",
  543821 => "Chepes\,\ La\ Rioja",
  543825 => "Chilecito\,\ La\ Rioja",
  543826 => "Chamical\,\ La\ Rioja",
  543827 => "Aimogasta\,\ La\ Rioja",
  54383 => "San\ Fernando\ del\ Valle\ de\ Catamarca\,\ Catamarca",
  543832 => "Recreo\,\ Catamarca",
  543835 => "Andalgalá\,\ Catamarca",
  543837 => "Tinogasta\,\ Catamarca",
  543838 => "Santa\ María\,\ Catamarca",
  543841 => "Monte\ Quemado\,\ Santiago\ del\ Estero",
  543843 => "Quimilí\,\ Santiago\ del\ Estero",
  543844 => "Añatuya\,\ Santiago\ del\ Estero",
  543845 => "Loreto\,\ Santiago\ del\ Estero",
  543846 => "Tintina\,\ Santiago\ del\ Estero",
  54385 => "Santiago\ del\ Estero\,\ Santiago\ del\ Estero",
  543854 => "Frías\,\ Santiago\ del\ Estero",
  543855 => "Suncho\ Corral\,\ Santiago\ del\ Estero",
  543856 => "Villa\ Ojo\ de\ Agua\,\ Santiago\ del\ Estero",
  543857 => "Bandera\,\ Santiago\ del\ Estero",
  543858 => "Termas\ de\ Río\ Hondo\,\ Santiago\ del\ Estero",
  543861 => "Nueva\ Esperanza\,\ Santiago\ del\ Estero",
  543862 => "Trancas\,\ Tucumán",
  543863 => "Monteros\,\ Tucumán",
  543865 => "Concepción\,\ Tucumán",
  543867 => "Tafí\ del\ Valle\,\ Tucumán",
  543868 => "Cafayate\,\ Salta",
  543869 => "Ranchillos\ y\ San\ Miguel\,\ Tucumán",
  54387 => "Salta\,\ Salta",
  543873 => "Tartagal\,\ Salta",
  543876 => "San\ José\ de\ Metán\,\ Salta",
  543877 => "Joaquín\ Víctor\ González\,\ Salta",
  543878 => "Orán\,\ Salta",
  54388 => "San\ Salvador\ de\ Jujuy\,\ Jujuy",
  543885 => "La\ Quiaca\,\ Jujuy",
  543886 => "Libertador\ General\ San\ Martín\,\ Jujuy",
  543887 => "Humahuaca\,\ Jujuy",
  543888 => "San\ Pedro\ de\ Jujuy\,\ Jujuy",
  543891 => "Graneros\,\ Tucumán",
  543892 => "Amaicha\ del\ Valle\,\ Tucumán",
  543894 => "Burruyacú\,\ Tucumán",
);
    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+54|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:0?(?:(11|2(?:2(?:02?|[13]|2[13-79]|4[1-6]|5[2457]|6[124-8]|7[1-4]|8[13-6]|9[1267])|3(?:02?|1[467]|2[03-6]|3[13-8]|[49][2-6]|5[2-8]|[67])|4(?:7[3-578]|9)|6(?:[0136]|2[24-6]|4[6-8]?|5[15-8])|80|9(?:0[1-3]|[19]|2\d|3[1-6]|4[02568]?|5[2-4]|6[2-46]|72?|8[23]?))|3(?:3(?:2[79]|6|8[2578])|4(?:0[0-24-9]|[12]|3[5-8]?|4[24-7]|5[4-68]?|6[02-9]|7[126]|8[2379]?|9[1-36-8])|5(?:1|2[1245]|3[237]?|4[1-46-9]|6[2-4]|7[1-6]|8[2-5]?)|6[24]|7(?:[069]|1[1568]|2[15]|3[145]|4[13]|5[14-8]|7[2-57]|8[126])|8(?:[01]|2[15-7]|3[2578]?|4[13-6]|5[4-8]?|6[1-357-9]|7[36-8]?|8[5-8]?|9[124])))?15)?)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/9$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;