package ru.novosoft.uml.gen;

import java.io.*;
import java.util.*;

import javax.xml.parsers.*;

import org.w3c.dom.*;
import org.xml.sax.*;

import ru.novosoft.uml.gen.mmm.*;

/** 
  * This is very rough UML API generator. It has too many
  * assumptions about models. But it should work on supplied
  * data.
  *
  * I think it will be completely rewritten by next
  * maintainer.
  */
public class GenMM implements ErrorHandler
{
  public static String VERSION_NUMBER = System.getProperty("genmm.version","0.4.0");
  public static String VERSION = "Novosoft UML API for Java. Version "+VERSION_NUMBER;

  public static String ROOT_PACKAGE = "ru.novosoft.uml";
  public static String RESOURCE_ROOT = "/ru/novosoft/uml/gen/resources";
  
  Properties plurals = new Properties(); 
  String outputDirectory = System.getProperty("genmm.outputdirectory",new File("..","gen").toString());

  String collectionsPackage = System.getProperty("genmm.collections","java.util");
  public String getCollectionsPackage()
  {
    return collectionsPackage;
  }

  HashMap name2type = new HashMap();

  MPackage root;
  public MPackage getRootPackage()
  {
    return root;
  }

  GenMM(String args[]) 
  {
    try
    {
      System.out.println(VERSION);
      System.out.println("Reading plural names ...");
      InputStream pin = getClass().getResourceAsStream(RESOURCE_ROOT+"/plurals.txt");
      try
      {
        if (pin != null)
        {
          plurals.load(pin);
        }
      }
      finally
      {
        pin.close();
      }
      System.out.println("Reading meta-model ...");
      // get DOM tree
      System.out.println("* Building DOM tree...");

      DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
      dbf.setNamespaceAware(false);
      dbf.setValidating(true);

      DocumentBuilder db = dbf.newDocumentBuilder();
      Document doc = db.parse(getClass().getResource(RESOURCE_ROOT+"/metamodel.xml").toString());

      // first pass, create classes
      System.out.println("* DOM tree pass 1 ...");
      getTypes(doc.getDocumentElement());

      // second pass, create packages, attributes and associations
      System.out.println("* DOM tree pass 2 ...");

      NodeList nodes = doc.getDocumentElement().getChildNodes();
      for (int i=nodes.getLength()-1;i>=0;i--)
      {
        Node n = nodes.item(i);
        if (n instanceof Element)
        {
          Element ne = (Element)n;
          root = processPackage(ne);
          break;
        }
      }
      // perform generation
      System.out.println("Starting generator (output directory: "+outputDirectory+") ... ");
      Iterator i = name2type.values().iterator();
      while (i.hasNext())
      {
        MClass c = (MClass)i.next();
        if (c instanceof MEnum)
        {
          System.out.println("generating enum: "+c.getName());
          new GenMMEnum(this, (MEnum)c);
        }
        if (c instanceof MElement)
        {
          System.out.println("generating element: "+c.getName());
          new GenMMClass(this, (MElement)c);
          new GenMMClassImpl(this, (MElement)c);
        }
      }
      System.out.println("generating XMIReader");
      new GenMMXMIReader(this, name2type);
      //System.out.println("generating XMIReaderDOM");
      //new GenMMXMIReaderDOM(this, name2type);
      System.out.println("generating XMIWriter");
      new GenMMXMIWriter(this, name2type);
      System.out.println("generating MFactory");
      new GenMMFactory(this, name2type);
      System.out.println("generating MFactoryImpl");
      new GenMMFactoryImpl(this, name2type);
      System.out.println("finished generation.");
    }
    catch(Exception ex)
    {
      ex.printStackTrace(System.out);
    }
  }
  
  MPackage processPackage(Element e)
  {
    MPackage rc = new MPackage();
    rc.setName(e.getAttribute("name"));
    NodeList nodes = e.getChildNodes();
    for (int i=nodes.getLength()-1;i>=0;i--)
    {
      Node n = nodes.item(i);
      if (n instanceof Element)
      {
        Element ne = (Element)n;
        String nenm = ne.getNodeName();
        if (nenm.equals("element"))
        {
          rc.addElement(processElement(ne));
        }
        else if (nenm.equals("association"))
        {
          rc.addElement(processAssociation(ne));
        }
        else if (nenm.equals("package"))
        {
          rc.addElement(processPackage(ne));
        }
        else if (nenm.equals("primitive"))
        {
          rc.addElement(processPrimitive(ne));
        }
        else if (nenm.equals("datatype"))
        {
          rc.addElement(processDatatype(ne));
        }
        else if (nenm.equals("enumeration"))
        {
          rc.addElement(processEnumeration(ne));
        }
        else
        {
          System.out.println("ERROR: unknown element type: "+nenm);
        }
      }
    }
    return rc;
  }

  MRole processRole(Element e)
  {
    MRole rc = new MRole();
    rc.setType((MClass)name2type.get(e.getAttribute("type")));
    rc.setName(e.getAttribute("name"));
    rc.setXMIName(e.getAttribute("xmi.name"));
    rc.setKind(e.getAttribute("kind"));
    rc.setComposite(e.getAttribute("composite").equals("true"));
    rc.setNavigable(e.getAttribute("navigable").equals("true"));
    return rc;
  }
  
  MAssociation processAssociation(Element e)
  {
    MAssociation a = new MAssociation();
    NodeList roles = e.getElementsByTagName("role");
    MRole r1 = processRole((Element)roles.item(0));
    MRole r2 = processRole((Element)roles.item(1));
    if ("list".equals(r2.getKind()) && "list".equals(r1.getKind()))
    {
      System.out.println("ERROR: could not handle situation when both ends of association are lists: "+r1.getName()+" - "+r2.getName());
    }
    a.addRole(r1);
    a.addRole(r2);
    return a;
  }
  
  MElement processElement(Element e)
  {
    MElement rc = (MElement)name2type.get(e.getAttribute("name"));
    int i;
    rc.setAbstract(e.getAttribute("abstract").equals("true"));
    NodeList scs = e.getElementsByTagName("superclass");
    for (i=scs.getLength()-1;i>=0;i--)
    {
      Element esc = (Element)scs.item(i);
      MClass sc = (MClass)name2type.get(esc.getAttribute("type"));
      rc.addSuperClass(sc);
    }
    NodeList ats = e.getElementsByTagName("attribute");
    for (i=ats.getLength()-1;i>=0;i--)
    {
      Element eat = (Element)ats.item(i);
      MAttribute at = new MAttribute();
      at.setName(eat.getAttribute("name"));
      MClass atc = (MClass)name2type.get(eat.getAttribute("type"));
      at.setType(atc);
      rc.addAttribute(at);
    }
    return rc;
  }
  MDataType processDatatype(Element e)
  {
    MDataType rc = (MDataType)name2type.get(e.getAttribute("name"));
    NodeList scs = e.getElementsByTagName("superclass");
    int i;
    for (i=scs.getLength()-1;i>=0;i--)
    {
      Element esc = (Element)scs.item(i);
      MClass sc = (MClass)name2type.get(esc.getAttribute("type"));
      rc.addSuperClass(sc);
    }

    NodeList ats = e.getElementsByTagName("attribute");
    for (i=ats.getLength()-1;i>=0;i--)
    {
      Element eat = (Element)ats.item(i);
      MAttribute at = new MAttribute();
      at.setName(eat.getAttribute("name"));
      MClass atc = (MClass)name2type.get(eat.getAttribute("type"));
      at.setType(atc);
      rc.addAttribute(at);
    }
    return rc;
  }

  MEnum processEnumeration(Element e)
  {
    MEnum rc = (MEnum)name2type.get(e.getAttribute("name"));
    NodeList literals = e.getElementsByTagName("literal");
    int i;
    for (i=literals.getLength()-1;i>=0;i--)
    {
      Element el = (Element)literals.item(i);
      MEnumLiteral l = new MEnumLiteral();
      l.setName(el.getAttribute("name"));
      rc.addLiteral(l);
    }
    return rc;
  }
    
  MPrimitive processPrimitive(Element e)
  {
    MPrimitive rc = (MPrimitive)name2type.get(e.getAttribute("name"));
    // do nothing
    return rc;
  }

  void getTypes(Element mm)
  {
    int i;
    NodeList primitives = mm.getElementsByTagName("primitive");
    for (i=primitives.getLength()-1;i>=0;i--)
    {
      Element ec = (Element)primitives.item(i);
      MPrimitive c = new MPrimitive();
      c.setName(ec.getAttribute("name"));
      name2type.put(c.getName(),c);
    }
    NodeList datatypes = mm.getElementsByTagName("datatype");
    for (i=datatypes.getLength()-1;i>=0;i--)
    {
      Element ec = (Element)datatypes.item(i);
      MDataType c = new MDataType();
      c.setName(ec.getAttribute("name"));
      name2type.put(c.getName(),c);
    }
    NodeList enumerations = mm.getElementsByTagName("enumeration");
    for (i=enumerations.getLength()-1;i>=0;i--)
    {
      Element ec = (Element)enumerations.item(i);
      MEnum c = new MEnum();
      c.setName(ec.getAttribute("name"));
      name2type.put(c.getName(),c);
    }
    NodeList elements = mm.getElementsByTagName("element");
    for (i=elements.getLength()-1;i>=0;i--)
    {
      Element ec = (Element)elements.item(i);
      MElement c = new MElement();
      c.setName(ec.getAttribute("name"));
      name2type.put(c.getName(),c);
    }
  }

  public File getFileName(String pkg, String file)
  {
    StringTokenizer stk = new StringTokenizer(pkg, ".", false);
    File rc = new File(outputDirectory); 
    while (stk.hasMoreTokens())
    {
      String tk = stk.nextToken();
      rc = new File(rc, tk);
    }
    rc.mkdirs();
    return new File(rc, file);
  }

  public String getPlural(String a)
  {
    String rc = plurals.getProperty(a);
    if (rc == null)
    {
      if (a.endsWith("sh") ||
          a.endsWith("ch") ||
          a.endsWith("z") ||
          a.endsWith("x") ||
          a.endsWith("s"))
      {
        rc = a+"es";
      }
      else
      {
        rc = a+"s";
      }
      plurals.put(a,rc);
      System.out.println("WARNING: Unspecified plural name, using default: "+a+"="+rc);
    }
    return rc;
  }

  public static void main (String args[]) 
  {
    new GenMM(args);
  }

  // XML parser error handlers

  public void warning(SAXParseException ex) 
  {
    System.err.println("[Warning] "+getLocationString(ex)+": "+ex.getMessage());
  }

  public void error(SAXParseException ex) 
  {
    System.err.println("[Error] "+getLocationString(ex)+": "+ex.getMessage());
  }

  public void fatalError(SAXParseException ex) throws SAXException 
  {
    System.err.println("[Fatal Error] "+getLocationString(ex)+": "+ex.getMessage());
    throw ex;
  }

  private String getLocationString(SAXParseException ex) 
  {
    StringBuffer str = new StringBuffer();

    String systemId = ex.getSystemId();
    if (systemId != null)
    {
      str.append(systemId);
    }
    str.append(':');
    str.append(ex.getLineNumber());
    str.append(':');
    str.append(ex.getColumnNumber());

    return str.toString();
  }
}
