#ifndef _HAVE_NSS_MYSQL_H
#define _HAVE_NSS_MYSQL_H

static char nss_mysql_version[] = "NSS-MySQL version 0.43";

#include <mysql.h>
#include <sys/types.h>
#include <pthread.h>

struct connection_options {
        char * host;
        char * database;
        char * dbuser;
        char * dbpasswd;
        char * backup_host;
        char * backup_database;
        char * backup_dbuser;
        char * backup_dbpasswd;
};

struct mysql_auth {
        MYSQL * mysql; /* MySQL connection */
        pid_t pid; /* pid of the process who launched the MySQL connexcion */
        pthread_mutex_t * mutex; /* mutex protecting the connexion */
};

struct query {
        const char * name;
        uid_t uid;
        gid_t gid;
        int bulk; /* true if we want all matching records */
};

#ifdef HAVE_NSSWITCH_H
#include <nss_common.h>
 
typedef nss_status_t NSS_STATUS;
 
#define NSS_STATUS_SUCCESS      NSS_SUCCESS
#define NSS_STATUS_NOTFOUND     NSS_NOTFOUND
#define NSS_STATUS_UNAVAIL      NSS_UNAVAIL
#define NSS_STATUS_TRYAGAIN     NSS_TRYAGAIN

#else
#include <nss.h>

typedef enum nss_status NSS_STATUS;

#endif

#ifdef PTHREAD_MUTEX_INITIALIZER_NEEDS_BRACKETS
        #define NSS_MYSQL_PTHREAD_MUTEX_INITIALIZER {{PTHREAD_MUTEX_INITIALIZER}}
#else
        #define NSS_MYSQL_PTHREAD_MUTEX_INITIALIZER PTHREAD_MUTEX_INITIALIZER
#endif

#endif /* _HAVE_NSS_MYSQL_H */
