// $Id: analytic_function.C 4123 2010-12-01 15:55:07Z roystgnr $

// The libMesh Finite Element Library.
// Copyright (C) 2002-2008 Benjamin S. Kirk, John W. Peterson, Roy H. Stogner
  
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
  
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
  
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA



// C++ includes


// Local Includes
#include "analytic_function.h"

namespace libMesh
{



//------------------------------------------------------------------
// AnalyticFunction methods
AnalyticFunction::AnalyticFunction (Number fptr(const Point& p,
						const Real time)) :
  FunctionBase (),
  _number_fptr (fptr)
{
  libmesh_assert (fptr != NULL);
  this->_initialized = true;
}




AnalyticFunction::AnalyticFunction (void fptr(DenseVector<Number>& output,
					      const Point& p,
					      const Real time)) :
  FunctionBase (),
  _vector_fptr (fptr)
{
  libmesh_assert (fptr != NULL);
  this->_initialized = true;
}




AnalyticFunction::~AnalyticFunction ()
{
}





void AnalyticFunction::init ()
{
  // dumb double-test
  libmesh_assert ((_number_fptr != NULL) || (_vector_fptr != NULL));

  // definitely ready
  this->_initialized = true;
}



void AnalyticFunction::clear ()
{
  // We probably need a method to reset these later...
  _number_fptr = NULL;
  _vector_fptr = NULL;

  // definitely not ready
  this->_initialized = false;
}


} // namespace libMesh
